/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.structures;

import builderb0y.autocodec.annotations.DefaultInt;
import builderb0y.autocodec.annotations.MemberUsage;
import builderb0y.autocodec.annotations.SingletonArray;
import builderb0y.autocodec.annotations.UseName;
import builderb0y.autocodec.annotations.UseVerifier;
import builderb0y.autocodec.annotations.VerifyFloatRange;
import builderb0y.autocodec.annotations.VerifyNotEmpty;
import builderb0y.autocodec.annotations.VerifyNullable;
import builderb0y.autocodec.coders.AutoCoder;
import builderb0y.autocodec.verifiers.VerifyContext;
import builderb0y.autocodec.verifiers.VerifyException;
import builderb0y.bigglobe.blocks.BlockStates;
import builderb0y.bigglobe.chunkgen.BigGlobeScriptedChunkGenerator;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import builderb0y.bigglobe.columns.scripted.ColumnScript;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.math.Interpolator;
import builderb0y.bigglobe.math.pointSequences.SphericalPointIterator;
import builderb0y.bigglobe.noise.Grid3D;
import builderb0y.bigglobe.noise.NumberArray;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.randomLists.IRandomList;
import builderb0y.bigglobe.randomSources.RandomRangeVerifier;
import builderb0y.bigglobe.randomSources.RandomSource;
import builderb0y.bigglobe.structures.BigGlobeStructure;
import builderb0y.bigglobe.structures.BigGlobeStructures;
import builderb0y.bigglobe.structures.DataStructurePiece;
import builderb0y.bigglobe.structures.RawGenerationStructure;
import builderb0y.bigglobe.util.DelayedEntryList;
import builderb0y.bigglobe.util.Directions;
import builderb0y.bigglobe.util.Vectors;
import builderb0y.bigglobe.versions.ChunkVersions;
import builderb0y.bigglobe.versions.HeightLimitViewVersions;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.random.RandomGenerator;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3532;
import net.minecraft.class_3773;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6625;
import net.minecraft.class_7151;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class GeodeStructure
extends BigGlobeStructure
implements RawGenerationStructure {
    public static final MapCodec<GeodeStructure> CODEC = BigGlobeAutoCodec.AUTO_CODEC.createDFUMapCodec(GeodeStructure.class);
    public final Grid3D noise;
    public final @RandomRangeVerifier.VerifyRandomRange(min=0.0, minInclusive=false, max=112.0) RandomSource radius;
    public final BlocksConfig @VerifyNotEmpty @UseVerifier(name="verifySorted", in=BlocksConfig.class, usage=MemberUsage.METHOD_IS_HANDLER) [] blocks;
    public final SpikesConfig spikes;
    public final GrowthConfig @VerifyNullable @SingletonArray [] growth;

    public GeodeStructure(class_3195.class_7302 config, @VerifyNullable ColumnScript.ColumnToIntScript.Holder min_y, @VerifyNullable ColumnScript.ColumnToIntScript.Holder surface_y, Grid3D noise, RandomSource radius, BlocksConfig[] blocks, SpikesConfig spikes, GrowthConfig @VerifyNullable [] growth) {
        super(config, min_y, surface_y);
        this.noise = noise;
        this.radius = radius;
        this.blocks = blocks;
        this.spikes = spikes;
        this.growth = growth;
    }

    @Override
    public int bigglobe_getMaxRadiusInChunks() {
        return (int)(this.radius.maxValue() * 0.0625);
    }

    @Override
    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_2338 centerPos = this.randomBlockInChunk(context, this.radius.maxValue(), BigGlobeMath.ceilI(this.radius.maxValue()));
        if (centerPos == null) {
            return Optional.empty();
        }
        class_2794 class_27942 = context.comp_562();
        if (!(class_27942 instanceof BigGlobeScriptedChunkGenerator)) {
            return Optional.empty();
        }
        BigGlobeScriptedChunkGenerator generator = (BigGlobeScriptedChunkGenerator)class_27942;
        ScriptedColumn column = generator.newColumn(context.comp_569(), centerPos.method_10263(), centerPos.method_10260(), ScriptedColumn.ColumnUsage.GENERIC.maybeDhHints());
        Permuter permuter = new Permuter(context.comp_566().method_43055());
        double radius = this.radius.get(column, centerPos.method_10264(), permuter);
        long worldSeed = generator.columnSeed;
        return Optional.of(new class_3195.class_7150(centerPos, collector -> {
            double centerX = (double)centerPos.method_10263() + permuter.nextDouble();
            double centerY = (double)centerPos.method_10264() + permuter.nextDouble();
            double centerZ = (double)centerPos.method_10260() + permuter.nextDouble();
            MainPiece mainPiece = new MainPiece(BigGlobeStructures.GEODE_PIECE_TYPE, centerX, centerY, centerZ, radius, this.noise, this.blocks, this.growth);
            collector.method_35462((class_3443)mainPiece);
            SphericalPointIterator iterator = SphericalPointIterator.halton(permuter.nextInt() & 0xFFFF, 1.0);
            BlocksConfig lastConfig = this.blocks[this.blocks.length - 1];
            double secondLastThreshold = this.blocks.length > 1 ? this.blocks[this.blocks.length - 2].threshold : 0.0;
            Vector3d unit = new Vector3d();
            Vector3d point1 = new Vector3d();
            Vector3d point2 = new Vector3d();
            int spikeCount = (int)(radius * radius * this.spikes.commonness.get(column, centerPos.method_10264(), permuter));
            block0: for (int spikeIndex = 0; spikeIndex < spikeCount; ++spikeIndex) {
                iterator.next();
                unit.set(iterator.x(), iterator.y(), iterator.z());
                double minRadius = 0.0;
                double maxRadius = radius;
                for (int refine = 0; refine < 8; ++refine) {
                    double midRadius = (minRadius + maxRadius) * 0.5;
                    point1.set((Vector3dc)unit).mul(midRadius).add(centerX, centerY, centerZ);
                    double noise = mainPiece.getNoise(BigGlobeMath.floorI(point1.x), BigGlobeMath.floorI(point1.y), BigGlobeMath.floorI(point1.z), worldSeed);
                    if (noise > lastConfig.threshold) {
                        minRadius = midRadius;
                        continue;
                    }
                    if (noise < secondLastThreshold) {
                        maxRadius = midRadius;
                        continue;
                    }
                    point2.set((Vector3dc)unit).mul(-this.spikes.length.get(column, centerPos.method_10264(), permuter)).add((Vector3dc)point1).add((Vector3dc)Vectors.setInSphere(unit, (RandomGenerator)permuter, this.spikes.crookedness.get(column, centerPos.method_10264(), permuter)));
                    collector.method_35462((class_3443)new SpikePiece(BigGlobeStructures.GEODE_SPIKE_PIECE_TYPE, point1.x, point1.y, point1.z, this.spikes.large_radius.get(column, centerPos.method_10264(), permuter), point2.x, point2.y, point2.z, this.spikes.small_radius.get(column, centerPos.method_10264(), permuter), lastConfig.states));
                    continue block0;
                }
            }
        }));
    }

    public class_7151<?> method_41618() {
        return BigGlobeStructures.GEODE_TYPE;
    }

    public record BlocksConfig(@VerifyFloatRange(min=0.0, minInclusive=false) double threshold, IRandomList<@UseName(value="state") class_2680> states) {
        public static <T_Encoded> void verifySorted(VerifyContext<T_Encoded, BlocksConfig[]> context) throws VerifyException {
            BlocksConfig[] array = (BlocksConfig[])context.object;
            if (array == null || array.length == 0) {
                return;
            }
            double threshold = array[0].threshold;
            int length = array.length;
            for (int index = 1; index < length; ++index) {
                double newThreshold = array[index].threshold;
                if (!(newThreshold > threshold)) {
                    throw new VerifyException(() -> context.pathToStringBuilder().append(" must be sorted by threshold in ascending order.").toString());
                }
                threshold = newThreshold;
            }
        }

        public boolean contains(class_2680 state) {
            for (class_2680 compare : this.states) {
                if (compare != state) continue;
                return true;
            }
            return false;
        }
    }

    public record SpikesConfig(RandomSource large_radius, RandomSource small_radius, RandomSource length, RandomSource commonness, RandomSource crookedness) {
    }

    public record GrowthConfig(DelayedEntryList<class_2248> place, DelayedEntryList<class_2248> against) {
    }

    public static class MainPiece
    extends DataStructurePiece<Data>
    implements RawGenerationStructure.RawGenerationStructurePiece {
        public MainPiece(class_3773 type, double x, double y, double z, double radius, Grid3D noise, BlocksConfig[] blocks, GrowthConfig[] growth) {
            super(type, 0, new class_3341(BigGlobeMath.ceilI(x - radius), BigGlobeMath.ceilI(y - radius), BigGlobeMath.ceilI(z - radius), BigGlobeMath.floorI(x + radius), BigGlobeMath.floorI(y + radius), BigGlobeMath.floorI(z + radius)), new Data(x, y, z, 0, 0, 0, radius, noise, blocks, growth));
        }

        public MainPiece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }

        @Override
        public AutoCoder<Data> dataCoder() {
            return Data.CODER;
        }

        public double getNoise(int x, int y, int z, long seed) {
            return ((Data)this.data).noise.getValue(seed, x - ((Data)this.data).offsetX, y - ((Data)this.data).offsetY, z - ((Data)this.data).offsetZ) - BigGlobeMath.squareD((double)x - ((Data)this.data).x, (double)y - ((Data)this.data).y, (double)z - ((Data)this.data).z) * ((Data)this.data).noise.maxValue() / BigGlobeMath.squareD(((Data)this.data).radius);
        }

        @Override
        public void generateRaw(RawGenerationStructure.RawGenerationStructurePiece.Context context) {
            class_1923 chunkPos = context.chunk.method_12004();
            int minX = chunkPos.method_8326();
            int minY = Math.max(this.field_15315.method_35416(), HeightLimitViewVersions.getMinY((class_5539)context.chunk));
            int minZ = chunkPos.method_8328();
            int maxX = chunkPos.method_8327();
            int maxY = Math.min(this.field_15315.method_35419(), HeightLimitViewVersions.getMaxY((class_5539)context.chunk) - 1);
            int maxZ = chunkPos.method_8329();
            try (NumberArray samples = NumberArray.allocateDoublesDirect(maxY - minY + 1);){
                double rcpRadius = 1.0 / ((Data)this.data).radius;
                double noiseMax = ((Data)this.data).noise.maxValue();
                class_2338.class_2339 pos = new class_2338.class_2339();
                for (int z = minZ; z <= maxZ; ++z) {
                    pos.method_33099(z);
                    double rz = BigGlobeMath.squareD(((double)z - ((Data)this.data).z) * rcpRadius);
                    for (int x = minX; x <= maxX; ++x) {
                        pos.method_33097(x);
                        double rxz = rz + BigGlobeMath.squareD(((double)x - ((Data)this.data).x) * rcpRadius);
                        ((Data)this.data).noise.getBulkY(context.columnSeed, x - ((Data)this.data).offsetX, minY - ((Data)this.data).offsetY, z - ((Data)this.data).offsetZ, samples);
                        block7: for (int y = minY; y <= maxY; ++y) {
                            pos.method_33098(y);
                            double rxyz = rxz + BigGlobeMath.squareD(((double)y - ((Data)this.data).y) * rcpRadius);
                            double noise = samples.implGetD(y - minY);
                            noise -= rxyz * noiseMax;
                            if (!(noise > 0.0)) continue;
                            for (BlocksConfig block : ((Data)this.data).blocks) {
                                if (!(noise < block.threshold)) continue;
                                ChunkVersions.setBlockState(context.chunk, (class_2338)pos, block.states.getRandomElement(Permuter.permute(context.columnSeed ^ 0x84DA20CB58CD2DFBL, x, y, z)), 2);
                                continue block7;
                            }
                            ChunkVersions.setBlockState(context.chunk, (class_2338)pos, BlockStates.AIR, 2);
                        }
                    }
                }
            }
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            GrowthConfig[] growth = ((Data)this.data).growth;
            if (growth == null || growth.length == 0) {
                return;
            }
            int minX = Math.max(this.field_15315.method_35415(), chunkBox.method_35415());
            int minY = Math.max(this.field_15315.method_35416(), chunkBox.method_35416());
            int minZ = Math.max(this.field_15315.method_35417(), chunkBox.method_35417());
            int maxX = Math.min(this.field_15315.method_35418(), chunkBox.method_35418());
            int maxY = Math.min(this.field_15315.method_35419(), chunkBox.method_35419());
            int maxZ = Math.min(this.field_15315.method_35420(), chunkBox.method_35420());
            class_2338.class_2339 pos = new class_2338.class_2339();
            Permuter permuter = new Permuter(0L);
            long seed = world.method_8412() ^ 0x13AFC86BC0528060L;
            for (int y = minY; y <= maxY; ++y) {
                long seedY = Permuter.permute(seed, y);
                for (int z = minZ; z <= maxZ; ++z) {
                    long seedZ = Permuter.permute(seedY, z);
                    block2: for (int x = minX; x <= maxX; ++x) {
                        if (!world.method_22347((class_2338)pos.method_10103(x, y, z))) continue;
                        long seedX = Permuter.permute(seedZ, x);
                        permuter.setSeed(seedX);
                        class_2350 direction = Permuter.choose((RandomGenerator)permuter, Directions.ALL);
                        class_2248 against = world.method_8320((class_2338)pos.method_10098(direction)).method_26204();
                        for (GrowthConfig growthConfig : growth) {
                            if (!growthConfig.against.contains(against) || growthConfig.place.isEmpty()) continue;
                            class_2680 toPlace = growthConfig.place.randomObject(permuter).method_9564();
                            if (toPlace.method_28498((class_2769)class_2741.field_12525)) {
                                toPlace = (class_2680)toPlace.method_11657((class_2769)class_2741.field_12525, (Comparable)direction.method_10153());
                            }
                            world.method_8652((class_2338)pos.method_10103(x, y, z), toPlace, 18);
                            continue block2;
                        }
                    }
                }
            }
        }

        public void method_14922(int x, int y, int z) {
            super.method_14922(x, y, z);
            ((Data)this.data).x += (double)x;
            ((Data)this.data).y += (double)y;
            ((Data)this.data).z += (double)z;
            ((Data)this.data).offsetX += x;
            ((Data)this.data).offsetY += y;
            ((Data)this.data).offsetZ += z;
        }

        public static class Data {
            public static final AutoCoder<Data> CODER = BigGlobeAutoCodec.AUTO_CODEC.createCoder(Data.class);
            public double x;
            public double y;
            public double z;
            public @DefaultInt(value=0) int offsetX;
            public @DefaultInt(value=0) int offsetY;
            public @DefaultInt(value=0) int offsetZ;
            public @UseName(value="r") double radius;
            public Grid3D noise;
            public BlocksConfig[] blocks;
            public @UseName(value="gbt") GrowthConfig @VerifyNullable @SingletonArray [] growth;

            public Data(double x, double y, double z, int offsetX, int offsetY, int offsetZ, double radius, Grid3D noise, BlocksConfig[] blocks, GrowthConfig @VerifyNullable [] growth) {
                this.x = x;
                this.y = y;
                this.z = z;
                this.offsetX = offsetX;
                this.offsetY = offsetY;
                this.offsetZ = offsetZ;
                this.noise = noise;
                this.radius = radius;
                this.blocks = blocks;
                this.growth = growth;
            }
        }
    }

    public static class SpikePiece
    extends DataStructurePiece<Data>
    implements RawGenerationStructure.RawGenerationStructurePiece {
        public SpikePiece(class_3773 type, double x1, double y1, double z1, double r1, double x2, double y2, double z2, double r2, IRandomList<class_2680> states) {
            super(type, 0, new class_3341(BigGlobeMath.ceilI(Math.min(x1 - r1, x2 - r2)), BigGlobeMath.ceilI(Math.min(y1 - r1, y2 - r2)), BigGlobeMath.ceilI(Math.min(z1 - r1, z2 - r2)), BigGlobeMath.floorI(Math.max(x1 + r1, x2 + r2)), BigGlobeMath.floorI(Math.max(y1 + r1, y2 + r2)), BigGlobeMath.floorI(Math.max(z1 + r1, z2 + r2))), new Data(x1, y1, z1, r1, x2, y2, z2, r2, states));
        }

        public SpikePiece(class_3773 type, class_6625 context, class_2487 nbt) {
            super(type, context, nbt);
        }

        @Override
        public AutoCoder<Data> dataCoder() {
            return Data.CODER;
        }

        @Override
        public void generateRaw(RawGenerationStructure.RawGenerationStructurePiece.Context context) {
            Data data = (Data)this.data;
            class_1923 chunkPos = context.chunk.method_12004();
            int minX = chunkPos.method_8326();
            int minY = Math.max(this.field_15315.method_35416(), HeightLimitViewVersions.getMinY((class_5539)context.chunk));
            int minZ = chunkPos.method_8328();
            int maxX = chunkPos.method_8327();
            int maxY = Math.min(this.field_15315.method_35419(), HeightLimitViewVersions.getMaxY((class_5539)context.chunk) - 1);
            int maxZ = chunkPos.method_8329();
            Vector3d spikeOffset = new Vector3d(data.x2 - data.x1, data.y2 - data.y1, data.z2 - data.z1);
            Vector3d relativePos = new Vector3d();
            Vector3d nearest = new Vector3d();
            class_2338.class_2339 mutablePos = new class_2338.class_2339();
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    for (int y = minY; y <= maxY; ++y) {
                        relativePos.set((double)x - data.x1, (double)y - data.y1, (double)z - data.z1);
                        double dot = spikeOffset.dot((Vector3dc)relativePos);
                        double fraction = dot / spikeOffset.lengthSquared();
                        fraction = class_3532.method_15350((double)fraction, (double)0.0, (double)1.0);
                        nearest.set((Vector3dc)spikeOffset).mul(fraction);
                        double distanceSquared = relativePos.distanceSquared((Vector3dc)nearest);
                        double thresholdSquared = BigGlobeMath.squareD(Interpolator.mixLinear(data.r1, data.r2, fraction));
                        if (!(distanceSquared < thresholdSquared) || !context.chunk.method_8320((class_2338)mutablePos.method_10103(x, y, z)).method_26215()) continue;
                        ChunkVersions.setBlockState(context.chunk, (class_2338)mutablePos, data.states.getRandomElement(Permuter.permute(context.columnSeed ^ 0x84DA20CB58CD2DFBL, x, y, z)), 2);
                    }
                }
            }
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
        }

        public void method_14922(int x, int y, int z) {
            super.method_14922(x, y, z);
            ((Data)this.data).x1 += (double)x;
            ((Data)this.data).y1 += (double)y;
            ((Data)this.data).z1 += (double)z;
            ((Data)this.data).x2 += (double)x;
            ((Data)this.data).y2 += (double)y;
            ((Data)this.data).z2 += (double)z;
        }

        public static class Data {
            public static final AutoCoder<Data> CODER = BigGlobeAutoCodec.AUTO_CODEC.createCoder(Data.class);
            public double x1;
            public double y1;
            public double z1;
            public double r1;
            public double x2;
            public double y2;
            public double z2;
            public double r2;
            public IRandomList<@UseName(value="state") class_2680> states;

            public Data(double x1, double y1, double z1, double r1, double x2, double y2, double z2, double r2, IRandomList<@UseName(value="state") class_2680> states) {
                this.x1 = x1;
                this.y1 = y1;
                this.z1 = z1;
                this.r1 = r1;
                this.x2 = x2;
                this.y2 = y2;
                this.z2 = z2;
                this.r2 = r2;
                this.states = states;
            }
        }
    }
}

