/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.trees.branches;

import builderb0y.bigglobe.trees.TreeGenerator;
import builderb0y.bigglobe.trees.branches.BranchConfig;
import builderb0y.bigglobe.trees.branches.ScriptedBranchShape;
import builderb0y.bigglobe.trees.branches.ThickBranchConfig;

public class BranchesConfig {
    public final double startFracY;
    public final int branchCount;
    public final double startAngle;
    public final boolean thickBranches;
    public final ScriptedBranchShape.Holder lengthGetter;
    public final ScriptedBranchShape.Holder heightGetter;
    public BranchConfig currentBranch;

    public BranchesConfig(double startFracY, int branchCount, double startAngle, boolean thickBranches, ScriptedBranchShape.Holder lengthGetter, ScriptedBranchShape.Holder heightGetter) {
        this.startFracY = startFracY;
        this.branchCount = branchCount;
        this.startAngle = startAngle;
        this.thickBranches = thickBranches;
        this.lengthGetter = lengthGetter;
        this.heightGetter = heightGetter;
    }

    public static BranchesConfig create(double startFracY, int branchCount, double startAngle, double trunkStartRadius, ScriptedBranchShape.Holder lengthGetter, ScriptedBranchShape.Holder heightGetter) {
        return new BranchesConfig(startFracY, branchCount, startAngle, trunkStartRadius >= 2.598076211353316, lengthGetter, heightGetter);
    }

    public void updateBranch(TreeGenerator generator, int index) {
        double angle = this.startAngle;
        double angleIncrement = Math.PI;
        int bits = index;
        while (true) {
            if ((bits & 1) != 0) {
                angle += angleIncrement;
            }
            if ((bits >>>= 1) == 0) break;
            angleIncrement *= 0.5;
        }
        double length = this.lengthGetter.evaluate((double)index / (double)this.branchCount, generator.random) * (double)generator.trunk.height * (1.0 - this.startFracY);
        long seed = generator.random.nextLong();
        this.currentBranch = this.thickBranches ? new ThickBranchConfig(angle, length, seed) : new BranchConfig(angle, length, seed);
    }
}

