/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.trees.branches;

import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.math.Interpolator;
import builderb0y.bigglobe.trees.TreeGenerator;
import builderb0y.bigglobe.trees.branches.BranchConfig;

public class ThickBranchConfig
extends BranchConfig {
    public static final double MIN_RADIUS = 0.8660254037844386;
    public double currentRadius;

    public ThickBranchConfig(double angle, double length, long seed) {
        super(angle, length, seed);
    }

    @Override
    public void setBothLengths(TreeGenerator generator, double length, double fracLength) {
        super.setBothLengths(generator, length, fracLength);
        this.currentRadius = Interpolator.mixLinear(0.8660254037844386, generator.trunk.currentRadius, BigGlobeMath.squareD(1.0 - fracLength));
    }

    public void project(TreeGenerator generator, int x, int z) {
        this.setLength(generator, ((double)x - generator.trunk.currentX) * this.nx + ((double)z - generator.trunk.currentZ) * this.nz);
    }

    public boolean isInRadius(int x, int y, int z) {
        return BigGlobeMath.squareD((double)x - this.currentX, (double)y - this.currentY, (double)z - this.currentZ) < BigGlobeMath.squareD(this.currentRadius);
    }
}

