/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.conditions;

import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.conditions.ConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.ConstantConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.IntCompareConditionTree;

public class DoubleCompareConditionTree
extends IntCompareConditionTree {
    public final int toIntOpcode;

    public DoubleCompareConditionTree(InsnTree left, InsnTree right, int opcode, int toIntOpcode) {
        super(left, right, opcode);
        this.toIntOpcode = toIntOpcode;
    }

    public static ConditionTree createDouble(InsnTree left, InsnTree right, int opcode, int toIntOpcode, DoubleBiPredicate ifConstant) {
        ConstantValue leftConstant = left.getConstantValue();
        ConstantValue rightConstant = right.getConstantValue();
        if (leftConstant.isConstant() && rightConstant.isConstant()) {
            return ConstantConditionTree.of(ifConstant.test(leftConstant.asDouble(), rightConstant.asDouble()));
        }
        return new DoubleCompareConditionTree(left, right, opcode, toIntOpcode);
    }

    public static ConditionTree equal(InsnTree left, InsnTree right) {
        return DoubleCompareConditionTree.createDouble(left, right, 153, 151, (l, r) -> l == r);
    }

    public static ConditionTree notEqual(InsnTree left, InsnTree right) {
        return DoubleCompareConditionTree.createDouble(left, right, 154, 151, (l, r) -> l != r);
    }

    public static ConditionTree lessThan(InsnTree left, InsnTree right) {
        return DoubleCompareConditionTree.createDouble(left, right, 155, 152, (l, r) -> l < r);
    }

    public static ConditionTree greaterThan(InsnTree left, InsnTree right) {
        return DoubleCompareConditionTree.createDouble(left, right, 157, 151, (l, r) -> l > r);
    }

    public static ConditionTree lessThanOrEqual(InsnTree left, InsnTree right) {
        return DoubleCompareConditionTree.createDouble(left, right, 158, 152, (l, r) -> l <= r);
    }

    public static ConditionTree greaterThanOrEqual(InsnTree left, InsnTree right) {
        return DoubleCompareConditionTree.createDouble(left, right, 156, 151, (l, r) -> l >= r);
    }

    @Override
    public void toInt(MethodCompileContext method) {
        method.node.visitInsn(this.toIntOpcode);
    }

    @FunctionalInterface
    public static interface DoubleBiPredicate {
        public boolean test(double var1, double var3);
    }
}

