/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.conditions;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.tree.conditions.ConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.ConstantConditionTree;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Label;

public class OrConditionTree
implements ConditionTree {
    public final ConditionTree left;
    public final ConditionTree right;

    public OrConditionTree(ConditionTree left, ConditionTree right) {
        this.left = left;
        this.right = right;
    }

    public static ConditionTree create(ConditionTree left, ConditionTree right) {
        if (left instanceof ConstantConditionTree) {
            ConstantConditionTree leftConstant = (ConstantConditionTree)left;
            if (right instanceof ConstantConditionTree) {
                ConstantConditionTree rightConstant = (ConstantConditionTree)right;
                return ConstantConditionTree.of(leftConstant.value | rightConstant.value);
            }
            return leftConstant.value ? leftConstant : right;
        }
        if (right instanceof ConstantConditionTree) {
            ConstantConditionTree rightConstant = (ConstantConditionTree)right;
            if (!rightConstant.value) {
                return left;
            }
        }
        return new OrConditionTree(left, right);
    }

    @Override
    public void emitBytecode(MethodCompileContext method, @Nullable Label ifTrue, @Nullable Label ifFalse) {
        boolean madeTrue;
        ConditionTree.checkLabels(ifTrue, ifFalse);
        boolean bl = madeTrue = ifTrue == null;
        if (madeTrue) {
            ifTrue = InsnTrees.label();
        }
        this.left.emitBytecode(method, ifTrue, null);
        this.right.emitBytecode(method, ifTrue, null);
        if (ifFalse != null) {
            method.node.visitJumpInsn(167, ifFalse);
        }
        if (madeTrue) {
            method.node.visitLabel(ifTrue);
        }
    }
}

