/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.flow;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.parsing.ExpressionParser;
import java.util.Arrays;

public class SequenceInsnTree
implements InsnTree {
    public InsnTree[] statements;

    public SequenceInsnTree(InsnTree ... statements) {
        this(statements, false);
    }

    public SequenceInsnTree(InsnTree[] statements, boolean trusted) {
        InsnTree[] insnTreeArray = this.statements = trusted ? statements : SequenceInsnTree.flatten(statements);
        assert (SequenceInsnTree.isArrayValid(this.statements)) : "Invalid statement array after flattening.";
    }

    public static InsnTree[] flatten(InsnTree[] statements) {
        int flattenedLength = 0;
        int length = statements.length;
        for (int index = 0; index < length; ++index) {
            int n;
            InsnTree statement = statements[index];
            if (statement == null) {
                throw new NullPointerException("Null statement at index " + index);
            }
            if (statement instanceof SequenceInsnTree) {
                SequenceInsnTree sequence = (SequenceInsnTree)statement;
                n = sequence.statements.length;
            } else {
                n = 1;
            }
            flattenedLength += n;
        }
        InsnTree[] result = new InsnTree[flattenedLength];
        int writeIndex = 0;
        for (InsnTree statement : statements) {
            if (statement instanceof SequenceInsnTree) {
                SequenceInsnTree sequence = (SequenceInsnTree)statement;
                System.arraycopy(sequence.statements, 0, result, writeIndex, sequence.statements.length);
                writeIndex += sequence.statements.length;
            } else {
                result[writeIndex++] = statement;
            }
            if (writeIndex == flattenedLength) continue;
            result[writeIndex - 1] = result[writeIndex - 1].asStatement();
        }
        return result;
    }

    public static boolean isArrayValid(InsnTree[] array) {
        int limit = array.length - 1;
        if (limit <= 0) {
            return false;
        }
        for (int index = 0; index <= limit; ++index) {
            InsnTree tree = array[index];
            if (tree == null) {
                return false;
            }
            if (index >= limit || !tree.getTypeInfo().isValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void emitBytecode(MethodCompileContext method) {
        for (InsnTree statement : this.statements) {
            statement.emitBytecode(method);
            method.node.visitLabel(InsnTrees.label());
        }
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this.statements[this.statements.length - 1].getTypeInfo();
    }

    @Override
    public boolean jumpsUnconditionally() {
        return Arrays.stream(this.statements).anyMatch(InsnTree::jumpsUnconditionally);
    }

    @Override
    public InsnTree doCast(ExpressionParser parser, TypeInfo type, InsnTree.CastMode mode, boolean nullable) {
        InsnTree oldLast = this.statements[this.statements.length - 1];
        InsnTree newLast = oldLast.cast(parser, type, mode, nullable);
        if (newLast == null) {
            return null;
        }
        if (newLast == oldLast) {
            return this;
        }
        InsnTree[] newStatements = (InsnTree[])this.statements.clone();
        newStatements[newStatements.length - 1] = newLast;
        return new SequenceInsnTree(newStatements, true);
    }

    @Override
    public boolean canBeStatement() {
        return this.statements[this.statements.length - 1].canBeStatement();
    }

    @Override
    public InsnTree asStatement() {
        InsnTree oldLast = this.statements[this.statements.length - 1];
        InsnTree newLast = oldLast.asStatement();
        if (newLast == oldLast) {
            return this;
        }
        InsnTree[] newStatements = (InsnTree[])this.statements.clone();
        newStatements[newStatements.length - 1] = newLast;
        return new SequenceInsnTree(newStatements, true);
    }
}

