/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.flow.loop;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.ScopeContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.conditions.ConditionTree;
import builderb0y.scripting.util.TypeInfos;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;

public class ForInsnTree
implements InsnTree {
    public ScopeContext.LoopName loopName;
    public InsnTree initializer;
    public ConditionTree condition;
    public InsnTree step;
    public InsnTree body;

    public ForInsnTree(ScopeContext.LoopName loopName, InsnTree initializer, ConditionTree condition, InsnTree step, InsnTree body) {
        this.loopName = loopName;
        this.initializer = initializer.asStatement();
        this.condition = condition;
        this.step = step.asStatement();
        this.body = body.asStatement();
    }

    @Override
    public void emitBytecode(MethodCompileContext method) {
        LabelNode continuePoint = InsnTrees.labelNode();
        ScopeContext.Scope scope = method.scopes.pushLoop(this.loopName, continuePoint);
        this.initializer.emitBytecode(method);
        Label startingPoint = InsnTrees.label();
        method.node.visitLabel(startingPoint);
        this.condition.emitBytecode(method, null, scope.end.getLabel());
        this.body.emitBytecode(method);
        method.node.instructions.add((AbstractInsnNode)continuePoint);
        this.step.emitBytecode(method);
        method.node.visitJumpInsn(167, startingPoint);
        method.scopes.popScope();
    }

    @Override
    public TypeInfo getTypeInfo() {
        return TypeInfos.VOID;
    }

    @Override
    public boolean canBeStatement() {
        return true;
    }
}

