/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.instructions;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.parsing.ExpressionParser;

public class ConstantInsnTree
implements InsnTree {
    public ConstantValue value;

    public ConstantInsnTree(ConstantValue value) {
        if (!value.isConstantOrDynamic()) {
            throw new IllegalArgumentException("Non-constant constant value: " + String.valueOf(value));
        }
        this.value = value;
    }

    @Override
    public void emitBytecode(MethodCompileContext method) {
        this.value.emitBytecode(method);
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this.value.getTypeInfo();
    }

    @Override
    public ConstantValue getConstantValue() {
        return this.value;
    }

    @Override
    public InsnTree doCast(ExpressionParser parser, TypeInfo type, InsnTree.CastMode mode, boolean nullable) {
        if (this.value.isConstant() && this.value.asJavaObject() == null && type.isObject()) {
            return InsnTrees.ldc(null, type);
        }
        TypeInfo from = this.getTypeInfo();
        if (from.isPrimitiveValue() && type.isPrimitiveValue()) {
            if (mode.implicit && (type.getSort() == TypeInfo.Sort.BOOLEAN ? from.getSort() != TypeInfo.Sort.BOOLEAN : type.isNumber() && (!from.isNumber() || type.getSort().ordinal() < from.getSort().ordinal()))) {
                return (InsnTree)mode.handleFailure(from, type);
            }
            return switch (type.getSort()) {
                case TypeInfo.Sort.BYTE -> InsnTrees.ldc(this.value.asByte());
                case TypeInfo.Sort.SHORT -> InsnTrees.ldc(this.value.asShort());
                case TypeInfo.Sort.INT -> InsnTrees.ldc(this.value.asInt());
                case TypeInfo.Sort.LONG -> InsnTrees.ldc(this.value.asLong());
                case TypeInfo.Sort.FLOAT -> InsnTrees.ldc(this.value.asFloat());
                case TypeInfo.Sort.DOUBLE -> InsnTrees.ldc(this.value.asDouble());
                case TypeInfo.Sort.CHAR -> InsnTrees.ldc(this.value.asChar());
                case TypeInfo.Sort.BOOLEAN -> InsnTrees.ldc(this.value.asBoolean());
                default -> throw new AssertionError(type);
            };
        }
        return InsnTree.super.doCast(parser, type, mode, nullable);
    }
}

