/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.instructions;

import builderb0y.scripting.bytecode.LazyVarInfo;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.instructions.update.IncrementUpdateInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.update.VariableUpdaterInsnTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ScriptParsingException;

public class LoadInsnTree
implements InsnTree {
    public LazyVarInfo variable;

    public LoadInsnTree(LazyVarInfo variable) {
        this.variable = variable;
    }

    public LazyVarInfo variable() {
        return this.variable;
    }

    @Override
    public InsnTree update(ExpressionParser parser, InsnTree.UpdateOp op, InsnTree.UpdateOrder order, InsnTree rightValue) throws ScriptParsingException {
        int increment;
        ConstantValue constant;
        if (op == InsnTree.UpdateOp.ASSIGN) {
            InsnTree cast = rightValue.cast(parser, this.variable.type, InsnTree.CastMode.IMPLICIT_THROW, false);
            return new VariableUpdaterInsnTree(order, true, VariableUpdaterInsnTree.VariableUpdaterEmitters.forLazyVariable(this.variable, cast));
        }
        if ((op == InsnTree.UpdateOp.ADD || op == InsnTree.UpdateOp.SUBTRACT) && this.getTypeInfo().getSort() == TypeInfo.Sort.INT && (constant = rightValue.getConstantValue()).isConstant() && constant.getTypeInfo().isSingleWidthInt() && (increment = op == InsnTree.UpdateOp.ADD ? constant.asInt() : -constant.asInt()) == (short)increment) {
            return new IncrementUpdateInsnTree(order, this.variable, increment);
        }
        InsnTree updater = op.createUpdater(parser, this.getTypeInfo(), rightValue);
        return new VariableUpdaterInsnTree(order, false, VariableUpdaterInsnTree.VariableUpdaterEmitters.forLazyVariable(this.variable, updater));
    }

    @Override
    public void emitBytecode(MethodCompileContext method) {
        this.variable.emitLoad(method);
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this.variable.type;
    }
}

