/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.instructions.binary;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.InvalidOperandException;
import builderb0y.scripting.bytecode.tree.instructions.binary.BinaryInsnTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.util.TypeInfos;

public class MultiplyInsnTree
extends BinaryInsnTree {
    public MultiplyInsnTree(InsnTree left, InsnTree right, int opcode) {
        super(left, right, opcode);
    }

    public static TypeInfo validate(TypeInfo left, TypeInfo right) {
        if (left.isNumber() && right.isNumber()) {
            return TypeInfos.widenUntilSameInt(left, right);
        }
        throw new InvalidOperandException("Can't multiply " + String.valueOf(left) + " and " + String.valueOf(right));
    }

    public static InsnTree create(ExpressionParser parser, InsnTree left, InsnTree right) {
        TypeInfo type = MultiplyInsnTree.validate(left.getTypeInfo(), right.getTypeInfo());
        ConstantValue leftConstant = left.getConstantValue();
        ConstantValue rightConstant = right.getConstantValue();
        if (leftConstant.isConstant() && rightConstant.isConstant()) {
            return switch (type.getSort()) {
                case TypeInfo.Sort.INT -> InsnTrees.ldc(Math.multiplyExact(leftConstant.asInt(), rightConstant.asInt()));
                case TypeInfo.Sort.LONG -> InsnTrees.ldc(Math.multiplyExact(leftConstant.asLong(), rightConstant.asLong()));
                case TypeInfo.Sort.FLOAT -> InsnTrees.ldc(leftConstant.asFloat() * rightConstant.asFloat());
                case TypeInfo.Sort.DOUBLE -> InsnTrees.ldc(leftConstant.asDouble() * rightConstant.asDouble());
                default -> throw new AssertionError(type);
            };
        }
        left = left.cast(parser, type, InsnTree.CastMode.EXPLICIT_THROW, false);
        right = right.cast(parser, type, InsnTree.CastMode.EXPLICIT_THROW, false);
        return new MultiplyInsnTree(left, right, type.getOpcode(104));
    }
}

