/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.instructions.binary;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.InvalidOperandException;
import builderb0y.scripting.bytecode.tree.instructions.binary.BinaryInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.binary.MultiplyInsnTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.util.TypeInfos;

public class SignedLeftShiftInsnTree
extends BinaryInsnTree {
    public static final MethodInfo INT_SHIFT = MethodInfo.findMethod(SignedLeftShiftInsnTree.class, "shift", Integer.TYPE, Integer.TYPE, Integer.TYPE).pure();
    public static final MethodInfo LONG_SHIFT = MethodInfo.findMethod(SignedLeftShiftInsnTree.class, "shift", Long.TYPE, Long.TYPE, Integer.TYPE).pure();
    public static final MethodInfo FLOAT_SHIFT = MethodInfo.findMethod(Math.class, "scalb", Float.TYPE, Float.TYPE, Integer.TYPE).pure();
    public static final MethodInfo DOUBLE_SHIFT = MethodInfo.findMethod(Math.class, "scalb", Double.TYPE, Double.TYPE, Integer.TYPE).pure();

    public SignedLeftShiftInsnTree(InsnTree left, InsnTree right, int opcode) {
        super(left, right, opcode);
    }

    public static TypeInfo validate(TypeInfo left, TypeInfo right) {
        if (left.isNumber() && right.isSingleWidthInt()) {
            return TypeInfos.widenToInt(left);
        }
        throw new InvalidOperandException("Can't signed left shift " + String.valueOf(left) + " and " + String.valueOf(right));
    }

    public static InsnTree create(ExpressionParser parser, InsnTree left, InsnTree right) {
        TypeInfo type = SignedLeftShiftInsnTree.validate(left.getTypeInfo(), right.getTypeInfo());
        ConstantValue leftConstant = left.getConstantValue();
        ConstantValue rightConstant = right.getConstantValue();
        if (leftConstant.isConstant() && rightConstant.isConstant()) {
            return switch (type.getSort()) {
                case TypeInfo.Sort.INT -> InsnTrees.ldc(SignedLeftShiftInsnTree.shift(leftConstant.asInt(), rightConstant.asInt()));
                case TypeInfo.Sort.LONG -> InsnTrees.ldc(SignedLeftShiftInsnTree.shift(leftConstant.asLong(), rightConstant.asInt()));
                case TypeInfo.Sort.FLOAT -> InsnTrees.ldc(Math.scalb(leftConstant.asFloat(), rightConstant.asInt()));
                case TypeInfo.Sort.DOUBLE -> InsnTrees.ldc(Math.scalb(leftConstant.asDouble(), rightConstant.asInt()));
                default -> throw new AssertionError(type);
            };
        }
        left = left.cast(parser, type, InsnTree.CastMode.IMPLICIT_THROW, false);
        right = right.cast(parser, TypeInfos.INT, InsnTree.CastMode.IMPLICIT_THROW, false);
        return new SignedLeftShiftInsnTree(left, right, switch (type.getSort()) {
            case TypeInfo.Sort.INT -> 120;
            case TypeInfo.Sort.LONG -> 121;
            case TypeInfo.Sort.FLOAT -> 264;
            case TypeInfo.Sort.DOUBLE -> 265;
            default -> throw new AssertionError(type);
        });
    }

    @Override
    public void emitBytecode(MethodCompileContext method) {
        TypeInfo leftType = this.left.getTypeInfo();
        ConstantValue rightConstant = this.right.getConstantValue();
        if (leftType.isInteger()) {
            if (rightConstant.isConstant()) {
                int maxShift = leftType.isDoubleWidth() ? 64 : 32;
                long shift = rightConstant.asLong();
                if (shift > 0L) {
                    if (shift >= (long)maxShift) {
                        this.left.emitBytecode(method);
                        method.node.visitInsn(leftType.isDoubleWidth() ? 88 : 87);
                        InsnTrees.constant(0, leftType).emitBytecode(method);
                    } else {
                        this.left.emitBytecode(method);
                        this.right.emitBytecode(method);
                        method.node.visitInsn(leftType.getOpcode(120));
                    }
                } else if (shift < 0L) {
                    if (shift <= (long)(-maxShift)) {
                        shift = 1 - maxShift;
                    }
                    this.left.emitBytecode(method);
                    InsnTrees.ldc(-shift, TypeInfos.INT).emitBytecode(method);
                    method.node.visitInsn(leftType.getOpcode(122));
                } else {
                    this.left.emitBytecode(method);
                }
            } else {
                InsnTrees.invokeStatic(leftType.getSort() == TypeInfo.Sort.LONG ? LONG_SHIFT : INT_SHIFT, this.left, this.right).emitBytecode(method);
            }
        } else {
            if (rightConstant.isConstant()) {
                if (rightConstant.asInt() == 0) {
                    this.left.emitBytecode(method);
                    return;
                }
                if (leftType.isSingleWidth()) {
                    float multiplier = Math.scalb(1.0f, rightConstant.asInt());
                    if (multiplier != 0.0f && Float.isFinite(multiplier)) {
                        new MultiplyInsnTree(this.left, InsnTrees.ldc(multiplier), 106).emitBytecode(method);
                        return;
                    }
                } else {
                    double multiplier = Math.scalb(1.0, rightConstant.asInt());
                    if (multiplier != 0.0 && Double.isFinite(multiplier)) {
                        new MultiplyInsnTree(this.left, InsnTrees.ldc(multiplier), 107).emitBytecode(method);
                        return;
                    }
                }
            }
            InsnTrees.invokeStatic(leftType.isDoubleWidth() ? DOUBLE_SHIFT : FLOAT_SHIFT, this.left, this.right).emitBytecode(method);
        }
    }

    public static int shift(int a, int b) {
        if (b >= 0) {
            return b >= 32 ? 0 : a << b;
        }
        return b <= -31 ? a >> 31 : a >> -b;
    }

    public static long shift(long a, int b) {
        if (b >= 0) {
            return b >= 64 ? 0L : a << b;
        }
        return b <= -63 ? a >> 63 : a >> -b;
    }

    public static float shift(float a, int b) {
        if (a == 0.0f || !Float.isFinite(a) || b == 0) {
            return a;
        }
        int bits = Float.floatToRawIntBits(a);
        int exponent = bits << 1 >>> 24;
        int mantissa = bits & 0x7FFFFF;
        if (exponent == 0) {
            exponent = 8 - Integer.numberOfLeadingZeros(mantissa);
            mantissa = mantissa << -exponent & 0x7FFFFF;
            ++exponent;
        }
        if ((exponent += Math.min(Math.max(b, -22 - exponent), 255 - exponent)) <= 0) {
            mantissa = (mantissa | 0x800000) >>> -(--exponent);
            exponent = 0;
        } else if (exponent >= 255) {
            return Float.intBitsToFloat(bits & Integer.MIN_VALUE | 0x7F800000);
        }
        return Float.intBitsToFloat(bits & Integer.MIN_VALUE | exponent << 23 | mantissa);
    }

    public static double shift(double a, int b) {
        if (a == 0.0 || !Double.isFinite(a) || b == 0) {
            return a;
        }
        long bits = Double.doubleToRawLongBits(a);
        int exponent = (int)(bits << 1 >>> 53);
        long mantissa = bits & 0xFFFFFFFFFFFFFL;
        if (exponent == 0) {
            exponent = 11 - Long.numberOfLeadingZeros(mantissa);
            mantissa = mantissa << -exponent & 0xFFFFFFFFFFFFFL;
            ++exponent;
        }
        if ((exponent += Math.min(Math.max(b, -51 - exponent), 2047 - exponent)) <= 0) {
            mantissa = (mantissa | 0x10000000000000L) >>> -(--exponent);
            exponent = 0;
        } else if (exponent >= 2047) {
            return Double.longBitsToDouble(bits & Long.MIN_VALUE | 0x7FF0000000000000L);
        }
        return Double.longBitsToDouble(bits & Long.MIN_VALUE | (long)exponent << 52 | mantissa);
    }
}

