/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.optimization;

import builderb0y.scripting.optimization.ClassOptimizer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class PopOptimizer
implements ClassOptimizer.MethodOptimizer {
    public static final PopOptimizer INSTANCE = new PopOptimizer();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean optimize(MethodNode method) {
        boolean changed = false;
        AbstractInsnNode node = method.instructions.getFirst();
        while (node != null) {
            AbstractInsnNode previous;
            AbstractInsnNode next = node.getNext();
            if (node.getOpcode() == 87) {
                previous = node.getPrevious();
                if (previous != null) {
                    switch (previous.getOpcode()) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 16: 
                        case 17: 
                        case 21: 
                        case 23: 
                        case 89: {
                            method.instructions.remove(previous);
                            method.instructions.remove(node);
                            changed = true;
                            break;
                        }
                        case 18: {
                            constant = ((LdcInsnNode)previous).cst;
                            if (!(constant instanceof Integer) && !(constant instanceof Float) && !(constant instanceof String)) break;
                            method.instructions.remove(previous);
                            method.instructions.remove(node);
                            changed = true;
                            break;
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else if (node.getOpcode() == 88 && (previous = node.getPrevious()) != null) {
                switch (previous.getOpcode()) {
                    case 9: 
                    case 10: 
                    case 14: 
                    case 15: 
                    case 22: 
                    case 24: 
                    case 92: {
                        method.instructions.remove(previous);
                        method.instructions.remove(node);
                        changed = true;
                        break;
                    }
                    case 18: {
                        constant = ((LdcInsnNode)previous).cst;
                        if (!(constant instanceof Long) && !(constant instanceof Double)) break;
                        method.instructions.remove(previous);
                        method.instructions.remove(node);
                        changed = true;
                        break;
                    }
                }
            }
            node = next;
        }
        return changed;
    }
}

