/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.parsing;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.LazyVarInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.instructions.LoadInsnTree;
import builderb0y.scripting.environments.UserScriptEnvironment;
import builderb0y.scripting.parsing.ExpressionParser;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.objectweb.asm.tree.ParameterNode;

public class VariableCapturer {
    public final ExpressionParser parser;
    public List<LoadInsnTree> builtinParameters;
    public List<LoadInsnTree> capturedVariables;

    public VariableCapturer(ExpressionParser parser) {
        this.parser = parser;
        this.builtinParameters = new ArrayList<LoadInsnTree>(8);
        this.capturedVariables = new ArrayList<LoadInsnTree>(8);
    }

    public void addBuiltinParameters() {
        TypeInfo[] types = this.parser.method.info.paramTypes;
        List parameters = this.parser.method.node.parameters;
        int size = parameters.size();
        for (int index = 0; index < size; ++index) {
            this.builtinParameters.add(InsnTrees.load(((ParameterNode)parameters.get((int)index)).name, types[index]));
        }
    }

    public void addCapturedParameters() {
        for (UserScriptEnvironment.PendingLocal value : this.parser.environment.user().variables.values()) {
            if (!value.assigned) continue;
            this.capturedVariables.add(value.loader());
        }
    }

    public Stream<TypeInfo> streamImplicitParameterTypes() {
        return this.streamImplicitParameters().map(LazyVarInfo::type);
    }

    public Stream<LazyVarInfo> streamImplicitParameters() {
        return Stream.concat(this.builtinParameters.stream(), this.capturedVariables.stream()).map(LoadInsnTree::variable);
    }
}

