/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.parsing.input;

import builderb0y.autocodec.annotations.MemberUsage;
import builderb0y.autocodec.annotations.MultiLine;
import builderb0y.autocodec.annotations.UseVerifier;
import builderb0y.autocodec.annotations.VerifyNullable;
import builderb0y.autocodec.verifiers.VerifyContext;
import builderb0y.autocodec.verifiers.VerifyException;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.input.ScriptTemplate;
import builderb0y.scripting.parsing.input.ScriptUsage;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

@UseVerifier(name="verify", in=TemplateScriptUsage.class, usage=MemberUsage.METHOD_IS_HANDLER)
public class TemplateScriptUsage
extends ScriptUsage {
    public final class_6880<ScriptTemplate> template;
    public final @VerifyNullable Map<@ExpressionParser.IdentifierName String, @MultiLine String> inputs;

    public TemplateScriptUsage(@VerifyNullable String debug_name, class_6880<ScriptTemplate> template, @VerifyNullable Map<@ExpressionParser.IdentifierName String, @MultiLine String> inputs) {
        super(debug_name, null);
        this.template = template;
        this.inputs = inputs;
    }

    public static <T_Encoded> void verify(VerifyContext<T_Encoded, TemplateScriptUsage> context) throws VerifyException {
        TemplateScriptUsage usage = (TemplateScriptUsage)context.object;
        if (usage == null) {
            return;
        }
        List<ScriptTemplate.RequiredInput> requiredInputs = ((ScriptTemplate)usage.template.comp_349()).inputs;
        Map<String, String> providedInputs = usage.inputs;
        if (requiredInputs != null && !requiredInputs.isEmpty() || providedInputs != null && !providedInputs.isEmpty()) {
            if (requiredInputs == null) {
                requiredInputs = Collections.emptyList();
            }
            if (providedInputs == null) {
                providedInputs = Collections.emptyMap();
            }
            providedInputs = new HashMap<String, String>(providedInputs);
            HashSet<String> missingInputs = null;
            for (ScriptTemplate.RequiredInput requiredInput : requiredInputs) {
                if (providedInputs.remove(requiredInput.name()) != null || requiredInput.fallback() != null) continue;
                if (missingInputs == null) {
                    missingInputs = new HashSet<String>(4);
                }
                missingInputs.add(requiredInput.name());
            }
            if (missingInputs != null || !providedInputs.isEmpty()) {
                HashSet<String> missingInputs_ = missingInputs;
                Set<String> unknownInputs = providedInputs.keySet();
                throw new VerifyException(() -> {
                    StringBuilder message = new StringBuilder(64);
                    if (missingInputs_ != null) {
                        if (missingInputs_.size() == 1) {
                            message.append("Missing input: ").append((String)missingInputs_.iterator().next());
                        } else {
                            message.append("Missing inputs: ").append(missingInputs_);
                        }
                    }
                    if (!unknownInputs.isEmpty()) {
                        if (!message.isEmpty()) {
                            message.append("; ");
                        }
                        if (unknownInputs.size() == 1) {
                            message.append("Unknown input: ").append((String)unknownInputs.iterator().next());
                        } else {
                            message.append("Unknown inputs: ").append(unknownInputs);
                        }
                    }
                    return message.toString();
                });
            }
        }
    }

    @Override
    public String getRawSource() {
        return ((ScriptTemplate)this.template.comp_349()).getSource();
    }

    @Override
    @Nullable
    public class_6880<ScriptTemplate> getTemplate() {
        return this.template;
    }

    @Override
    public @Nullable Map<@ExpressionParser.IdentifierName String, @MultiLine String> getInputs() {
        return this.inputs;
    }
}

