/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.codecs;

import builderb0y.autocodec.AutoCodec;
import builderb0y.autocodec.coders.AutoCoder;
import builderb0y.autocodec.data.Data;
import builderb0y.autocodec.data.EmptyData;
import builderb0y.autocodec.decoders.DecodeContext;
import builderb0y.autocodec.decoders.DecodeException;
import builderb0y.autocodec.encoders.EncodeContext;
import builderb0y.autocodec.encoders.EncodeException;
import builderb0y.autocodec.reflection.memberViews.FieldLikeMemberView;
import builderb0y.autocodec.reflection.reification.ReifiedType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypelessCoderRegistry<E>
extends AutoCoder.NamedCoder<E> {
    public final AutoCodec autoCodec;
    public final Set<String> commonFields;
    public final Map<String, AutoCoder<? extends E>> decodeLookup;
    public final Map<Class<? extends E>, AutoCoder<? extends E>> encodeLookup;

    public TypelessCoderRegistry(ReifiedType<E> type, AutoCodec autoCodec) {
        super(type);
        this.autoCodec = autoCodec;
        this.commonFields = Arrays.stream(autoCodec.reflect(type).getFields(true)).map(FieldLikeMemberView::getAliases).flatMap(Arrays::stream).collect(Collectors.toSet());
        this.decodeLookup = new HashMap<String, AutoCoder<? extends E>>();
        this.encodeLookup = new HashMap<Class<? extends E>, AutoCoder<? extends E>>();
    }

    public <E2 extends E> void register(Class<E2> clazz) {
        AutoCoder coder = this.autoCodec.createCoder(clazz);
        if (this.encodeLookup.putIfAbsent(clazz, coder) != null) {
            throw new IllegalArgumentException("Duplicate class: " + String.valueOf(clazz));
        }
        Stream keys = coder.getKeys();
        if (keys == null) {
            throw new IllegalArgumentException("Could not get keys from " + String.valueOf(clazz));
        }
        keys.filter(key -> !this.commonFields.contains(key)).forEach(key -> {
            if (this.decodeLookup.putIfAbsent((String)key, (AutoCoder<E>)coder) != null) {
                throw new IllegalArgumentException("Duplicate key: " + key);
            }
        });
    }

    @ApiStatus.OverrideOnly
    @Nullable
    public <T_Encoded> E decode(@NotNull DecodeContext<T_Encoded> context) throws DecodeException {
        if (context.isEmpty()) {
            return null;
        }
        String prevKey = null;
        AutoCoder<? extends E> coder = null;
        for (Data keyData : context.forceAsMap().value.keySet()) {
            String key = ((DecodeContext)context.fork((String)"<key>", (Data)keyData)).forceAsString().value;
            AutoCoder<? extends E> next = this.decodeLookup.get(key);
            if (next == null) {
                if (this.commonFields.contains(key)) continue;
                throw new DecodeException(() -> "Unknown key: " + key);
            }
            if (coder == null) {
                coder = next;
                prevKey = key;
                continue;
            }
            if (coder == next) continue;
            String prevKey_ = prevKey;
            throw new DecodeException(() -> "Cannot specify both " + prevKey_ + " and " + key + " at the same time");
        }
        if (coder == null) {
            throw new DecodeException(() -> "Not enough information to determine type");
        }
        return (E)context.decodeWith(coder);
    }

    @ApiStatus.OverrideOnly
    @NotNull
    public <T_Encoded> Data encode(@NotNull EncodeContext<T_Encoded, E> context) throws EncodeException {
        if (context.object == null) {
            return EmptyData.INSTANCE;
        }
        AutoCoder<? extends E> coder = this.encodeLookup.get(context.object.getClass());
        if (coder == null) {
            throw new EncodeException(() -> "Unhandled type: " + String.valueOf(context.object.getClass()));
        }
        return context.encodeWith(coder);
    }
}

