/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.columns.scripted.entries;

import builderb0y.autocodec.annotations.VerifyNullable;
import builderb0y.autocodec.decoders.DecodeContext;
import builderb0y.autocodec.util.AutoCodecUtil;
import builderb0y.autocodec.verifiers.VerifyContext;
import builderb0y.autocodec.verifiers.VerifyException;
import builderb0y.bigglobe.columns.scripted.AccessSchema;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.columns.scripted.Valid;
import builderb0y.bigglobe.columns.scripted.VoronoiDataBase;
import builderb0y.bigglobe.columns.scripted.VoronoiManager;
import builderb0y.bigglobe.columns.scripted.VoronoiSettings;
import builderb0y.bigglobe.columns.scripted.compile.DataCompileContext;
import builderb0y.bigglobe.columns.scripted.compile.VoronoiBaseCompileContext;
import builderb0y.bigglobe.columns.scripted.compile.VoronoiImplCompileContext;
import builderb0y.bigglobe.columns.scripted.entries.AbstractColumnEntry;
import builderb0y.bigglobe.columns.scripted.entries.ColumnEntry;
import builderb0y.bigglobe.columns.scripted.types.VoronoiColumnValueType;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.randomLists.IRandomList;
import builderb0y.bigglobe.randomLists.RandomList;
import builderb0y.bigglobe.settings.VoronoiDiagram2D;
import builderb0y.scripting.bytecode.FieldCompileContext;
import builderb0y.scripting.bytecode.FieldInfo;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.LazyVarInfo;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.ConstantValue;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.instructions.LoadInsnTree;
import builderb0y.scripting.bytecode.tree.instructions.fields.NullableInstanceGetFieldInsnTree;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.util.TypeInfos;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Modifier;
import java.util.Map;
import net.minecraft.class_6880;

public class VoronoiColumnEntry
extends AbstractColumnEntry {
    public static final MethodHandle RANDOMIZE;
    public final VoronoiDiagram2D diagram;

    public VoronoiColumnEntry(VoronoiDiagram2D diagram, AccessSchema params, @VerifyNullable Valid valid, DecodeContext<?> decodeContext) {
        super(params, valid, true, decodeContext);
        this.diagram = diagram;
        if (!(params.type() instanceof VoronoiColumnValueType)) {
            throw new IllegalArgumentException("params.type must be 'bigglobe:voronoi' when column value type is 'bigglobe:voronoi'");
        }
        if (params.is_3d()) {
            throw new IllegalArgumentException("params.is_3d must be false when column value is 'bigglobe:voronoi'");
        }
    }

    public static CallSite createRandomizer(MethodHandles.Lookup lookup, String name, MethodType methodType, Class<?> ... options) throws Throwable {
        if (((Class)methodType.returnType()).getSuperclass() != VoronoiDataBase.class) {
            throw new IllegalArgumentException("Invalid super class: " + String.valueOf(((Class)methodType.returnType()).getSuperclass()));
        }
        if (options.length == 0) {
            if (Modifier.isAbstract(((Class)methodType.returnType()).getModifiers())) {
                throw new IllegalArgumentException("No options");
            }
            return new ConstantCallSite(lookup.findConstructor((Class<?>)methodType.returnType(), methodType.changeReturnType(Void.TYPE)));
        }
        long seed = ((Class)methodType.returnType()).getDeclaredField("SEED").getLong(null);
        MethodType constructorType = methodType.changeReturnType(Void.TYPE);
        MethodType factoryType = methodType.changeReturnType(VoronoiDataBase.class);
        RandomList<VoronoiDataBase.Factory> list = new RandomList<VoronoiDataBase.Factory>(options.length);
        for (Class<?> option : options) {
            option.asSubclass(VoronoiDataBase.class);
            VoronoiDataBase.Factory factory = LambdaMetafactory.altMetafactory(lookup, "create", MethodType.methodType(VoronoiDataBase.Factory.class), factoryType, lookup.findConstructor(option, constructorType), MethodType.methodType(option, methodType.parameterType(0), new Class[]{VoronoiDiagram2D.Cell.class}), 4, 1, MethodType.methodType(VoronoiDataBase.class, ScriptedColumn.class, VoronoiDiagram2D.Cell.class)).getTarget().invokeExact();
            double weight = option.getDeclaredField("WEIGHT").getDouble(null);
            list.add(factory, weight);
        }
        return new ConstantCallSite(MethodHandles.insertArguments(RANDOMIZE, 0, list.optimize(), seed).asType(methodType));
    }

    public static VoronoiDataBase randomize(IRandomList<VoronoiDataBase.Factory> factories, long baseSeed, ScriptedColumn column, VoronoiDiagram2D.Cell cell) {
        return factories.getRandomElement(cell.center.getSeed(baseSeed)).create(column, cell);
    }

    @Override
    public boolean hasField() {
        return true;
    }

    @Override
    public boolean isSettable() {
        return false;
    }

    public VoronoiColumnValueType voronoiType() {
        return (VoronoiColumnValueType)this.params.type();
    }

    public Map<String, AccessSchema> exports() {
        return this.voronoiType().exports;
    }

    @Override
    public void populateSetter(ColumnEntry.ColumnEntryMemory memory, DataCompileContext context, MethodCompileContext setterMethod) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void emitFieldGetterAndSetter(ColumnEntry.ColumnEntryMemory memory, DataCompileContext context) {
        super.emitFieldGetterAndSetter(memory, context);
        VoronoiManager voronoiManager = context.root().registry.voronoiManager;
        VoronoiBaseCompileContext voronoiBaseContext = voronoiManager.getBaseContextFor(this);
        voronoiBaseContext.mainClass.newField((int)25, (String)"SEED", (TypeInfo)TypeInfos.LONG).node.value = Permuter.permute(0L, memory.getTyped(ColumnEntry.ColumnEntryMemory.ACCESSOR_ID));
        for (Map.Entry<String, AccessSchema> entry : this.exports().entrySet()) {
            voronoiBaseContext.mainClass.newMethod(1025, "get_" + entry.getKey(), context.root().getTypeContext(entry.getValue().type()).type(), entry.getValue().getterParameters());
            voronoiBaseContext.mainClass.newMethod(1025, "set_" + entry.getKey(), TypeInfos.VOID, entry.getValue().setterParameters(context));
        }
        for (class_6880 class_68802 : voronoiManager.getOptionsFor(this)) {
            VoronoiImplCompileContext implContext = voronoiManager.getImplContextFor((VoronoiSettings)class_68802.comp_349());
            implContext.mainClass.newField((int)25, (String)"WEIGHT", (TypeInfo)TypeInfos.DOUBLE).node.value = ((VoronoiSettings)class_68802.comp_349()).weight();
            for (Map.Entry<String, class_6880<ColumnEntry>> export : ((VoronoiSettings)class_68802.comp_349()).exports().entrySet()) {
                InsnTree[] insnTreeArray;
                AccessSchema schema = ((ColumnEntry)export.getValue().comp_349()).getAccessSchema();
                MethodCompileContext getterDelegator = implContext.mainClass.newMethod(1, "get_" + export.getKey(), implContext.root().getTypeContext(schema.type()).type(), schema.getterParameters());
                LazyVarInfo self = new LazyVarInfo("this", getterDelegator.clazz.info);
                LazyVarInfo loadY = schema.is_3d() ? new LazyVarInfo("y", TypeInfos.INT) : null;
                ColumnEntry.ColumnEntryMemory exportMemory = implContext.getMemories().get(export.getValue().comp_349());
                LoadInsnTree loadInsnTree = InsnTrees.load(self);
                MethodInfo methodInfo = exportMemory.getTyped(ColumnEntry.ColumnEntryMemory.GETTER).info;
                if (loadY != null) {
                    InsnTree[] insnTreeArray2 = new InsnTree[1];
                    insnTreeArray = insnTreeArray2;
                    insnTreeArray2[0] = InsnTrees.load(loadY);
                } else {
                    insnTreeArray = (InsnTree[])InsnTree.ARRAY_FACTORY.empty();
                }
                InsnTrees.return_(InsnTrees.invokeInstance(loadInsnTree, methodInfo, insnTreeArray)).emitBytecode(getterDelegator);
                getterDelegator.endCode();
                LazyVarInfo value = new LazyVarInfo("value", implContext.root().getAccessContext(schema).exposedType());
                MethodCompileContext setterDelegator = implContext.mainClass.newMethod(1, "set_" + export.getKey(), TypeInfos.VOID, schema.setterParameters(implContext));
                if (exportMemory.containsKey(ColumnEntry.ColumnEntryMemory.SETTER)) {
                    InsnTree[] insnTreeArray3;
                    LoadInsnTree loadInsnTree2 = InsnTrees.load(self);
                    MethodInfo methodInfo2 = exportMemory.getTyped(ColumnEntry.ColumnEntryMemory.SETTER).info;
                    if (loadY != null) {
                        InsnTree[] insnTreeArray4 = new InsnTree[2];
                        insnTreeArray4[0] = InsnTrees.load(loadY);
                        insnTreeArray3 = insnTreeArray4;
                        insnTreeArray4[1] = InsnTrees.load(value);
                    } else {
                        InsnTree[] insnTreeArray5 = new InsnTree[1];
                        insnTreeArray3 = insnTreeArray5;
                        insnTreeArray5[0] = InsnTrees.load(value);
                    }
                    InsnTrees.return_(InsnTrees.invokeInstance(loadInsnTree2, methodInfo2, insnTreeArray3)).emitBytecode(setterDelegator);
                } else {
                    InsnTrees.return_(InsnTrees.noop).emitBytecode(setterDelegator);
                }
                setterDelegator.endCode();
            }
        }
    }

    @Override
    public void populateCompute2D(ColumnEntry.ColumnEntryMemory memory, DataCompileContext context, MethodCompileContext computeMethod) throws ScriptParsingException {
        ConstantValue diagram = ConstantValue.ofManual(this.diagram, InsnTrees.type(VoronoiDiagram2D.class));
        FieldCompileContext valueField = memory.getTyped(ColumnEntry.ColumnEntryMemory.FIELD);
        FieldInfo cellField = FieldInfo.getField(VoronoiDataBase.class, "cell");
        InsnTrees.return_(InsnTrees.invokeDynamic(MethodInfo.getMethod(VoronoiColumnEntry.class, "createRandomizer"), new MethodInfo(9, TypeInfos.OBJECT, "randomize", memory.getTyped(ColumnEntry.ColumnEntryMemory.ACCESS_CONTEXT).exposedType(), context.root().columnType(), InsnTrees.type(VoronoiDiagram2D.Cell.class)), (ConstantValue[])context.root().registry.voronoiManager.getImplContextsFor(this).stream().map(impl -> InsnTrees.constant(impl.mainClass.info)).toArray(ConstantValue[]::new), new InsnTree[]{context.loadColumn(), InsnTrees.invokeInstance(InsnTrees.ldc(diagram), MethodInfo.findMethod(VoronoiDiagram2D.class, "getNearestCell", VoronoiDiagram2D.Cell.class, Integer.TYPE, Integer.TYPE, VoronoiDiagram2D.Cell.class), ScriptedColumn.INFO.x(context.loadColumn()), ScriptedColumn.INFO.z(context.loadColumn()), new NullableInstanceGetFieldInsnTree(InsnTrees.getField(context.loadSelf(), valueField.info), cellField))})).emitBytecode(computeMethod);
        computeMethod.endCode();
    }

    @Override
    public void populateCompute3D(ColumnEntry.ColumnEntryMemory memory, DataCompileContext context, MethodCompileContext computeMethod) throws ScriptParsingException {
        throw new UnsupportedOperationException();
    }

    public static <T> void checkNotReserved(VerifyContext<T, String> context) throws VerifyException {
        String name = (String)context.object;
        if (name != null) {
            switch (name) {
                case "cell_x": 
                case "cell_z": 
                case "center_x": 
                case "center_z": 
                case "soft_distance_squared": 
                case "soft_distance": 
                case "hard_distance": 
                case "hard_distance_squared": 
                case "euclidean_distance_squared": 
                case "euclidean_distance": {
                    throw new VerifyException(() -> "Export name " + name + " is built-in, and cannot be overridden.");
                }
            }
        }
    }

    static {
        try {
            RANDOMIZE = MethodHandles.lookup().findStatic(VoronoiColumnEntry.class, "randomize", MethodType.methodType(VoronoiDataBase.class, IRandomList.class, Long.TYPE, ScriptedColumn.class, VoronoiDiagram2D.Cell.class));
        }
        catch (Exception exception) {
            throw AutoCodecUtil.rethrow((Throwable)exception);
        }
    }
}

