/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.commands;

import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.commands.DevDebugCommand;
import builderb0y.bigglobe.commands.DisplayColumnsClientCommand;
import builderb0y.bigglobe.commands.DumpRegistriesCommand;
import builderb0y.bigglobe.commands.EvaluateCommand;
import builderb0y.bigglobe.commands.LocateCommand;
import builderb0y.bigglobe.commands.RespawnCommand;
import builderb0y.bigglobe.commands.SearchF3ClientCommand;
import builderb0y.bigglobe.commands.TracyCommand;
import com.mojang.brigadier.CommandDispatcher;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_7157;

public class BigGlobeCommands {
    public static final String NOT_APPLICABLE = "N/A";
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(double number) {
        DecimalFormat decimalFormat = DECIMAL_FORMAT;
        synchronized (decimalFormat) {
            return DECIMAL_FORMAT.format(number);
        }
    }

    public static void init() {
        BigGlobeMod.LOGGER.debug("Registering command event handler...");
        CommandRegistrationCallback.EVENT.register(BigGlobeCommands::registerCommands);
        BigGlobeMod.LOGGER.debug("Done registering command event handler.");
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        BigGlobeMod.LOGGER.debug("Registering commands to dispatcher...");
        LocateCommand.register(dispatcher);
        RespawnCommand.register(dispatcher);
        EvaluateCommand.register(dispatcher);
        DumpRegistriesCommand.register(dispatcher);
        DevDebugCommand.register(dispatcher);
        TracyCommand.register(dispatcher);
        BigGlobeMod.LOGGER.debug("Done registering commands to dispatcher.");
    }

    @Environment(value=EnvType.CLIENT)
    public static void initClient() {
        BigGlobeMod.LOGGER.debug("Registering client command event handler...");
        ClientCommandRegistrationCallback.EVENT.register(BigGlobeCommands::registerClientCommands);
        BigGlobeMod.LOGGER.debug("Done registering client command event handler.");
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerClientCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        BigGlobeMod.LOGGER.debug("Registering client commands to dispatcher...");
        DisplayColumnsClientCommand.register(dispatcher);
        SearchF3ClientCommand.register(dispatcher);
        BigGlobeMod.LOGGER.debug("Done registering client commands to dispatcher.");
    }

    static {
        DECIMAL_FORMAT.setDecimalSeparatorAlwaysShown(true);
        DECIMAL_FORMAT.setMinimumFractionDigits(1);
        DECIMAL_FORMAT.setMaximumFractionDigits(3);
        DecimalFormatSymbols symbols = DECIMAL_FORMAT.getDecimalFormatSymbols();
        symbols.setNaN(NOT_APPLICABLE);
        DECIMAL_FORMAT.setDecimalFormatSymbols(symbols);
    }
}

