/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.commands;

import builderb0y.bigglobe.chunkgen.BigGlobeScriptedChunkGenerator;
import builderb0y.bigglobe.commands.EnumArgument;
import builderb0y.bigglobe.spawning.BigGlobeSpawnLocator;
import builderb0y.bigglobe.versions.BlockStateVersions;
import builderb0y.bigglobe.versions.EntityVersions;
import builderb0y.bigglobe.versions.WorldPropertiesVersions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Locale;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2183;
import net.minecraft.class_2186;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2794;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_5217;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class RespawnCommand {
    public static final String PREFIX = "commands.bigglobe.respawn.";

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"bigglobe:respawn").requires(source -> source.method_9259(2))).executes(context -> {
            class_2561 failReason = RespawnMode.AUTO.respawnPlayer(((class_2168)context.getSource()).method_9207(), false);
            if (failReason == null) {
                return 1;
            }
            ((class_2168)context.getSource()).method_9213(failReason);
            return 0;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"mode", new EnumArgument<RespawnMode>(RespawnMode.class)).executes(context -> {
            class_2561 failReason = ((RespawnMode)((Object)((Object)context.getArgument("mode", RespawnMode.class)))).respawnPlayer(((class_2168)context.getSource()).method_9207(), false);
            if (failReason == null) {
                return 1;
            }
            ((class_2168)context.getSource()).method_9213(failReason);
            return 0;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            class_2561 failReason = ((RespawnMode)((Object)((Object)context.getArgument("mode", RespawnMode.class)))).respawnPlayer(((class_2168)context.getSource()).method_9207(), (Boolean)context.getArgument("force", Boolean.class));
            if (failReason == null) {
                return 1;
            }
            ((class_2168)context.getSource()).method_9213(failReason);
            return 0;
        })).then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(context -> {
            RespawnMode point = (RespawnMode)((Object)((Object)context.getArgument("mode", RespawnMode.class)));
            Collection players = class_2186.method_9312((CommandContext)context, (String)"players");
            int successCount = 0;
            for (class_3222 player : players) {
                if (point.respawnPlayer(player, false) != null) continue;
                ++successCount;
            }
            if (successCount != players.size()) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.bigglobe.respawn.multi.fail"));
            }
            return successCount;
        })))));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum RespawnMode implements class_3542
    {
        AUTO{

            @Override
            @Nullable
            public class_2561 respawnPlayer(class_3222 player, boolean force) {
                if (1.tryRespawnBed(player, force) == null) {
                    return null;
                }
                if (1.tryRespawnCommand(player, force) == null) {
                    return null;
                }
                return 1.doRespawnWorld(player, EntityVersions.getServer(player).method_30002(), force);
            }
        }
        ,
        BED{

            @Override
            @Nullable
            public class_2561 respawnPlayer(class_3222 player, boolean force) {
                return 2.tryRespawnBed(player, force);
            }
        }
        ,
        COMMAND{

            @Override
            @Nullable
            public class_2561 respawnPlayer(class_3222 player, boolean force) {
                return 3.tryRespawnCommand(player, force);
            }
        }
        ,
        WORLD{

            @Override
            @Nullable
            public class_2561 respawnPlayer(class_3222 player, boolean force) {
                return 4.doRespawnWorld(player, EntityVersions.getServerWorld(player), force);
            }
        }
        ,
        OVERWORLD{

            @Override
            @Nullable
            public class_2561 respawnPlayer(class_3222 player, boolean force) {
                return 5.doRespawnWorld(player, EntityVersions.getServer(player).method_30002(), force);
            }
        }
        ,
        NEW{

            @Override
            @Nullable
            public class_2561 respawnPlayer(class_3222 player, boolean force) {
                return 6.tryRespawnNew(player);
            }
        };

        public final String lowerCaseName = this.name().toLowerCase(Locale.ROOT).intern();

        public String method_15434() {
            return this.lowerCaseName;
        }

        @Nullable
        public abstract class_2561 respawnPlayer(class_3222 var1, boolean var2);

        @Nullable
        public static class_2561 doRespawnWorld(class_3222 player, class_3218 world, boolean force) {
            class_5217 properties = world.method_8401();
            if (force || BlockStateVersions.canSpawnInside(world.method_8320(WorldPropertiesVersions.getSpawnPos(properties))) && BlockStateVersions.canSpawnInside(world.method_8320(WorldPropertiesVersions.getSpawnPos(properties).method_10084()))) {
                EntityVersions.teleport(player, world, new class_243((double)WorldPropertiesVersions.getSpawnX(properties) + 0.5, (double)WorldPropertiesVersions.getSpawnY(properties), (double)WorldPropertiesVersions.getSpawnZ(properties) + 0.5), class_243.field_1353, WorldPropertiesVersions.getSpawnYaw(properties), 0.0f);
                return null;
            }
            return class_2561.method_43471((String)"commands.bigglobe.respawn.area_obstructed");
        }

        @Nullable
        public static class_2561 tryRespawnBed(class_3222 player, boolean force) {
            if (EntityVersions.isRespawnForced(player)) {
                return class_2561.method_43471((String)"commands.bigglobe.respawn.bed.spawn_not_set_by_bed");
            }
            class_2338 position = EntityVersions.getRespawnPosition(player);
            if (position == null) {
                return class_2561.method_43471((String)"commands.bigglobe.respawn.position_not_set");
            }
            class_5321<class_1937> dimension = EntityVersions.getRespawnDimension(player);
            if (dimension == null) {
                return class_2561.method_43471((String)"commands.bigglobe.respawn.dimension_not_set");
            }
            class_3218 world = EntityVersions.getServer(player).method_3847(dimension);
            if (world == null) {
                return class_2561.method_43471((String)"commands.bigglobe.respawn.dimension_doesnt_exist");
            }
            float yaw = EntityVersions.getRespawnAngle(player);
            class_243 actualPosition = class_1657.method_26091((class_3218)world, (class_2338)position, (float)yaw, (boolean)false, (boolean)true).orElse(null);
            if (actualPosition == null) {
                if (force) {
                    actualPosition = class_243.method_24955((class_2382)position);
                } else {
                    return class_2561.method_43471((String)"commands.bigglobe.respawn.bed.destroyed");
                }
            }
            EntityVersions.teleport(player, world, actualPosition, class_243.field_1353, 0.0f, 0.0f);
            player.method_5702(class_2183.class_2184.field_9851, new class_243((double)position.method_10263() + 0.5, (double)position.method_10264() + 0.5, (double)position.method_10260() + 0.5));
            return null;
        }

        @Nullable
        public static class_2561 tryRespawnCommand(class_3222 player, boolean force) {
            if (!EntityVersions.isRespawnForced(player)) {
                return class_2561.method_43471((String)"commands.bigglobe.respawn.command.spawn_not_set_by_command");
            }
            class_2338 position = EntityVersions.getRespawnPosition(player);
            if (position == null) {
                return class_2561.method_43471((String)"commands.bigglobe.respawn.command.position_not_set");
            }
            class_5321<class_1937> dimension = EntityVersions.getRespawnDimension(player);
            if (dimension == null) {
                return class_2561.method_43471((String)"commands.bigglobe.respawn.command.dimension_not_set");
            }
            class_3218 world = EntityVersions.getServer(player).method_3847(dimension);
            if (world == null) {
                return class_2561.method_43469((String)"commands.bigglobe.respawn.command.dimension_doesnt_exist", (Object[])new Object[]{dimension.method_29177().toString()});
            }
            if (force || BlockStateVersions.canSpawnInside(world.method_8320(position)) && BlockStateVersions.canSpawnInside(world.method_8320(position.method_10084()))) {
                float yaw = EntityVersions.getRespawnAngle(player);
                EntityVersions.teleport(player, world, new class_243((double)position.method_10263() + 0.5, (double)position.method_10264(), (double)position.method_10260() + 0.5), class_243.field_1353, yaw, 0.0f);
                return null;
            }
            return class_2561.method_43471((String)"commands.bigglobe.respawn.area_obstructed");
        }

        @Nullable
        public static class_2561 tryRespawnNew(class_3222 player) {
            class_2794 class_27942 = EntityVersions.getServerWorld(player).method_14178().method_12129();
            if (class_27942 instanceof BigGlobeScriptedChunkGenerator) {
                BigGlobeScriptedChunkGenerator generator = (BigGlobeScriptedChunkGenerator)class_27942;
                BigGlobeSpawnLocator.SpawnPoint spawnPoint = BigGlobeSpawnLocator.findSpawn(EntityVersions.getServerWorld(player), generator, EntityVersions.getServerWorld((class_3222)player).field_9229.method_43055());
                if (spawnPoint != null) {
                    EntityVersions.teleport(player, EntityVersions.getServerWorld(player), new class_243(spawnPoint.x(), spawnPoint.y(), spawnPoint.z()), class_243.field_1353, spawnPoint.yaw(), 0.0f);
                    return null;
                }
                return class_2561.method_43471((String)"commands.bigglobe.respawn.new.no_good_location");
            }
            return class_2561.method_43471((String)"commands.bigglobe.respawn.new.not_supported_dimension");
        }
    }
}

