/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.compat.voxy;

import builderb0y.bigglobe.compat.voxy.BitInputStream;
import builderb0y.bigglobe.compat.voxy.BitOutputStream;
import builderb0y.bigglobe.compat.voxy.DistanceGraph;
import java.io.IOException;

public class DistanceGraphIO {
    public static final byte CURRENT_VERSION = 1;

    public static void write(DistanceGraph graph, BitOutputStream stream) throws IOException {
        stream.source.writeByte(1);
        DistanceGraphIO.writeRecursive(graph.root, stream);
    }

    public static void writeRecursive(DistanceGraph.Node node, BitOutputStream stream) throws IOException {
        if (node instanceof DistanceGraph.LeafNode) {
            DistanceGraph.LeafNode leaf = (DistanceGraph.LeafNode)node;
            if (leaf.midX != leaf.minX || leaf.midZ != leaf.minZ) {
                stream.write(false);
            }
            stream.write(leaf.full);
        } else {
            DistanceGraph.PartialNode partial = (DistanceGraph.PartialNode)node;
            stream.write(true);
            DistanceGraphIO.writeRecursive(partial.node00, stream);
            DistanceGraphIO.writeRecursive(partial.node01, stream);
            DistanceGraphIO.writeRecursive(partial.node10, stream);
            DistanceGraphIO.writeRecursive(partial.node11, stream);
        }
    }

    public static DistanceGraph readBlocks(BitInputStream stream) throws IOException {
        return DistanceGraphIO.read(-DistanceGraph.WORLD_SIZE_IN_BLOCKS, -DistanceGraph.WORLD_SIZE_IN_BLOCKS, DistanceGraph.WORLD_SIZE_IN_BLOCKS, DistanceGraph.WORLD_SIZE_IN_BLOCKS, stream);
    }

    public static DistanceGraph readChunks(BitInputStream stream) throws IOException {
        return DistanceGraphIO.read(-DistanceGraph.WORLD_SIZE_IN_CHUNKS, -DistanceGraph.WORLD_SIZE_IN_CHUNKS, DistanceGraph.WORLD_SIZE_IN_CHUNKS, DistanceGraph.WORLD_SIZE_IN_CHUNKS, stream);
    }

    public static DistanceGraph read(int minX, int minZ, int maxX, int maxZ, BitInputStream stream) throws IOException {
        int version = stream.source.readUnsignedByte();
        return new DistanceGraph(switch (version) {
            case 0 -> DistanceGraphIO.readRecursiveV0(minX, maxX, minZ, maxZ, stream);
            case 1 -> DistanceGraphIO.readRecursiveV1(minX, maxX, minZ, maxZ, stream);
            default -> throw new IOException("Unknown data version: " + version);
        });
    }

    public static DistanceGraph.Node readRecursiveV0(int minX, int maxX, int minZ, int maxZ, BitInputStream stream) throws IOException {
        if (stream.readBit()) {
            DistanceGraph.PartialNode partial = new DistanceGraph.PartialNode(minX, maxX, minZ, maxZ, null);
            partial.node00 = DistanceGraphIO.readRecursiveV0(minX, partial.midX, minZ, partial.midZ, stream);
            partial.node01 = DistanceGraphIO.readRecursiveV0(minX, partial.midX, partial.midZ, maxZ, stream);
            partial.node10 = DistanceGraphIO.readRecursiveV0(partial.midX, maxX, minZ, partial.midZ, stream);
            partial.node11 = DistanceGraphIO.readRecursiveV0(partial.midX, maxX, partial.midZ, maxZ, stream);
            return partial;
        }
        return new DistanceGraph.LeafNode(minX, maxX, minZ, maxZ, stream.readBit());
    }

    public static DistanceGraph.Node readRecursiveV1(int minX, int maxX, int minZ, int maxZ, BitInputStream stream) throws IOException {
        if (maxX != minX + 1 && maxZ != minZ + 1 && stream.readBit()) {
            DistanceGraph.PartialNode partial = new DistanceGraph.PartialNode(minX, maxX, minZ, maxZ, null);
            partial.node00 = DistanceGraphIO.readRecursiveV1(minX, partial.midX, minZ, partial.midZ, stream);
            partial.node01 = DistanceGraphIO.readRecursiveV1(minX, partial.midX, partial.midZ, maxZ, stream);
            partial.node10 = DistanceGraphIO.readRecursiveV1(partial.midX, maxX, minZ, partial.midZ, stream);
            partial.node11 = DistanceGraphIO.readRecursiveV1(partial.midX, maxX, partial.midZ, maxZ, stream);
            return partial;
        }
        return new DistanceGraph.LeafNode(minX, maxX, minZ, maxZ, stream.readBit());
    }
}

