/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.noise.perlin;

import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.math.Interpolator;
import builderb0y.bigglobe.noise.NumberArray;
import builderb0y.bigglobe.noise.perlin.PerlinBaseGrid2D;
import builderb0y.bigglobe.settings.Seed;

public class PerlinDerivativeXGrid2D
extends PerlinBaseGrid2D {
    public PerlinDerivativeXGrid2D(Seed salt, int scaleX, int scaleY, double max_slope, double max_offset) {
        super(salt, scaleX, scaleY, max_slope, max_offset);
    }

    @Override
    public double minValue() {
        throw new UnsupportedOperationException("I don't know how to find the local minimum of the derivative of perlin noise.");
    }

    @Override
    public double maxValue() {
        throw new UnsupportedOperationException("I don't know how to find the local maximum of the derivative of perlin noise.");
    }

    @Override
    public double getValue(long seed, int x, int y) {
        seed = this.salt.xor(seed);
        int modX = BigGlobeMath.modulus_BP(x, this.scaleX);
        int modY = BigGlobeMath.modulus_BP(y, this.scaleY);
        int gridX0 = x - modX;
        int gridY0 = y - modY;
        int gridX1 = gridX0 + this.scaleX;
        int gridY1 = gridY0 + this.scaleY;
        double fracX0 = (double)modX * this.rcpX;
        double fracY0 = (double)modY * this.rcpY;
        double fracX1 = fracX0 - 1.0;
        double fracY1 = fracY0 - 1.0;
        double smoothY = Interpolator.smooth(fracY0);
        double slopeX00 = this.slopeX(seed, gridX0, gridY0);
        double slopeX01 = this.slopeX(seed, gridX0, gridY1);
        double slopeX10 = this.slopeX(seed, gridX1, gridY0);
        double slopeX11 = this.slopeX(seed, gridX1, gridY1);
        double slopeY00 = this.slopeY(seed, gridX0, gridY0);
        double slopeY01 = this.slopeY(seed, gridX0, gridY1);
        double slopeY10 = this.slopeY(seed, gridX1, gridY0);
        double slopeY11 = this.slopeY(seed, gridX1, gridY1);
        double offset00 = this.offset(seed, gridX0, gridY0);
        double offset01 = this.offset(seed, gridX0, gridY1);
        double offset10 = this.offset(seed, gridX1, gridY0);
        double offset11 = this.offset(seed, gridX1, gridY1);
        return Interpolator.dMixPerlin(Interpolator.mixLinear(slopeX00 * fracX0 + slopeY00 * fracY0 + offset00, slopeX01 * fracX0 + slopeY01 * fracY1 + offset01, smoothY), Interpolator.mixLinear(slopeX10 * fracX1 + slopeY10 * fracY0 + offset10, slopeX11 * fracX1 + slopeY11 * fracY1 + offset11, smoothY), Interpolator.mixLinear(slopeX00, slopeX01, smoothY), Interpolator.mixLinear(slopeX10, slopeX11, smoothY), fracX0) * this.rcpX;
    }

    @Override
    public void getBulkX(long seed, int startX, int y, NumberArray samples) {
        int sampleCount = samples.length();
        if (sampleCount <= 0) {
            return;
        }
        seed = this.salt.xor(seed);
        int scaleX = this.scaleX;
        int modX = BigGlobeMath.modulus_BP(startX, scaleX);
        int modY = BigGlobeMath.modulus_BP(y, this.scaleY);
        int gridX = startX - modX;
        int gridY0 = y - modY;
        int gridY1 = gridY0 + this.scaleY;
        double rcpX = this.rcpX;
        double fracY0 = (double)modY * this.rcpY;
        double fracY1 = fracY0 - 1.0;
        double smoothY = Interpolator.smooth(fracY0);
        double slopeX00 = this.slopeX(seed, gridX, gridY0);
        double slopeX01 = this.slopeX(seed, gridX, gridY1);
        double slopeY00 = this.slopeY(seed, gridX, gridY0);
        double slopeY01 = this.slopeY(seed, gridX, gridY1);
        double offset00 = this.offset(seed, gridX, gridY0);
        double offset01 = this.offset(seed, gridX, gridY1);
        double slopeX10 = this.slopeX(seed, gridX += scaleX, gridY0);
        double slopeX11 = this.slopeX(seed, gridX, gridY1);
        double slopeY10 = this.slopeY(seed, gridX, gridY0);
        double slopeY11 = this.slopeY(seed, gridX, gridY1);
        double offset10 = this.offset(seed, gridX, gridY0);
        double offset11 = this.offset(seed, gridX, gridY1);
        double partial0 = Interpolator.mixLinear(slopeX00, slopeX01, smoothY);
        double partial1 = Interpolator.mixLinear(slopeX10, slopeX11, smoothY);
        int index = 0;
        while (true) {
            double fracX0 = (double)modX * rcpX;
            double fracX1 = fracX0 - 1.0;
            samples.setD(index, Interpolator.dMixPerlin(Interpolator.mixLinear(slopeX00 * fracX0 + slopeY00 * fracY0 + offset00, slopeX01 * fracX0 + slopeY01 * fracY1 + offset01, smoothY), Interpolator.mixLinear(slopeX10 * fracX1 + slopeY10 * fracY0 + offset10, slopeX11 * fracX1 + slopeY11 * fracY1 + offset11, smoothY), partial0, partial1, fracX0) * rcpX);
            if (++index >= sampleCount) break;
            if (++modX < scaleX) continue;
            modX = 0;
            slopeX00 = slopeX10;
            slopeX01 = slopeX11;
            slopeY00 = slopeY10;
            slopeY01 = slopeY11;
            offset00 = offset10;
            offset01 = offset11;
            slopeX10 = this.slopeX(seed, gridX += scaleX, gridY0);
            slopeX11 = this.slopeX(seed, gridX, gridY1);
            slopeY10 = this.slopeY(seed, gridX, gridY0);
            slopeY11 = this.slopeY(seed, gridX, gridY1);
            offset10 = this.offset(seed, gridX, gridY0);
            offset11 = this.offset(seed, gridX, gridY1);
            partial0 = Interpolator.mixLinear(slopeX00, slopeX01, smoothY);
            partial1 = Interpolator.mixLinear(slopeX10, slopeX11, smoothY);
        }
    }

    @Override
    public void getBulkY(long seed, int x, int startY, NumberArray samples) {
        int sampleCount = samples.length();
        if (sampleCount <= 0) {
            return;
        }
        seed = this.salt.xor(seed);
        int scaleY = this.scaleY;
        int modX = BigGlobeMath.modulus_BP(x, this.scaleX);
        int modY = BigGlobeMath.modulus_BP(startY, scaleY);
        int gridX0 = x - modX;
        int gridX1 = gridX0 + this.scaleX;
        int gridY = startY - modY;
        double rcpX = this.rcpX;
        double rcpY = this.rcpY;
        double fracX0 = (double)modX * rcpX;
        double fracX1 = fracX0 - 1.0;
        double smoothX = Interpolator.smooth(fracX0);
        double dSmoothX = Interpolator.smoothDerivative(fracX0);
        double slopeX00 = this.slopeX(seed, gridX0, gridY);
        double slopeX10 = this.slopeX(seed, gridX1, gridY);
        double slopeY00 = this.slopeY(seed, gridX0, gridY);
        double slopeY10 = this.slopeY(seed, gridX1, gridY);
        double offset00 = this.offset(seed, gridX0, gridY);
        double offset10 = this.offset(seed, gridX1, gridY);
        double slopeX01 = this.slopeX(seed, gridX0, gridY += scaleY);
        double slopeX11 = this.slopeX(seed, gridX1, gridY);
        double slopeY01 = this.slopeY(seed, gridX0, gridY);
        double slopeY11 = this.slopeY(seed, gridX1, gridY);
        double offset01 = this.offset(seed, gridX0, gridY);
        double offset11 = this.offset(seed, gridX1, gridY);
        int index = 0;
        while (true) {
            double fracY0 = (double)modY * rcpY;
            double fracY1 = fracY0 - 1.0;
            double smoothY = Interpolator.smooth(fracY0);
            samples.setD(index, Interpolator.dMixPerlinExplicit(Interpolator.mixLinear(slopeX00 * fracX0 + slopeY00 * fracY0 + offset00, slopeX01 * fracX0 + slopeY01 * fracY1 + offset01, smoothY), Interpolator.mixLinear(slopeX10 * fracX1 + slopeY10 * fracY0 + offset10, slopeX11 * fracX1 + slopeY11 * fracY1 + offset11, smoothY), smoothX, Interpolator.mixLinear(slopeX00, slopeX01, smoothY), Interpolator.mixLinear(slopeX10, slopeX11, smoothY), dSmoothX) * rcpX);
            if (++index >= sampleCount) break;
            if (++modY < scaleY) continue;
            modY = 0;
            slopeX00 = slopeX01;
            slopeX10 = slopeX11;
            slopeY00 = slopeY01;
            slopeY10 = slopeY11;
            offset00 = offset01;
            offset10 = offset11;
            slopeX01 = this.slopeX(seed, gridX0, gridY += scaleY);
            slopeX11 = this.slopeX(seed, gridX1, gridY);
            slopeY01 = this.slopeY(seed, gridX0, gridY);
            slopeY11 = this.slopeY(seed, gridX1, gridY);
            offset01 = this.offset(seed, gridX0, gridY);
            offset11 = this.offset(seed, gridX1, gridY);
        }
    }
}

