/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.noise.processing;

import builderb0y.bigglobe.noise.Grid;
import builderb0y.bigglobe.noise.processing.LayeredGrid;

public abstract class ProductGrid
implements LayeredGrid {
    public final transient double minValue;
    public final transient double maxValue;

    public ProductGrid(Grid ... layers) {
        double minValue = layers[0].minValue();
        double maxValue = layers[0].maxValue();
        int length = layers.length;
        for (int index = 1; index < length; ++index) {
            double newMin = layers[index].minValue();
            double newMax = layers[index].maxValue();
            double product1 = minValue * newMin;
            double product2 = minValue * newMax;
            double product3 = maxValue * newMin;
            double product4 = maxValue * newMax;
            minValue = Math.min(Math.min(product1, product2), Math.min(product3, product4));
            maxValue = Math.max(Math.max(product1, product2), Math.max(product3, product4));
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public double minValue() {
        return this.minValue;
    }

    @Override
    public double maxValue() {
        return this.maxValue;
    }

    @Override
    public boolean isProduct() {
        return true;
    }
}

