/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.overriders;

import builderb0y.autocodec.annotations.MemberUsage;
import builderb0y.autocodec.annotations.UseCoder;
import builderb0y.autocodec.coders.AutoCoder;
import builderb0y.autocodec.coders.KeyDispatchCoder;
import builderb0y.autocodec.reflection.reification.ReifiedType;
import builderb0y.bigglobe.chunkgen.BigGlobeScriptedChunkGenerator;
import builderb0y.bigglobe.codecs.BigGlobeAutoCodec;
import builderb0y.bigglobe.columns.scripted.ScriptedColumnLookup;
import builderb0y.bigglobe.columns.scripted.dependencies.IndirectDependencyCollector;
import builderb0y.bigglobe.columns.scripted.entries.ColumnEntry;
import builderb0y.bigglobe.overriders.CollisionOverrider;
import builderb0y.bigglobe.overriders.ColumnValueOverrider;
import builderb0y.bigglobe.overriders.StructureOverrider;
import builderb0y.bigglobe.scripting.wrappers.StructureStartWrapper;
import builderb0y.bigglobe.util.UnregisteredObjectException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@UseCoder(name="CODER", in=Overrider.class, usage=MemberUsage.FIELD_CONTAINS_HANDLER)
public interface Overrider {
    public static final AutoCoder<Overrider> CODER = new KeyDispatchCoder<Type, Overrider>(ReifiedType.from(Overrider.class), BigGlobeAutoCodec.AUTO_CODEC.createCoder(Type.class)){

        @Nullable
        public Type getKey(@NotNull Overrider object) {
            return object.getOverriderType();
        }

        @Nullable
        public AutoCoder<? extends Overrider> getCoder(@NotNull Type type) {
            return type.coder;
        }
    };

    public Type getOverriderType();

    public static enum Type {
        STRUCTURE(StructureOverrider.Entry.class),
        COLLISION(CollisionOverrider.Entry.class),
        COLUMN_VALUE(ColumnValueOverrider.Entry.class);

        public final Class<? extends Overrider> overriderClass;
        public final AutoCoder<? extends Overrider> coder;

        private Type(Class<? extends Overrider> overriderClass) {
            this.overriderClass = overriderClass;
            this.coder = BigGlobeAutoCodec.AUTO_CODEC.createCoder(overriderClass);
        }
    }

    public static class SortedOverriders {
        public final StructureOverrider.Entry[] structures;
        public final CollisionOverrider.Entry[] collisions;
        public final class_6880<ColumnValueOverrider.Entry>[] rawColumnValues;
        public final class_6880<ColumnValueOverrider.Entry>[] featureColumnValues;
        public final String[] rawColumnValueDependencies;
        public final String[] featureColumnValueDependencies;

        public SortedOverriders(BigGlobeScriptedChunkGenerator generator) {
            Map<Type, List<class_6880>> map = generator.overriders.entryStream().collect(Collectors.groupingBy(entry -> ((Overrider)entry.comp_349()).getOverriderType()));
            this.structures = (StructureOverrider.Entry[])map.getOrDefault((Object)Type.STRUCTURE, Collections.emptyList()).stream().map(class_6880::comp_349).map(StructureOverrider.Entry.class::cast).toArray(StructureOverrider.Entry[]::new);
            this.collisions = (CollisionOverrider.Entry[])map.getOrDefault((Object)Type.COLLISION, Collections.emptyList()).stream().map(class_6880::comp_349).map(CollisionOverrider.Entry.class::cast).toArray(CollisionOverrider.Entry[]::new);
            this.rawColumnValues = (class_6880[])map.getOrDefault((Object)Type.COLUMN_VALUE, Collections.emptyList()).stream().filter(overrider -> ((ColumnValueOverrider.Entry)overrider.comp_349()).raw_generation()).toArray(class_6880[]::new);
            this.featureColumnValues = (class_6880[])map.getOrDefault((Object)Type.COLUMN_VALUE, Collections.emptyList()).stream().filter(overrider -> ((ColumnValueOverrider.Entry)overrider.comp_349()).feature_generation()).toArray(class_6880[]::new);
            this.rawColumnValueDependencies = this.extractDependencies(this.rawColumnValues, generator);
            this.featureColumnValueDependencies = this.extractDependencies(this.featureColumnValues, generator);
        }

        public int getCollisionPriority(ScriptedColumnLookup columns, StructureStartWrapper currentStructure, StructureStartWrapper otherStructure) {
            for (CollisionOverrider.Entry collision : this.collisions) {
                int priority = collision.script().override(columns, currentStructure, otherStructure);
                if (priority == 0) continue;
                return priority;
            }
            return 0;
        }

        public String[] extractDependencies(class_6880<ColumnValueOverrider.Entry>[] holders, BigGlobeScriptedChunkGenerator generator) {
            IndirectDependencyCollector collector = new IndirectDependencyCollector(generator);
            for (class_6880<ColumnValueOverrider.Entry> entry : holders) {
                ((ColumnValueOverrider.Entry)entry.comp_349()).script().streamDirectDependencies().forEach(collector);
            }
            return (String[])collector.stream().filter(registryEntry -> {
                ColumnEntry columnEntry;
                Object patt0$temp = registryEntry.comp_349();
                return patt0$temp instanceof ColumnEntry && generator.columnEntryRegistry.voronoiManager.getEnablingSettings(columnEntry = (ColumnEntry)patt0$temp).isEmpty() && columnEntry.hasField();
            }).map(UnregisteredObjectException::getID).map(class_2960::toString).map(String::intern).toArray(String[]::new);
        }
    }
}

