/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.randomSources;

import builderb0y.autocodec.annotations.MemberUsage;
import builderb0y.autocodec.annotations.UseCoder;
import builderb0y.autocodec.data.AbstractNumberData;
import builderb0y.autocodec.data.Data;
import builderb0y.autocodec.data.NumberData;
import builderb0y.autocodec.decoders.DecodeContext;
import builderb0y.autocodec.decoders.DecodeException;
import builderb0y.autocodec.encoders.EncodeContext;
import builderb0y.autocodec.encoders.EncodeException;
import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.codecs.CoderRegistry;
import builderb0y.bigglobe.codecs.CoderRegistryTyped;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.math.Interpolator;
import builderb0y.bigglobe.randomSources.AveragedRandomSource;
import builderb0y.bigglobe.randomSources.ConstantRandomSource;
import builderb0y.bigglobe.randomSources.ExponentialRandomSource;
import builderb0y.bigglobe.randomSources.GaussianRandomSource;
import builderb0y.bigglobe.randomSources.LinearCenteredRandomSource;
import builderb0y.bigglobe.randomSources.LinearHighRandomSource;
import builderb0y.bigglobe.randomSources.LinearLowRandomSource;
import builderb0y.bigglobe.randomSources.ScriptedRandomSource;
import builderb0y.bigglobe.randomSources.UniformRandomSource;
import java.util.random.RandomGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UseCoder(name="REGISTRY", usage=MemberUsage.FIELD_CONTAINS_HANDLER)
public interface RandomSource
extends CoderRegistryTyped<RandomSource> {
    public static final CoderRegistry<RandomSource> REGISTRY = new CoderRegistry<RandomSource>(BigGlobeMod.modID("random_source")){

        @NotNull
        public <T_Encoded> Data encode(@NotNull EncodeContext<T_Encoded, RandomSource> context) throws EncodeException {
            Object object = context.object;
            if (object instanceof ConstantRandomSource) {
                ConstantRandomSource constant = (ConstantRandomSource)object;
                return new NumberData(constant.value());
            }
            return super.encode(context);
        }

        @Nullable
        public <T_Encoded> RandomSource decode(@NotNull DecodeContext<T_Encoded> context) throws DecodeException {
            AbstractNumberData number = context.tryAsNumber();
            if (number != null) {
                return new ConstantRandomSource(number.doubleValue());
            }
            return (RandomSource)super.decode(context);
        }
    };
    public static final Object INITIALIZER = new Object(){
        {
            REGISTRY.registerAuto(BigGlobeMod.modID("constant"), ConstantRandomSource.class);
            REGISTRY.registerAuto(BigGlobeMod.modID("uniform"), UniformRandomSource.class);
            REGISTRY.registerAuto(BigGlobeMod.modID("linear_low"), LinearLowRandomSource.class);
            REGISTRY.registerAuto(BigGlobeMod.modID("linear_high"), LinearHighRandomSource.class);
            REGISTRY.registerAuto(BigGlobeMod.modID("linear_centered"), LinearCenteredRandomSource.class);
            REGISTRY.registerAuto(BigGlobeMod.modID("gaussian"), GaussianRandomSource.class);
            REGISTRY.registerAuto(BigGlobeMod.modID("exponential"), ExponentialRandomSource.class);
            REGISTRY.registerAuto(BigGlobeMod.modID("average"), AveragedRandomSource.class);
            REGISTRY.registerAuto(BigGlobeMod.modID("scripted"), ScriptedRandomSource.class);
        }
    };

    public double get(ScriptedColumn var1, int var2, long var3);

    public double get(ScriptedColumn var1, int var2, RandomGenerator var3);

    default public boolean requiresColumn() {
        return false;
    }

    public double minValue();

    public double maxValue();

    default public double mix(double value) {
        return Interpolator.mixLinear(this.minValue(), this.maxValue(), value);
    }
}

