/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.rendering;

import builderb0y.bigglobe.rendering.GLException;
import builderb0y.bigglobe.rendering.TextureState;
import org.lwjgl.opengl.GL13C;

public class FilteredTextureState
extends TextureState {
    public int minFilter;
    public int magFilter;
    public int wrapX;
    public int wrapY;

    public FilteredTextureState(int binder, int bindQuery, int index) {
        super(binder, bindQuery, index);
    }

    public void set(int texture, int minFilter, int magFilter, int wrapX, int wrapY) {
        GL13C.glActiveTexture((int)this.index);
        GLException.check();
        GL13C.glBindTexture((int)this.binder, (int)texture);
        GLException.check();
        GL13C.glTexParameteri((int)this.binder, (int)10241, (int)minFilter);
        GLException.check();
        GL13C.glTexParameteri((int)this.binder, (int)10240, (int)magFilter);
        GLException.check();
        GL13C.glTexParameteri((int)this.binder, (int)10242, (int)wrapX);
        GLException.check();
        GL13C.glTexParameteri((int)this.binder, (int)10243, (int)wrapY);
        GLException.check();
    }

    @Override
    public void capture() {
        super.capture();
        this.minFilter = GL13C.glGetTexParameteri((int)this.binder, (int)10241);
        GLException.check();
        this.magFilter = GL13C.glGetTexParameteri((int)this.binder, (int)10240);
        GLException.check();
        this.wrapX = GL13C.glGetTexParameteri((int)this.binder, (int)10242);
        GLException.check();
        this.wrapY = GL13C.glGetTexParameteri((int)this.binder, (int)10243);
        GLException.check();
    }

    @Override
    public void restore() {
        super.restore();
        GL13C.glTexParameteri((int)this.binder, (int)10241, (int)this.minFilter);
        GLException.check();
        GL13C.glTexParameteri((int)this.binder, (int)10240, (int)this.magFilter);
        GLException.check();
        GL13C.glTexParameteri((int)this.binder, (int)10242, (int)this.wrapX);
        GLException.check();
        GL13C.glTexParameteri((int)this.binder, (int)10243, (int)this.wrapY);
        GLException.check();
    }
}

