/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.rendering.lods;

import builderb0y.bigglobe.chunkgen.scripted.BlockSegmentList;
import builderb0y.bigglobe.config.BigGlobeConfig;
import builderb0y.bigglobe.rendering.lods.LightweightChunk;
import builderb0y.bigglobe.rendering.lods.LodGenerator;
import builderb0y.bigglobe.rendering.lods.LodSystem;
import builderb0y.bigglobe.util.SafeCloseable;
import builderb0y.bigglobe.util.TimestampedComputingCache;
import builderb0y.bigglobe.versions.NbtVersions;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3898;
import net.minecraft.class_5539;

public class LodChunkCache
implements SafeCloseable {
    public final LodGenerator generator;
    public final class_3218 world;
    public final class_3898 loader;
    public final TimestampedComputingCache<class_1923, LightweightChunk> chunks;
    public final ConcurrentLinkedQueue<class_1923> dirtyChunks;
    public final ExecutorService ingester = Executors.newSingleThreadExecutor(runnable -> {
        Thread thread = new Thread(runnable, "Big Globe LOD chunk ingest thread");
        thread.setDaemon(true);
        return thread;
    });

    public LodChunkCache(LodGenerator generator, class_3218 world) {
        this.generator = generator;
        this.world = world;
        this.loader = world.method_14178().field_17254;
        this.chunks = new TimestampedComputingCache(TimestampedComputingCache.Units.seconds(10.0), TimestampedComputingCache.Units.gigabytes(1.0));
        this.dirtyChunks = new ConcurrentLinkedQueue();
    }

    public void invalidateChunkLater(class_1923 chunkPos) {
        this.dirtyChunks.add(chunkPos);
    }

    public void processDirtyChunks(LodSystem system) {
        if (this.chunks.globalLock.tryLock()) {
            try {
                class_1923 chunkPos;
                while ((chunkPos = this.dirtyChunks.poll()) != null) {
                    if (this.chunks.tryInvalidate(chunkPos)) {
                        system.invalidateChunkNow(chunkPos);
                        continue;
                    }
                    this.dirtyChunks.add(chunkPos);
                    break;
                }
            }
            finally {
                this.chunks.globalLock.unlock();
            }
        }
    }

    public LightweightChunk getChunk(class_1923 chunkPos) {
        return this.chunks.computeIfUnknown(chunkPos, chunkPos_ -> {
            Optional nbt;
            try {
                nbt = (Optional)this.loader.method_43383(chunkPos_).join();
            }
            catch (CancellationException exception) {
                return null;
            }
            catch (CompletionException exception) {
                if (exception.getCause() instanceof CancellationException) {
                    return null;
                }
                throw exception;
            }
            return nbt.isPresent() ? this.convertChunk(chunkPos, (class_2487)nbt.get()) : null;
        });
    }

    public LightweightChunk convertChunk(class_1923 chunkPos, class_2487 root) {
        class_2519 string;
        class_2520 class_25202 = root.method_10580("Status");
        if (class_25202 instanceof class_2519 && NbtVersions.stringValue(string = (class_2519)class_25202).equals("minecraft:full") && (class_25202 = root.method_10580("sections")) instanceof class_2499) {
            class_2499 sectionsNbt = (class_2499)class_25202;
            BlockSegmentList[] cullingData = BigGlobeConfig.INSTANCE.get().lodRendering.caveCullingDepth >= 0 && !this.world.method_8597().comp_643() ? this.generator.generateCullingChunk(chunkPos) : null;
            LightweightChunk result = new LightweightChunk((class_5539)this.world, chunkPos);
            result.update(this.world, sectionsNbt, cullingData);
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LightweightChunk[] getChunks(class_1923 minPos, class_1923 maxPos) {
        int chunkCount = (maxPos.field_9181 - minPos.field_9181) * (maxPos.field_9180 - minPos.field_9180);
        ReentrantLock[] lockedHolders = new ReentrantLock[chunkCount];
        CompletableFuture[] futures = new CompletableFuture[chunkCount];
        LightweightChunk[] chunks = new LightweightChunk[chunkCount];
        try {
            int index = 0;
            for (int chunkZ = minPos.field_9180; chunkZ < maxPos.field_9180; ++chunkZ) {
                for (int chunkX = minPos.field_9181; chunkX < maxPos.field_9181; ++chunkX) {
                    int index_ = index;
                    class_1923 chunkPos = new class_1923(chunkX, chunkZ);
                    TimestampedComputingCache.ValueHolder<LightweightChunk> holder = this.chunks.getHolder(chunkPos, true);
                    lockedHolders[index] = holder.lock;
                    lockedHolders[index].lock();
                    if (holder.state != 2) {
                        chunks[index] = (LightweightChunk)holder.value;
                    } else {
                        futures[index] = this.loader.method_43383(chunkPos).thenApplyAsync(optional -> {
                            LightweightChunk chunk = optional.isPresent() ? this.convertChunk(chunkPos, (class_2487)optional.get()) : null;
                            holder.set(chunk);
                            chunks[index_] = chunk;
                            if (chunk != null) {
                                this.chunks.presentCount.incrementAndGet();
                            }
                            return null;
                        }, (Executor)this.ingester);
                    }
                    ++index;
                }
            }
        }
        finally {
            try {
                LodChunkCache.joinAll(futures);
            }
            finally {
                for (ReentrantLock lock : lockedHolders) {
                    if (lock == null) continue;
                    lock.unlock();
                }
            }
        }
        return chunks;
    }

    public static void joinAll(CompletableFuture<?> ... futures) {
        Throwable exception = null;
        for (CompletableFuture<?> future : futures) {
            if (future == null) continue;
            try {
                future.join();
            }
            catch (Throwable throwable) {
                if (throwable instanceof CompletionException && throwable.getCause() instanceof CancellationException) continue;
                try {
                    if (exception == null) {
                        exception = new CompletionException(null);
                    }
                    exception.addSuppressed(throwable);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public void close() {
        this.chunks.clear();
    }
}

