/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.rendering.lods;

import builderb0y.autocodec.util.AutoCodecUtil;
import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.ClientState;
import builderb0y.bigglobe.blocks.BlockStates;
import builderb0y.bigglobe.chunkgen.QuadHolder;
import builderb0y.bigglobe.chunkgen.scripted.BlockSegmentList;
import builderb0y.bigglobe.chunkgen.scripted.Layer;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.config.BigGlobeConfig;
import builderb0y.bigglobe.rendering.ResourceTracker;
import builderb0y.bigglobe.rendering.lods.LightweightChunk;
import builderb0y.bigglobe.rendering.lods.LodChunkCache;
import builderb0y.bigglobe.rendering.lods.LodQuadTree;
import builderb0y.bigglobe.rendering.lods.LodRenderer;
import builderb0y.bigglobe.rendering.lods.LodSystem;
import builderb0y.bigglobe.rendering.lods.VersionedVertexConsumerProvider;
import builderb0y.bigglobe.util.AsyncRunner;
import builderb0y.bigglobe.util.BigGlobeThreadPool;
import builderb0y.bigglobe.util.Directions;
import builderb0y.bigglobe.util.SafeCloseable;
import builderb0y.bigglobe.util.TimestampedComputingCache;
import builderb0y.bigglobe.versions.BlockStateVersions;
import builderb0y.bigglobe.versions.DirectionVersions;
import builderb0y.bigglobe.versions.RegistryVersions;
import java.util.ConcurrentModificationException;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.class_1132;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_2823;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6539;
import net.minecraft.class_6880;
import net.minecraft.class_776;
import net.minecraft.class_778;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class LodGenerator
implements SafeCloseable {
    public static final int INNER_WIDTH = 64;
    public static final int INNER_AREA = 4096;
    public static final int SINGLE_RENDER_PADDING = 2;
    public static final int DOUBLE_RENDER_PADDING = 4;
    public static final int RENDER_WIDTH = 68;
    public static final int RENDER_AREA = 4624;
    public static final int EDGE_THICKNESS = 4;
    public static final int SHORT_EDGE_LENGTH = 128;
    public static final int SHORT_EDGE_AREA = 512;
    public static final int LONG_EDGE_LENGTH = 136;
    public static final int LONG_EDGE_AREA = 544;
    public static final int EDGE_COLUMN_COUNT = 2112;
    public static final int TOTAL_COLUMN_COUNT = 6208;
    public static final ThreadLocal<Boolean> RENDERING_LODS = ThreadLocal.withInitial(() -> Boolean.FALSE);
    public final LodSystem system;
    @Nullable
    public final LodChunkCache chunkCache;
    public final ClientState.ClientGeneratorParams generatorParams;
    public final int maxLoadLevel;
    public final LinkedBlockingQueue<ScriptedColumn[]> columns;
    public final LinkedBlockingQueue<LodRequest> requests;
    public final ConcurrentLinkedQueue<LodSupply> currentSupply;
    public final AtomicInteger activeMeshers = new AtomicInteger();
    public final Thread thread;
    public volatile boolean running;
    public final byte topSkyLight;

    public String f3Message() {
        int loadOnly = 0;
        int loadOrGen = 0;
        int genOnly = 0;
        int total = 0;
        for (LodRequest request : this.requests) {
            switch (request.loadMode().ordinal()) {
                case 2: {
                    ++loadOnly;
                    break;
                }
                case 1: {
                    ++loadOrGen;
                    break;
                }
                case 0: {
                    ++genOnly;
                }
            }
            ++total;
        }
        return "[BG] LOD Req L: " + loadOnly + ", G: " + genOnly + ", LG: " + loadOrGen + ", T: " + total + ", Cache: " + this.cacheDescription();
    }

    public String cacheDescription() {
        if (this.chunkCache == null) {
            return "null";
        }
        TimestampedComputingCache<class_1923, LightweightChunk> chunks = this.chunkCache.chunks;
        int present = chunks.presentCount.get();
        int total = chunks.size();
        int empty = total - present;
        return present + "/" + empty + "/" + total;
    }

    public LodGenerator(LodSystem system, ClientState.ClientGeneratorParams generatorParams) {
        class_3218 serverWorld;
        this.system = system;
        this.generatorParams = generatorParams;
        this.maxLoadLevel = BigGlobeConfig.INSTANCE.get().lodRendering.maxLodForChunkLoading;
        int threads = Runtime.getRuntime().availableProcessors();
        this.columns = new LinkedBlockingQueue(threads);
        ScriptedColumn.Factory factory = generatorParams.columnEntryRegistry.columnFactory;
        ScriptedColumn.Params params = new ScriptedColumn.Params(generatorParams.columnSeed, 0, 0, generatorParams.minY, generatorParams.maxY, ScriptedColumn.ColumnUsage.RAW_GENERATION.builtinLodHints(0), generatorParams.compiledWorldTraits);
        for (int thread = 0; thread < threads; ++thread) {
            ScriptedColumn[] columns = new ScriptedColumn[6208];
            for (int index = 0; index < 6208; ++index) {
                columns[index] = factory.create(params);
            }
            this.columns.add(columns);
        }
        this.requests = new LinkedBlockingQueue();
        this.currentSupply = new ConcurrentLinkedQueue();
        this.thread = new Thread(this::runLoop, "Big Globe LOD generator thread");
        LodChunkCache chunkCache = null;
        class_1132 server = class_310.method_1551().method_1576();
        if (server != null && (serverWorld = server.method_3847(this.system.world.method_27983())) != null) {
            chunkCache = new LodChunkCache(this, serverWorld);
        }
        this.chunkCache = chunkCache;
        this.topSkyLight = (byte)(system.world.method_8597().comp_642() ? 15 : 0);
    }

    public void start() {
        if (!this.running) {
            this.running = true;
            this.thread.start();
        }
    }

    @Override
    public void close() {
        int meshers;
        this.running = false;
        try {
            this.thread.interrupt();
            this.thread.join();
        }
        catch (InterruptedException exception) {
            BigGlobeMod.LOGGER.warn("Who's trying to interrupt the shutdown process?", (Throwable)exception);
        }
        long nextLog = System.currentTimeMillis() + 5000L;
        while ((meshers = this.activeMeshers.get()) > 0) {
            Thread.onSpinWait();
            if (System.currentTimeMillis() < nextLog) continue;
            BigGlobeMod.LOGGER.info("Waiting for " + meshers + " task(s) to complete...");
            nextLog += 5000L;
        }
        ResourceTracker.closeAll(this.requests);
        ResourceTracker.closeAll(this.currentSupply);
        if (this.chunkCache != null) {
            this.chunkCache.close();
        }
    }

    public void request(LodQuadTree tree, LoadMode loadMode) {
        assert (!tree.isQueued()) : "attempt to request already-queued tree";
        this.requests.add(new LodRequest(this.system, tree, loadMode, this.system.renderer.beginMeshing()));
        tree.rebuildTime = Long.MAX_VALUE;
        tree.setQueued(true);
    }

    public boolean hasSupply() {
        return !this.currentSupply.isEmpty();
    }

    @Nullable
    public LodSupply getSupply() {
        return this.currentSupply.poll();
    }

    public void runLoop() {
        try {
            while (true) {
                if (!this.running) {
                    BigGlobeMod.LOGGER.info("Big Globe LOD generator thread shutting down.");
                    break;
                }
                LodRequest request = null;
                try {
                    request = this.requests.take();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (request == null) continue;
                if (request.owner.isQueued()) {
                    this.buildRegion(request);
                    continue;
                }
                this.currentSupply.add(new LodSupply(request, false));
            }
        }
        catch (Throwable throwable) {
            BigGlobeMod.LOGGER.error("Exception in Big Globe LOD generator thread:", throwable);
            this.running = false;
        }
    }

    public void buildRegion(LodRequest request) {
        ColumnResults results;
        ColumnResults columnResults = results = request.owner.level == 6 ? this.generateLod0Columns(request) : this.generateLodNColumns(request);
        if (results == null) {
            this.currentSupply.add(new LodSupply(request, false));
            return;
        }
        this.activeMeshers.incrementAndGet();
        BigGlobeThreadPool.lodExecutor().execute(() -> {
            Boolean oldRenderingLods = RENDERING_LODS.get();
            try {
                RENDERING_LODS.set(Boolean.TRUE);
                this.buildGeometry(request, results, request.provider);
                this.currentSupply.add(new LodSupply(request, true));
            }
            catch (Throwable throwable) {
                this.currentSupply.add(new LodSupply(request, false));
                BigGlobeMod.LOGGER.error("Exception generating LOD meshes:", throwable);
                this.running = false;
            }
            finally {
                RENDERING_LODS.set(oldRenderingLods);
                this.columns.add(results.recyclableColumns);
                this.activeMeshers.decrementAndGet();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockSegmentList[] generateCullingChunk(class_1923 chunkPos) {
        ScriptedColumn[] columns;
        try {
            columns = this.columns.take();
        }
        catch (InterruptedException ignored) {
            return null;
        }
        try {
            BlockSegmentList[] lists = new BlockSegmentList[LightweightChunk.ColumnIndexRange.LOD4.end];
            int minY = this.generatorParams.minY;
            int maxY = this.generatorParams.maxY;
            Layer layer = (Layer)this.generatorParams.layer.comp_349();
            ScriptedColumn.Params params = new ScriptedColumn.Params(this.generatorParams.columnSeed, 0, 0, minY, maxY, ScriptedColumn.ColumnUsage.HEIGHTMAP.builtinLodHints(0), this.generatorParams.compiledWorldTraits);
            int minX = chunkPos.field_9181 << 4;
            int minZ = chunkPos.field_9180 << 4;
            try (AsyncRunner async = BigGlobeThreadPool.lodRunner();){
                for (int offsetZ = 0; offsetZ < 16; offsetZ += 2) {
                    int offsetZ_ = offsetZ;
                    for (int offsetX = 0; offsetX < 16; offsetX += 2) {
                        int offsetX_ = offsetX;
                        async.submit(() -> {
                            int baseIndex = offsetZ_ << 4 | offsetX_;
                            int quadX = minX | offsetX_;
                            int quadZ = minZ | offsetZ_;
                            QuadHolder.QuadColumn quadColumn = new QuadHolder.QuadColumn();
                            quadColumn.loadFromArray(columns, baseIndex, 16);
                            quadColumn.at(params, quadX, quadZ, 1);
                            QuadHolder.QuadList quadList = new QuadHolder.QuadList();
                            quadList.createNew(minY, maxY);
                            QuadHolder.generate(quadColumn, quadList, layer);
                            quadList.storeInArray(lists, baseIndex, 16);
                        });
                    }
                }
            }
            for (int srcLod = 0; srcLod < 4; ++srcLod) {
                int dstLod = srcLod + 1;
                int srcShift = 4 - srcLod;
                int dstShift = 4 - dstLod;
                int dstChunkSize = 1 << dstShift;
                int srcBase = LightweightChunk.ColumnIndexRange.VALUES[srcLod].start;
                int dstBase = LightweightChunk.ColumnIndexRange.VALUES[dstLod].start;
                int srcZ = 0;
                for (int dstZ = 0; dstZ < dstChunkSize; ++dstZ) {
                    int srcX = 0;
                    for (int dstX = 0; dstX < dstChunkSize; ++dstX) {
                        int srcIndex = (srcZ << srcShift | srcX) + srcBase;
                        int dstIndex = (dstZ << dstShift | dstX) + dstBase;
                        lists[dstIndex] = QuadHolder.QuadList.downscaleColumn(lists[srcIndex], 1);
                        srcX += 2;
                    }
                    srcZ += 2;
                }
            }
            BlockSegmentList[] blockSegmentListArray = lists;
            return blockSegmentListArray;
        }
        finally {
            this.columns.add(columns);
        }
    }

    public static boolean anyNonNulls(LightweightChunk[] chunks) {
        for (LightweightChunk chunk : chunks) {
            if (chunk == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public ColumnResults generateLod0Columns(LodRequest request) {
        ScriptedColumn[] columns;
        int minX = request.owner.minX();
        int minZ = request.owner.minZ();
        int maxX = request.owner.maxX();
        int maxZ = request.owner.maxZ();
        int paddedMinX = minX - 2;
        int paddedMinZ = minZ - 2;
        int paddedMaxX = maxX + 2;
        int paddedMaxZ = maxZ + 2;
        try {
            columns = this.columns.take();
        }
        catch (InterruptedException ignored) {
            return null;
        }
        BlockSegmentList[] lists = new BlockSegmentList[4624];
        int minY = this.generatorParams.minY;
        int maxY = this.generatorParams.maxY;
        Layer layer = (Layer)this.generatorParams.layer.comp_349();
        ScriptedColumn.Params params = new ScriptedColumn.Params(this.generatorParams.columnSeed, 0, 0, minY, maxY, ScriptedColumn.ColumnUsage.RAW_GENERATION.builtinLodHints(0), this.generatorParams.compiledWorldTraits);
        if (request.loadMode.canLoad() && this.chunkCache != null && this.maxLoadLevel > 0) {
            int chunkMinX = paddedMinX >> 4;
            int chunkMinZ = paddedMinZ >> 4;
            int chunkMaxX = (paddedMaxX - 1 >> 4) + 1;
            int chunkMaxZ = (paddedMaxZ - 1 >> 4) + 1;
            LightweightChunk[] chunks = this.chunkCache.getChunks(new class_1923(chunkMinX, chunkMinZ), new class_1923(chunkMaxX, chunkMaxZ));
            if (LodGenerator.anyNonNulls(chunks)) {
                for (int dstZ = paddedMinZ; dstZ < paddedMaxZ; ++dstZ) {
                    for (int dstX = paddedMinX; dstX < paddedMaxX; ++dstX) {
                        int chunkZ = (dstZ >> 4) - chunkMinZ;
                        int chunkX = (dstX >> 4) - chunkMinX;
                        int chunkIndex = chunkZ * (chunkMaxX - chunkMinX) + chunkX;
                        LightweightChunk chunk = chunks[chunkIndex];
                        if (chunk == null) continue;
                        int listIndex = (dstZ - paddedMinZ) * 68 + (dstX - paddedMinX);
                        lists[listIndex] = chunk.getColumn(dstX, dstZ, 0);
                    }
                }
            } else if (!request.loadMode.canGenerate()) {
                this.columns.add(columns);
                return null;
            }
        }
        try (AsyncRunner async = BigGlobeThreadPool.lodRunner();){
            for (int quadZ = paddedMinZ; quadZ < paddedMaxZ; quadZ += 2) {
                for (int quadX = paddedMinX; quadX < paddedMaxX; quadX += 2) {
                    int baseIndex = (quadZ - paddedMinZ) * 68 + (quadX - paddedMinX);
                    QuadHolder.QuadColumn quadColumn = new QuadHolder.QuadColumn();
                    quadColumn.loadFromArray(columns, baseIndex, 68);
                    quadColumn.at(params, quadX, quadZ, 1);
                    QuadHolder.QuadList quadList = new QuadHolder.QuadList();
                    quadList.loadFromArray(lists, baseIndex, 68);
                    if (!quadList.anyNull()) continue;
                    async.submit(() -> {
                        quadList.createNew(minY, maxY);
                        QuadHolder.generate(quadColumn, quadList, layer);
                        quadList.computeLightLevels(this.topSkyLight);
                        quadList.storeInArray(lists, baseIndex, 68);
                    });
                }
            }
        }
        return new ColumnResults(columns, columns, lists);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public ColumnResults generateLodNColumns(LodRequest request) {
        ScriptedColumn[] columns;
        int lod = request.owner.level;
        final int blockLod = lod - 6;
        final int innerStep = 1 << blockLod;
        int innerQuadSize = innerStep << 1;
        final int outerStep = innerStep >> 1;
        int outerQuadSize = innerQuadSize >> 1;
        final int minX = request.owner.minX();
        final int minZ = request.owner.minZ();
        int maxX = request.owner.maxX();
        int maxZ = request.owner.maxZ();
        try {
            columns = this.columns.take();
        }
        catch (InterruptedException ignored) {
            return null;
        }
        final BlockSegmentList[] lists = new BlockSegmentList[4624];
        final ScriptedColumn[] worldColumns = new ScriptedColumn[4624];
        final int minY = this.generatorParams.minY;
        final int maxY = this.generatorParams.maxY;
        final Layer layer = (Layer)this.generatorParams.layer.comp_349();
        final ScriptedColumn.Params params = new ScriptedColumn.Params(this.generatorParams.columnSeed, 0, 0, this.generatorParams.minY, this.generatorParams.maxY, ScriptedColumn.ColumnUsage.RAW_GENERATION.builtinLodHints(blockLod), this.generatorParams.compiledWorldTraits);
        final int paddedMinX = minX - outerStep * 4;
        final int paddedMinZ = minZ - outerStep * 4;
        int paddedMaxX = maxX + outerStep * 4;
        int paddedMaxZ = maxZ + outerStep * 4;
        try (final AsyncRunner async = BigGlobeThreadPool.lodRunner();){
            class NonLoadingHelper
            extends 1BaseHelper {
                final /* synthetic */ LodGenerator this$0;

                NonLoadingHelper() {
                    this.this$0 = this$0;
                    abstract class BaseHelper {
                        final /* synthetic */ AsyncRunner val$async;
                        final /* synthetic */ int val$minY;
                        final /* synthetic */ int val$maxY;
                        final /* synthetic */ Layer val$layer;
                        final /* synthetic */ int val$blockLod;
                        final /* synthetic */ BlockSegmentList[] val$lists;
                        final /* synthetic */ ScriptedColumn[] val$columns;
                        final /* synthetic */ ScriptedColumn.Params val$params;
                        final /* synthetic */ int val$innerStep;
                        final /* synthetic */ ScriptedColumn[] val$worldColumns;
                        final /* synthetic */ int val$outerStep;
                        final /* synthetic */ int val$paddedMinX;
                        final /* synthetic */ int val$paddedMinZ;
                        final /* synthetic */ int val$minX;
                        final /* synthetic */ int val$minZ;
                        final /* synthetic */ LodGenerator this$0;

                        BaseHelper() {
                            this.val$async = val$async;
                            this.val$minY = val$minY;
                            this.val$maxY = val$maxY;
                            this.val$layer = val$layer;
                            this.val$blockLod = val$blockLod;
                            this.val$lists = val$lists;
                            this.val$columns = val$columns;
                            this.val$params = val$params;
                            this.val$innerStep = val$innerStep;
                            this.val$worldColumns = val$worldColumns;
                            this.val$outerStep = val$outerStep;
                            this.val$paddedMinX = val$paddedMinX;
                            this.val$paddedMinZ = val$paddedMinZ;
                            this.val$minX = val$minX;
                            this.val$minZ = val$minZ;
                            this.this$0 = this$0;
                        }

                        public abstract void addCenter(int var1, int var2);

                        public void generateCenter(QuadHolder.QuadColumn quadColumn, int listIndex) {
                            this.val$async.submit(() -> {
                                QuadHolder.QuadList quadList = new QuadHolder.QuadList();
                                quadList.createNew(this.val$minY, this.val$maxY);
                                QuadHolder.generate(quadColumn, quadList, this.val$layer);
                                quadList.downscale(this.val$blockLod);
                                quadList.computeLightLevels(this.this$0.topSkyLight);
                                quadList.storeInArray(this.val$lists, listIndex, 68);
                            });
                        }

                        public QuadHolder.QuadColumn transferCenterColumns(int quadX, int quadZ, int columnIndex, int listIndex) {
                            QuadHolder.QuadColumn quadColumn = new QuadHolder.QuadColumn();
                            quadColumn.loadFromArray(this.val$columns, columnIndex, 64);
                            quadColumn.at(this.val$params, quadX, quadZ, this.val$innerStep);
                            quadColumn.storeInArray(this.val$worldColumns, listIndex, 68);
                            return quadColumn;
                        }

                        public abstract void addEdge(int var1, int var2, int var3);

                        public void generateEdge(QuadHolder.QuadColumn quadColumn, int listIndex) {
                            this.val$async.submit(() -> {
                                QuadHolder.QuadList quadList = new QuadHolder.QuadList();
                                quadList.createNew(this.val$minY, this.val$maxY);
                                QuadHolder.generate(quadColumn, quadList, this.val$layer);
                                BlockSegmentList merged = quadList.merge();
                                merged = QuadHolder.QuadList.downscaleColumnKeepAir(merged, this.val$blockLod);
                                merged.computeLightLevels(this.this$0.topSkyLight);
                                lists[listIndex] = merged;
                            });
                        }

                        public QuadHolder.QuadColumn transferEdgeColumn(int quadX, int quadZ, int columnIndex, int listIndex) {
                            QuadHolder.QuadColumn quadColumn = new QuadHolder.QuadColumn();
                            quadColumn.loadFromArray(this.val$columns, columnIndex, 2);
                            quadColumn.at(this.val$params, quadX, quadZ, this.val$outerStep);
                            this.val$worldColumns[listIndex] = (ScriptedColumn)quadColumn.object00;
                            return quadColumn;
                        }

                        public int columnDestinationIndex(int blockX, int blockZ) {
                            int relativeX = blockX - this.val$paddedMinX >> this.val$blockLod;
                            int relativeZ = blockZ - this.val$paddedMinZ >> this.val$blockLod;
                            return relativeZ * 68 + relativeX;
                        }

                        public int columnSourceIndex(int blockX, int blockZ) {
                            int relativeX = blockX - this.val$minX >> this.val$blockLod;
                            int relativeZ = blockZ - this.val$minZ >> this.val$blockLod;
                            return relativeZ * 64 + relativeX;
                        }
                    }
                    super(this$0, val$async, val$minY, val$maxY, val$layer, val$blockLod, val$lists, val$columns, val$params, val$innerStep, val$worldColumns, val$outerStep, val$paddedMinX, val$paddedMinZ, val$minX, val$minZ);
                }

                @Override
                public void addCenter(int quadX, int quadZ) {
                    int columnIndex = this.columnSourceIndex(quadX, quadZ);
                    int listIndex = this.columnDestinationIndex(quadX, quadZ);
                    QuadHolder.QuadColumn quadColumn = this.transferCenterColumns(quadX, quadZ, columnIndex, listIndex);
                    this.generateCenter(quadColumn, listIndex);
                }

                @Override
                public void addEdge(int quadX, int quadZ, int columnIndex) {
                    int listIndex = this.columnDestinationIndex(quadX, quadZ);
                    QuadHolder.QuadColumn quadColumn = this.transferEdgeColumn(quadX, quadZ, columnIndex, listIndex);
                    this.generateEdge(quadColumn, listIndex);
                }
            }
            void var24_35;
            if (request.loadMode.canLoad() && this.chunkCache != null && this.maxLoadLevel > blockLod) {
                final int chunkMinX = paddedMinX >> 4;
                final int chunkMinZ = paddedMinZ >> 4;
                final int chunkMaxX = (paddedMaxX - 1 >> 4) + 1;
                int chunkMaxZ = (paddedMaxZ - 1 >> 4) + 1;
                final LightweightChunk[] chunks = this.chunkCache.getChunks(new class_1923(chunkMinX, chunkMinZ), new class_1923(chunkMaxX, chunkMaxZ));
                if (LodGenerator.anyNonNulls(chunks)) {
                    class LoadingHelper
                    extends 1BaseHelper {
                        final /* synthetic */ LodGenerator this$0;

                        LoadingHelper() {
                            this.this$0 = this$0;
                            super(this$0, val$async, val$minY, val$maxY, val$layer, val$blockLod, val$lists, val$columns, val$params, val$innerStep, val$worldColumns, val$outerStep, val$paddedMinX, val$paddedMinZ, val$minX, val$minZ);
                        }

                        @Nullable
                        public BlockSegmentList obtainList(int blockX, int blockZ, boolean edge) {
                            int chunkZ = (blockZ >> 4) - chunkMinZ;
                            int chunkX = (blockX >> 4) - chunkMinX;
                            int chunkIndex = chunkZ * (chunkMaxX - chunkMinX) + chunkX;
                            LightweightChunk chunk = chunks[chunkIndex];
                            if (chunk != null) {
                                int lod = blockLod - (edge ? 1 : 0);
                                return chunk.getColumn(blockX >> lod, blockZ >> lod, lod);
                            }
                            return null;
                        }

                        @Nullable
                        public QuadHolder.QuadList getExistingLists(int quadX, int quadZ, boolean edge) {
                            int step = edge ? outerStep : innerStep;
                            BlockSegmentList list00 = this.obtainList(quadX, quadZ, edge);
                            if (list00 == null) {
                                return null;
                            }
                            BlockSegmentList list01 = this.obtainList(quadX + step, quadZ, edge);
                            if (list01 == null) {
                                return null;
                            }
                            BlockSegmentList list10 = this.obtainList(quadX, quadZ + step, edge);
                            if (list10 == null) {
                                return null;
                            }
                            BlockSegmentList list11 = this.obtainList(quadX + step, quadZ + step, edge);
                            if (list11 == null) {
                                return null;
                            }
                            return new QuadHolder.QuadList(list00, list01, list10, list11);
                        }

                        @Override
                        public void addCenter(int quadX, int quadZ) {
                            int columnIndex = this.columnSourceIndex(quadX, quadZ);
                            int listIndex = this.columnDestinationIndex(quadX, quadZ);
                            QuadHolder.QuadColumn quadColumn = this.transferCenterColumns(quadX, quadZ, columnIndex, listIndex);
                            QuadHolder.QuadList existing = this.getExistingLists(quadX, quadZ, false);
                            if (existing != null) {
                                existing.storeInArray(lists, listIndex, 68);
                            } else {
                                this.generateCenter(quadColumn, listIndex);
                            }
                        }

                        @Override
                        public void addEdge(int quadX, int quadZ, int columnIndex) {
                            int listIndex = this.columnDestinationIndex(quadX, quadZ);
                            QuadHolder.QuadColumn quadColumn = this.transferEdgeColumn(quadX, quadZ, columnIndex, listIndex);
                            QuadHolder.QuadList existing = this.getExistingLists(quadX, quadZ, true);
                            if (existing != null) {
                                lists[listIndex] = QuadHolder.QuadList.downscaleColumnKeepAir(existing.merge(), 1);
                            } else {
                                this.generateEdge(quadColumn, listIndex);
                            }
                        }
                    }
                    LoadingHelper loadingHelper = new LoadingHelper();
                } else {
                    if (!request.loadMode.canGenerate()) {
                        this.columns.add(columns);
                        ColumnResults columnResults = null;
                        return columnResults;
                    }
                    NonLoadingHelper nonLoadingHelper = new NonLoadingHelper();
                }
            } else {
                NonLoadingHelper nonLoadingHelper = new NonLoadingHelper();
            }
            for (int dstZ = minZ; dstZ < maxZ; dstZ += innerQuadSize) {
                for (int dstX = minX; dstX < maxX; dstX += innerQuadSize) {
                    var24_35.addCenter(dstX, dstZ);
                }
            }
            int columnIndex = 4096;
            for (int quadX = paddedMinX; quadX < paddedMaxX; quadX += outerQuadSize) {
                int quadZ;
                for (quadZ = paddedMinZ; quadZ < minZ; columnIndex += 4, quadZ += outerQuadSize) {
                    var24_35.addEdge(quadX, quadZ, columnIndex);
                }
                for (quadZ = maxZ; quadZ < paddedMaxZ; columnIndex += 4, quadZ += outerQuadSize) {
                    var24_35.addEdge(quadX, quadZ, columnIndex);
                }
            }
            int quadZ = minZ;
            while (quadZ < maxZ) {
                int quadX;
                for (quadX = paddedMinX; quadX < minX; columnIndex += 4, quadX += outerQuadSize) {
                    var24_35.addEdge(quadX, quadZ, columnIndex);
                }
                for (quadX = maxX; quadX < paddedMaxX; columnIndex += 4, quadX += outerQuadSize) {
                    var24_35.addEdge(quadX, quadZ, columnIndex);
                }
                quadZ += outerQuadSize;
            }
            return new ColumnResults(columns, worldColumns, lists);
        }
    }

    public static boolean quickCheckRender(class_2680 self, class_2680 other) {
        if (BlockStateVersions.isOpaqueFullCube(other, (class_1922)class_2682.field_12294, class_2338.field_10980)) {
            return false;
        }
        class_3610 fluid = self.method_26227();
        return fluid.method_15759() != self || other.method_26227() != fluid;
    }

    public void buildGeometry(LodRequest request, ColumnResults results, VersionedVertexConsumerProvider provider) {
        class_776 blockRenderManager = class_310.method_1551().method_1541();
        class_778 renderer = blockRenderManager.method_3350();
        BlockSegmentList[] lists = results.lists;
        ColumnBlockView columnBlockView = new ColumnBlockView(this.system.world, lists, request.owner.minX(), request.owner.minZ(), request.owner.level, results.worldColumns, this.generatorParams);
        BlockSegmentList[] adjacents = new BlockSegmentList[4];
        class_2338.class_2339 pos = new class_2338.class_2339();
        class_4587 matrixStack = new class_4587();
        pos.method_33099(0);
        while (pos.method_10260() < 64) {
            pos.method_33097(0);
            while (pos.method_10263() < 64) {
                int baseColumnIndex = (pos.method_10260() + 2) * 68 + (pos.method_10263() + 2);
                BlockSegmentList center = lists[baseColumnIndex];
                adjacents[DirectionVersions.horizontal((class_2350)Directions.POSITIVE_X)] = lists[baseColumnIndex + 1];
                adjacents[DirectionVersions.horizontal((class_2350)Directions.NEGATIVE_X)] = lists[baseColumnIndex - 1];
                adjacents[DirectionVersions.horizontal((class_2350)Directions.POSITIVE_Z)] = lists[baseColumnIndex + 68];
                adjacents[DirectionVersions.horizontal((class_2350)Directions.NEGATIVE_Z)] = lists[baseColumnIndex - 68];
                int centerSize = center.size();
                for (int centerIndex = 0; centerIndex < centerSize; ++centerIndex) {
                    if (center.size() != centerSize) {
                        throw new ConcurrentModificationException();
                    }
                    BlockSegmentList.LitSegment centerSegment = (BlockSegmentList.LitSegment)center.get(centerIndex);
                    if (((class_2680)centerSegment.value).method_26215()) continue;
                    pos.method_33098(centerSegment.minY);
                    while (pos.method_10264() <= centerSegment.maxY) {
                        int nextY;
                        boolean shouldRender;
                        int y = pos.method_10264();
                        if (y == centerSegment.minY && centerIndex - 1 >= 0 && LodGenerator.quickCheckRender((class_2680)centerSegment.value, (class_2680)((BlockSegmentList.LitSegment)center.get((int)(centerIndex - 1))).value)) {
                            shouldRender = true;
                            nextY = y + 1;
                        } else if (y == centerSegment.maxY && centerIndex + 1 < centerSize && LodGenerator.quickCheckRender((class_2680)centerSegment.value, (class_2680)((BlockSegmentList.LitSegment)center.get((int)(centerIndex + 1))).value)) {
                            shouldRender = true;
                            nextY = y + 1;
                        } else {
                            shouldRender = false;
                            int skipTo = centerSegment.maxY;
                            for (class_2350 direction : Directions.HORIZONTAL) {
                                BlockSegmentList adjacent = adjacents[DirectionVersions.horizontal(direction)];
                                BlockSegmentList.LitSegment adjacentSegment = (BlockSegmentList.LitSegment)adjacent.getOverlappingSegment(y);
                                if (adjacentSegment == null || LodGenerator.quickCheckRender((class_2680)centerSegment.value, (class_2680)adjacentSegment.value)) {
                                    shouldRender = true;
                                    skipTo = y + 1;
                                    break;
                                }
                                skipTo = Math.min(skipTo, adjacentSegment.maxY + 1);
                            }
                            nextY = Math.max(skipTo, y + 1);
                        }
                        if (shouldRender) {
                            matrixStack.method_22903();
                            matrixStack.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
                            renderer.method_3374((class_1920)columnBlockView, blockRenderManager.method_3349((class_2680)centerSegment.value), (class_2680)centerSegment.value, (class_2338)pos, matrixStack, provider.getBuffer(class_4696.method_23679((class_2680)((class_2680)centerSegment.value))), true, class_5819.method_43047(), ((class_2680)centerSegment.value).method_26190((class_2338)pos), class_4608.field_21444);
                            class_3610 fluidState = ((class_2680)centerSegment.value).method_26227();
                            if (!fluidState.method_15769()) {
                                FluidRenderHandler fabricHandler = FluidRenderHandlerRegistry.INSTANCE.get(fluidState.method_15772());
                                if (fabricHandler != null) {
                                    fabricHandler.renderFluid((class_2338)pos, (class_1920)columnBlockView, provider.getBuffer(class_4696.method_23680((class_3610)fluidState)), (class_2680)centerSegment.value, fluidState);
                                } else {
                                    blockRenderManager.method_3352((class_2338)pos, (class_1920)columnBlockView, provider.getBuffer(class_4696.method_23680((class_3610)fluidState)), (class_2680)centerSegment.value, fluidState);
                                }
                            }
                            matrixStack.method_22909();
                        }
                        pos.method_33098(nextY);
                    }
                }
                pos.method_33097(pos.method_10263() + 1);
            }
            pos.method_33099(pos.method_10260() + 1);
        }
    }

    public record LodRequest(LodSystem system, LodQuadTree owner, LoadMode loadMode, VersionedVertexConsumerProvider provider) implements SafeCloseable
    {
        @Override
        public void close() {
            this.system.renderer.endMeshing(this.provider);
        }
    }

    public static enum LoadMode {
        GENERATE_ONLY,
        LOAD_OR_GENERATE,
        LOAD_ONLY;


        public boolean canLoad() {
            return this != GENERATE_ONLY;
        }

        public boolean canGenerate() {
            return this != LOAD_ONLY;
        }
    }

    public record LodSupply(LodRequest request, boolean success) implements SafeCloseable
    {
        public void apply(LodRenderer.MeshUploader uploader, int maxLoadLevel) {
            LodQuadTree owner = this.request.owner;
            try {
                if (owner.isQueued()) {
                    if (this.success) {
                        if (owner.passes != null) {
                            owner.passes.close();
                            owner.passes = null;
                        } else if (owner.level - 6 < maxLoadLevel) {
                            owner.rebuildTime = System.currentTimeMillis() + 5000L;
                        }
                        owner.passes = uploader.upload(this.request.provider);
                    }
                    owner.setQueued(false);
                }
            }
            catch (Throwable throwable) {
                if (owner.isQueued()) {
                    owner.setQueued(false);
                }
                throw AutoCodecUtil.rethrow((Throwable)throwable);
            }
            finally {
                this.close();
            }
        }

        @Override
        public void close() {
            this.request.close();
        }
    }

    public record ColumnResults(ScriptedColumn[] recyclableColumns, ScriptedColumn[] worldColumns, BlockSegmentList[] lists) {
    }

    @Environment(value=EnvType.CLIENT)
    public static class ColumnBlockView
    implements class_1920 {
        public final ClientState.ClientGeneratorParams generator;
        public final class_638 delegate;
        public final BlockSegmentList[] lists;
        public final int minX;
        public final int minZ;
        public final int lod;
        public final ScriptedColumn[] columns;
        public final class_2338.class_2339 colorGetter;
        public class_6880<class_1959> plainsBiome;
        public class_3568 lightingProvider;

        public ColumnBlockView(class_638 delegate, BlockSegmentList[] lists, int minX, int minZ, int lod, ScriptedColumn[] columns, ClientState.ClientGeneratorParams generator) {
            this.delegate = delegate;
            this.generator = generator;
            this.lists = lists;
            this.minX = minX;
            this.minZ = minZ;
            this.lod = lod;
            this.columns = columns;
            this.colorGetter = new class_2338.class_2339();
        }

        public ScriptedColumn getColumn(class_2338 pos) {
            int x = Objects.checkIndex(pos.method_10263() + 2, 68);
            int z = Objects.checkIndex(pos.method_10260() + 2, 68);
            return Objects.requireNonNull(this.columns[z * 68 + x]);
        }

        public float method_24852(class_2350 direction, boolean shaded) {
            return this.delegate.method_24852(direction, shaded);
        }

        public class_3568 method_22336() {
            class_3568 provider = this.lightingProvider;
            if (provider == null) {
                provider = this.lightingProvider = new class_3568((class_2823)this.delegate.method_2935(), false, false);
            }
            return provider;
        }

        public int method_23752(class_2338 pos, class_6539 colorResolver) {
            int y = pos.method_10264() << this.lod - 6;
            ScriptedColumn column = this.getColumn(pos);
            if (colorResolver == class_1163.field_5665) {
                if (this.generator.grassColor != null) {
                    return this.generator.grassColor.getColor(column, y);
                }
            } else if (colorResolver == class_1163.field_5664) {
                if (this.generator.foliageColor != null) {
                    return this.generator.foliageColor.getColor(column, y);
                }
            } else if (colorResolver == class_1163.field_5666 && this.generator.waterColor != null) {
                return this.generator.waterColor.getColor(column, y);
            }
            if (this.plainsBiome == null) {
                this.plainsBiome = RegistryVersions.getEntry(this.delegate.method_30349(), class_1972.field_9451);
            }
            return colorResolver.getColor((class_1959)this.plainsBiome.comp_349(), (double)column.x(), (double)column.z());
        }

        @Nullable
        public class_2586 method_8321(class_2338 pos) {
            return null;
        }

        public class_2680 method_8320(class_2338 pos) {
            int x = pos.method_10263() + 2;
            if (x < 0 || x >= 68) {
                return BlockStates.AIR;
            }
            int z = pos.method_10260() + 2;
            if (z < 0 || z >= 68) {
                return BlockStates.AIR;
            }
            class_2680 state = this.lists[z * 68 + x].getBlockState(pos.method_10264());
            return state != null ? state : class_2246.field_10124.method_9564();
        }

        public class_3610 method_8316(class_2338 pos) {
            return this.method_8320(pos).method_26227();
        }

        public int method_31605() {
            return this.lists[0].maxY() - this.lists[0].minY();
        }

        public int method_31607() {
            return this.lists[0].minY();
        }

        public int method_31600() {
            return this.lists[0].maxY();
        }

        public int method_8314(class_1944 type, class_2338 pos) {
            int n;
            int x = pos.method_10263() + 2;
            if (x < 0 || x >= 68) {
                return 15;
            }
            int z = pos.method_10260() + 2;
            if (z < 0 || z >= 68) {
                return 15;
            }
            BlockSegmentList.LitSegment segment = (BlockSegmentList.LitSegment)this.lists[z * 68 + x].getOverlappingSegment(pos.method_10264());
            if (segment == null) {
                n = 15;
            } else {
                switch (type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case field_9282: {
                        n = segment.getBlockLight();
                        break;
                    }
                    case field_9284: {
                        n = segment.getLightLevel(pos.method_10264(), this.lod - 6);
                    }
                }
            }
            return n;
        }
    }
}

