/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.rendering.lods;

import builderb0y.autocodec.util.AutoCodecUtil;
import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.ClientState;
import builderb0y.bigglobe.config.BigGlobeConfig;
import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.math.FastMath;
import builderb0y.bigglobe.mixinInterfaces.LodSystemHolder;
import builderb0y.bigglobe.rendering.GLException;
import builderb0y.bigglobe.rendering.OutOfVramException;
import builderb0y.bigglobe.rendering.ResourceTracker;
import builderb0y.bigglobe.rendering.lods.LodChunkCache;
import builderb0y.bigglobe.rendering.lods.LodFrustum;
import builderb0y.bigglobe.rendering.lods.LodGenerator;
import builderb0y.bigglobe.rendering.lods.LodQuadTree;
import builderb0y.bigglobe.rendering.lods.LodRenderer;
import builderb0y.bigglobe.util.SafeCloseable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class LodSystem
implements SafeCloseable {
    public class_638 world;
    public LodGenerator generator;
    public LodQuadTree tree;
    public LodRenderer renderer;
    public LodRenderer.LodRenderState renderState;
    public double currentQuality;
    public double qualityLimit;
    public double loadDistance;
    public int levelLimit = LodQuadTree.MAX_LEVEL;
    public boolean renderingThisFrame;
    public static final int NONE = 0;
    public static final int SOME = 1;
    public static final int ALL = 2;

    public static void init() {
    }

    @Override
    public void close() {
        ResourceTracker.closeAll(this.generator, this.tree, this.renderer);
    }

    public LodSystem(class_638 world, ClientState.ClientGeneratorParams generator) {
        String message = GLException.checkMessage();
        if (message != null) {
            BigGlobeMod.LOGGER.warn("A GL exception occurred just before LOD system initialization: " + message);
        }
        try {
            this.world = world;
            this.qualityLimit = BigGlobeConfig.INSTANCE.get().lodRendering.quality;
            this.renderer = BigGlobeConfig.INSTANCE.get().lodRendering.createRendererBackend();
            this.generator = new LodGenerator(this, generator);
            this.tree = new LodQuadTree(-(1 << LodQuadTree.MAX_LEVEL - 1), -(1 << LodQuadTree.MAX_LEVEL - 1), LodQuadTree.MAX_LEVEL);
            this.renderState = new LodRenderer.LodRenderState();
            GLException.check();
            this.generator.start();
        }
        catch (Throwable throwable) {
            this.close();
            throw AutoCodecUtil.rethrow((Throwable)throwable);
        }
    }

    public static void reload(LodSystemHolder holder, class_638 world) {
        ClientState state = ClientState.get((class_1922)world);
        LodSystem.reload(holder, world, state != null ? state.generatorParams : null);
    }

    public static void reload(LodSystemHolder holder, class_638 world, ClientState.ClientGeneratorParams params) {
        LodSystem system = holder.bigglobe_getLodSystem();
        if (system != null) {
            system.close();
            holder.bigglobe_setLodSystem(null);
        }
        if (world != null && params != null && params.layer != null && BigGlobeConfig.INSTANCE.get().lodRendering.renderingEnabled()) {
            try {
                holder.bigglobe_setLodSystem(new LodSystem(world, params));
            }
            catch (Exception exception) {
                BigGlobeMod.LOGGER.error("Failed to setup LOD renderer:", (Throwable)exception);
            }
        }
    }

    public static int countTotalNodes(LodQuadTree root) {
        return root == null ? 0 : LodSystem.countTotalNodes(root.x0z0) + LodSystem.countTotalNodes(root.x1z0) + LodSystem.countTotalNodes(root.x0z1) + LodSystem.countTotalNodes(root.x1z1) + 1;
    }

    public static int countRenderingNodes(LodQuadTree root) {
        if (root != null) {
            if (root.canRender()) {
                return 1;
            }
            if (root.isTraversableForRender()) {
                return LodSystem.countRenderingNodes(root.x0z0) + LodSystem.countRenderingNodes(root.x0z1) + LodSystem.countRenderingNodes(root.x1z0) + LodSystem.countRenderingNodes(root.x1z1);
            }
        }
        return 0;
    }

    public static int countMeshes(LodQuadTree root) {
        return root == null ? 0 : (root.passes != null ? 1 : 0) + LodSystem.countMeshes(root.x0z0) + LodSystem.countMeshes(root.x0z1) + LodSystem.countMeshes(root.x1z0) + LodSystem.countMeshes(root.x1z1);
    }

    public static int countDirty(LodQuadTree root) {
        return root == null ? 0 : (root.rebuildTime != Long.MAX_VALUE ? 1 : 0) + LodSystem.countDirty(root.x0z0) + LodSystem.countDirty(root.x0z1) + LodSystem.countDirty(root.x1z0) + LodSystem.countDirty(root.x1z1);
    }

    public void oom() {
        this.currentQuality = Math.min(this.currentQuality, this.qualityLimit -= 0.5);
        class_746 player = class_310.method_1551().field_1724;
        class_5250 text = class_2561.method_43469((String)"bigglobe.lod.oom", (Object[])new Object[]{this.qualityLimit});
        if (player != null) {
            player.method_7353((class_2561)text, false);
        } else {
            BigGlobeMod.LOGGER.warn(text.getString());
        }
        this.makeRequests(this.tree, System.currentTimeMillis(), false);
        this.renderer.oom();
    }

    public boolean canRender() {
        return this.renderingThisFrame;
    }

    public void draw() {
        String existingMessage = GLException.checkMessage();
        if (existingMessage != null) {
            BigGlobeMod.LOGGER.warn("Caught GL exception from some other unknown mod right before LOD rendering: " + existingMessage);
        }
        try {
            this.doDraw();
        }
        catch (RuntimeException exception) {
            BigGlobeMod.LOGGER.error("An exception occurred while rendering LODs. LOD rendering will now disable itself to prevent further problems. You can press F3+A to attempt to restart it.", (Throwable)exception);
            this.close();
            this.renderState.lodSystemHolder.bigglobe_setLodSystem(null);
        }
    }

    public void doDraw() {
        if (!this.generator.running) {
            BigGlobeMod.LOGGER.error("LOD system shutting down due to exception in mesh generator thread. Press F3+A to restart it.");
            this.close();
            this.renderState.lodSystemHolder.bigglobe_setLodSystem(null);
            return;
        }
        GLException failure = null;
        class_3695 profiler = this.renderState.profiler;
        profiler.method_15396("BG LODs");
        LodChunkCache cache = this.generator.chunkCache;
        if (cache != null) {
            profiler.method_15396("Process Dirty Chunks");
            cache.processDirtyChunks(this);
            profiler.method_15407();
        }
        if (this.generator.hasSupply()) {
            profiler.method_15396("Process Supply");
            try {
                try (LodRenderer.MeshUploader uploader = this.renderer.finishMeshing();){
                    LodGenerator.LodSupply supply;
                    while ((supply = this.generator.getSupply()) != null) {
                        supply.apply(uploader, this.generator.maxLoadLevel);
                    }
                }
                GLException.check();
            }
            catch (OutOfVramException exception) {
                this.oom();
            }
            catch (GLException exception) {
                failure = exception;
            }
            profiler.method_15407();
        } else if (this.generator.requests.isEmpty() && this.tree.passes != null) {
            if (this.levelLimit > 6) {
                --this.levelLimit;
            } else {
                this.currentQuality = Math.min(this.currentQuality + 0.0625, this.qualityLimit);
                if (this.currentQuality == this.qualityLimit) {
                    this.loadDistance = Math.min(this.loadDistance + 16.0, (double)this.renderState.frustum.generationBuffer);
                }
            }
        }
        if (failure == null && this.canRender()) {
            if (this.tree.passes != null) {
                SafeCloseable $;
                profiler.method_15405("Request");
                this.makeRequests(this.tree, System.currentTimeMillis(), true);
                profiler.method_15405("Visibility");
                this.computeVisibility(this.tree, null);
                profiler.method_15405("Opaque");
                try {
                    $ = this.renderer.bind(this.renderState, false);
                    try {
                        GLException.check();
                        this.drawTree(this.tree);
                        GLException.check();
                    }
                    finally {
                        if ($ != null) {
                            $.close();
                        }
                    }
                }
                catch (GLException exception) {
                    failure = exception;
                }
                profiler.method_15405("Translucent");
                try {
                    $ = this.renderer.bind(this.renderState, true);
                    try {
                        GLException.check();
                        if (failure == null) {
                            this.drawTree(this.tree);
                            GLException.check();
                        }
                    }
                    finally {
                        if ($ != null) {
                            $.close();
                        }
                    }
                }
                catch (GLException exception) {
                    if (failure == null) {
                        failure = exception;
                    }
                    failure.addSuppressed(exception);
                }
                profiler.method_15407();
            } else if (!this.tree.isQueued()) {
                this.generator.request(this.tree, LodGenerator.LoadMode.GENERATE_ONLY);
                this.tree.split();
            }
        }
        profiler.method_15407();
        if (failure != null) {
            BigGlobeMod.LOGGER.error("LOD rendering encountered an unexpected exception and will now stop. Press F3+A to restart it.", (Throwable)failure);
            this.close();
            this.renderState.lodSystemHolder.bigglobe_setLodSystem(null);
        }
    }

    public int computeVisibility(LodQuadTree tree, Boolean frustumStatus) {
        int x0z0;
        if (frustumStatus == null) {
            frustumStatus = this.renderState.frustum.test(tree.minX(), this.generator.generatorParams.minY, tree.minZ(), tree.maxX(), this.generator.generatorParams.maxY, tree.maxZ());
        }
        int x1z1 = tree.x1z1 != null ? this.computeVisibility(tree.x1z1, frustumStatus) : 0;
        int x0z1 = tree.x0z1 != null ? this.computeVisibility(tree.x0z1, frustumStatus) : 0;
        int x1z0 = tree.x1z0 != null ? this.computeVisibility(tree.x1z0, frustumStatus) : 0;
        int n = x0z0 = tree.x0z0 != null ? this.computeVisibility(tree.x0z0, frustumStatus) : 0;
        int childrenState = x0z0 == 0 && x1z0 == 0 && x0z1 == 0 && x1z1 == 0 ? 0 : (x0z0 == 2 && x1z0 == 2 && x0z1 == 2 && x1z1 == 2 ? 2 : 1);
        tree.setTraversableForRender(childrenState != 0 && frustumStatus != Boolean.FALSE);
        tree.setCanRender(childrenState != 2 && tree.passes != null && frustumStatus != Boolean.FALSE);
        return tree.passes != null || !tree.isInRange() ? 2 : childrenState;
    }

    public void drawTree(LodQuadTree tree) {
        if (tree.canRender()) {
            assert (tree.passes != null) : "renderable tree has no passes";
            LodFrustum frustum = this.renderState.frustum;
            this.renderer.draw(tree.passes, (float)((double)tree.minX() - frustum.x), (float)(-frustum.y), (float)((double)tree.minZ() - frustum.z), 1 << tree.level - 6);
        } else if (tree.isTraversableForRender()) {
            assert (tree.x0z0 != null && tree.x0z1 != null && tree.x1z0 != null && tree.x1z1 != null) : "tree with missing children is traversable";
            this.drawTree(tree.x0z0);
            this.drawTree(tree.x0z1);
            this.drawTree(tree.x1z0);
            this.drawTree(tree.x1z1);
        }
    }

    public void makeRequests(LodQuadTree tree, long time, boolean canSplit) {
        double squareDistance = this.squareDistanceTo(tree);
        tree.setInRange(squareDistance < BigGlobeMath.squareD(this.renderState.frustum.farClippingPlane));
        double idealQuality = this.computeIdealQuality(squareDistance, tree);
        if (idealQuality > this.currentQuality + 0.5) {
            tree.merge();
            return;
        }
        if (!tree.isQueued() && canSplit) {
            if (tree.level > this.levelLimit && idealQuality < this.currentQuality) {
                tree.split();
            }
            boolean request = false;
            LodGenerator.LoadMode loadMode = null;
            if (tree.passes == null && squareDistance < BigGlobeMath.squareD(this.renderState.frustum.generationBuffer)) {
                request = true;
                LodGenerator.LoadMode loadMode2 = loadMode = squareDistance < BigGlobeMath.squareD(this.loadDistance) ? LodGenerator.LoadMode.LOAD_OR_GENERATE : LodGenerator.LoadMode.GENERATE_ONLY;
            }
            if (time > tree.rebuildTime && squareDistance < BigGlobeMath.squareD(this.loadDistance)) {
                request = true;
                LodGenerator.LoadMode loadMode3 = loadMode = tree.passes == null ? LodGenerator.LoadMode.LOAD_OR_GENERATE : LodGenerator.LoadMode.LOAD_ONLY;
            }
            if (request) {
                this.generator.request(tree, loadMode);
            }
        }
        if (tree.level > 6) {
            if (tree.x0z0 != null) {
                this.makeRequests(tree.x1z1, time, canSplit);
            }
            if (tree.x0z1 != null) {
                this.makeRequests(tree.x0z1, time, canSplit);
            }
            if (tree.x1z0 != null) {
                this.makeRequests(tree.x1z0, time, canSplit);
            }
            if (tree.x1z1 != null) {
                this.makeRequests(tree.x0z0, time, canSplit);
            }
        }
    }

    public double squareDistanceTo(LodQuadTree tree) {
        LodFrustum frustum = this.renderState.frustum;
        double closestX = class_3532.method_15350((double)frustum.x, (double)tree.minX(), (double)tree.maxX());
        double closestY = class_3532.method_15350((double)frustum.y, (double)this.generator.generatorParams.minY, (double)this.generator.generatorParams.maxY);
        double closestZ = class_3532.method_15350((double)frustum.z, (double)tree.minZ(), (double)tree.maxZ());
        return BigGlobeMath.squareD(closestX - frustum.x, closestY - frustum.y, closestZ - frustum.z);
    }

    public double computeIdealQuality(double squareDistance, LodQuadTree tree) {
        return FastMath.Log.fastLog2(squareDistance) * 0.5 - (double)tree.level;
    }

    public void invalidateChunkLater(class_1923 chunkPos) {
        LodChunkCache cache = this.generator.chunkCache;
        if (cache != null) {
            cache.invalidateChunkLater(chunkPos);
        }
    }

    public void invalidateChunkNow(class_1923 chunkPos) {
        if (this.tree != null) {
            this.recursiveInvalidateBlock(this.tree, System.currentTimeMillis() + 5000L, chunkPos.field_9181 << 4, chunkPos.field_9180 << 4);
        }
    }

    public void recursiveInvalidateBlock(LodQuadTree tree, long time, int blockX, int blockZ) {
        if (tree.level - 6 < this.generator.maxLoadLevel) {
            tree.rebuildTime = time;
        }
        if (blockZ >= tree.midZ()) {
            if (blockX >= tree.midX()) {
                if (tree.x1z1 != null) {
                    this.recursiveInvalidateBlock(tree.x1z1, time, blockX, blockZ);
                }
            } else if (tree.x0z1 != null) {
                this.recursiveInvalidateBlock(tree.x0z1, time, blockX, blockZ);
            }
        } else if (blockX >= tree.midX()) {
            if (tree.x1z0 != null) {
                this.recursiveInvalidateBlock(tree.x1z0, time, blockX, blockZ);
            }
        } else if (tree.x0z0 != null) {
            this.recursiveInvalidateBlock(tree.x0z0, time, blockX, blockZ);
        }
    }

    static {
        WorldRenderEvents.AFTER_SETUP.register(context -> {
            LodSystem system = LodSystemHolder.of(context.worldRenderer()).bigglobe_getLodSystem();
            if (system != null) {
                system.renderState.setup(context);
                system.renderingThisFrame = !context.worldRenderer().method_43788(context.camera());
                system.draw();
            }
        });
    }
}

