/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.rendering.lods;

import builderb0y.autocodec.util.AutoCodecUtil;
import builderb0y.bigglobe.rendering.GLException;
import builderb0y.bigglobe.rendering.NativeMemory;
import builderb0y.bigglobe.rendering.ResourceTracker;
import builderb0y.bigglobe.rendering.TextureState;
import builderb0y.bigglobe.rendering.lods.AbstractLodRenderer;
import builderb0y.bigglobe.rendering.lods.CombinedLodShader;
import builderb0y.bigglobe.rendering.lods.LodPasses;
import builderb0y.bigglobe.rendering.lods.LodRenderer;
import builderb0y.bigglobe.rendering.lods.LodVertexFormat;
import builderb0y.bigglobe.rendering.lods.SidedLodPasses;
import builderb0y.bigglobe.rendering.lods.TextureBuffer;
import builderb0y.bigglobe.rendering.lods.VersionedVertexConsumerProvider;
import builderb0y.bigglobe.util.SafeCloseable;
import builderb0y.bigglobe.versions.RenderVersions;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import org.lwjgl.opengl.GL32C;

@Environment(value=EnvType.CLIENT)
public class SidedCombinedLodRenderer
extends AbstractLodRenderer {
    public SidedMultiDrawLodState state = new SidedMultiDrawLodState();
    public CombinedLodShader shader;
    public TextureBuffer transformationBuffer;
    public NativeMemory multiDrawStarts;
    public NativeMemory multiDrawSizes;
    public NativeMemory zeros;
    public int drawCount;
    public int transformationTexture;

    @Override
    public void close() {
        if (this.transformationTexture != 0) {
            GL32C.glDeleteTextures((int)this.transformationTexture);
            this.transformationTexture = 0;
        }
        ResourceTracker.closeAll(() -> super.close(), this.shader, this.transformationBuffer, this.multiDrawStarts, this.multiDrawSizes, this.zeros);
    }

    public SidedCombinedLodRenderer(int quadCount) {
        super(quadCount);
        try {
            this.shader = new CombinedLodShader();
            this.transformationBuffer = new TextureBuffer();
            this.transformationTexture = GL32C.glGenTextures();
            this.multiDrawStarts = new NativeMemory();
            this.multiDrawSizes = new NativeMemory();
            this.zeros = new NativeMemory();
            GLException.check();
        }
        catch (Throwable throwable) {
            this.close();
            throw AutoCodecUtil.rethrow((Throwable)throwable);
        }
    }

    @Override
    public SafeCloseable bind(LodRenderer.LodRenderState state, boolean translucent) {
        if (translucent) {
            this.state.inTranslucentPass = true;
            this.state.setBlend(true);
            this.state.setBlendFunc(770, 771, 1, 0);
        } else {
            this.state.capture();
            this.state.setVao(this.vao);
            this.state.setElementBuffer(this.elementBuffer.glID);
            this.setupOpaqueState(this.state);
            this.state.setProgram(this.shader.program);
            this.shader.bindTextures();
            this.setupUniforms(state, this.shader);
        }
        return () -> {
            if (this.drawCount > 0) {
                try (SafeCloseable $ = this.transformationBuffer.bind();){
                    GLException.check();
                    this.transformationBuffer.uploadAndClear();
                    GLException.check();
                    GL32C.glActiveTexture((int)33985);
                    GLException.check();
                    GL32C.glBindTexture((int)35882, (int)this.transformationTexture);
                    GLException.check();
                    GL32C.glTexBuffer((int)35882, (int)34836, (int)this.transformationBuffer.glID);
                    GLException.check();
                    GL32C.nglMultiDrawElementsBaseVertex((int)4, (long)this.multiDrawSizes.address, (int)5125, (long)this.zeros.address, (int)this.drawCount, (long)this.multiDrawStarts.address);
                    GLException.check();
                }
                GLException.check();
                this.multiDrawStarts.clear();
                this.multiDrawSizes.clear();
                this.zeros.clear();
                this.drawCount = 0;
            }
            if (this.state.inTranslucentPass) {
                this.depthBuffer.copyTo(RenderVersions.glID(class_310.method_1551().method_1522()));
                this.state.restore();
            }
        };
    }

    @Override
    public VersionedVertexConsumerProvider beginMeshing() {
        return new SidedLodPasses.Builder(LodVertexFormat.FORMAT, 36992);
    }

    @Override
    public LodRenderer.MeshUploader finishMeshing() {
        final SafeCloseable unbinder = this.heap.bind();
        return new LodRenderer.MeshUploader(){
            final /* synthetic */ SidedCombinedLodRenderer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public SafeCloseable upload(VersionedVertexConsumerProvider provider) {
                SidedLodPasses.Builder builder = (SidedLodPasses.Builder)provider;
                return builder.build(this.this$0.heap);
            }

            @Override
            public void close() {
                unbinder.close();
            }
        };
    }

    @Override
    public void endMeshing(VersionedVertexConsumerProvider provider) {
        SidedLodPasses.Builder builder = (SidedLodPasses.Builder)provider;
        builder.close();
    }

    @Override
    public void draw(SafeCloseable token, float modelOffsetX, float modelOffsetY, float modelOffsetZ, float scale) {
        SidedLodPasses passes = (SidedLodPasses)token;
        SidedLodPasses.Pass pass = passes.getPass(this.state.inTranslucentPass);
        if (pass != null) {
            if (pass.all() != null) {
                this.recordDraw(pass.all(), modelOffsetX, modelOffsetY, modelOffsetZ, scale);
            }
            if (pass.posX() != null && modelOffsetX < 0.0f) {
                this.recordDraw(pass.posX(), modelOffsetX, modelOffsetY, modelOffsetZ, scale);
            }
            if (pass.posZ() != null && modelOffsetZ < 0.0f) {
                this.recordDraw(pass.posZ(), modelOffsetX, modelOffsetY, modelOffsetZ, scale);
            }
            if (pass.negX() != null && modelOffsetX + scale * 64.0f > 0.0f) {
                this.recordDraw(pass.negX(), modelOffsetX, modelOffsetY, modelOffsetZ, scale);
            }
            if (pass.negZ() != null && modelOffsetZ + scale * 64.0f > 0.0f) {
                this.recordDraw(pass.negZ(), modelOffsetX, modelOffsetY, modelOffsetZ, scale);
            }
        }
    }

    public void recordDraw(LodPasses.Geometry geometry, float x, float y, float z, float scale) {
        NativeMemory transformations = this.transformationBuffer.cpuBuffer;
        transformations.appendFloat(x);
        transformations.appendFloat(y);
        transformations.appendFloat(z);
        transformations.appendFloat(scale);
        this.multiDrawStarts.appendInt(geometry.baseVertex());
        this.multiDrawSizes.appendInt(geometry.indexCount());
        this.elementBuffer.ensureCapacity(geometry.indexCount());
        this.zeros.appendLong(0L);
        ++this.drawCount;
    }

    public static class SidedMultiDrawLodState
    extends AbstractLodRenderer.LodGlState {
        public TextureState texture0 = TextureState._2D(33984);
        public TextureState texture1 = TextureState.buffer(33985);
        public TextureState texture2 = TextureState._2D(33986);

        @Override
        public void capture() {
            super.capture();
            this.texture0.capture();
            this.texture1.capture();
            this.texture2.capture();
        }

        @Override
        public void restore() {
            this.texture2.capture();
            this.texture1.capture();
            this.texture0.capture();
            super.restore();
        }
    }
}

