/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.scripting.wrappers;

import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.blocks.BlockStates;
import builderb0y.bigglobe.chunkgen.BigGlobeScriptedChunkGenerator;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.columns.scripted.ScriptedColumnLookup;
import builderb0y.bigglobe.features.SingleBlockFeature;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.overriders.ColumnValueOverrider;
import builderb0y.bigglobe.scripting.wrappers.entries.ConfiguredFeatureEntry;
import builderb0y.bigglobe.structures.ScriptStructures;
import builderb0y.bigglobe.util.SymmetricOffset;
import builderb0y.bigglobe.util.Symmetry;
import builderb0y.bigglobe.util.WorldOrChunk;
import builderb0y.bigglobe.util.coordinators.Coordinator;
import builderb0y.bigglobe.versions.BlockEntityVersions;
import builderb0y.bigglobe.versions.HeightLimitViewVersions;
import builderb0y.bigglobe.versions.IdentifierVersions;
import builderb0y.scripting.bytecode.FieldInfo;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.util.BoundInfoHolder;
import builderb0y.scripting.util.InfoHolder;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.function.Predicate;
import java.util.random.RandomGenerator;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2265;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3341;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5539;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;

public class WorldWrapper
implements ScriptedColumnLookup {
    public static final Info INFO = new Info();
    public static final BoundInfo BOUND_PARAM = new BoundInfo(InsnTrees.load("world", WorldWrapper.INFO.type));
    public final WorldOrChunk world;
    public final Coordination coordination;
    public final class_2338.class_2339 pos;
    public Vector3d doublePos;
    public final RandomGenerator random;
    public long featureSalt = -5337702172222953477L;
    public final ScriptedColumn.Factory columnFactory;
    public final Long2ObjectOpenHashMap<ScriptedColumn> columns;
    public final ScriptedColumn.Params params;
    public AutoOverride overriders;

    public WorldWrapper(WorldOrChunk world, BigGlobeScriptedChunkGenerator chunkGenerator, RandomGenerator random, Coordination coordination, ScriptedColumn.Hints hints) {
        ScriptedColumnLookup scriptedColumnLookup;
        this.world = world;
        this.coordination = coordination;
        this.pos = new class_2338.class_2339();
        this.random = random;
        this.columnFactory = chunkGenerator.columnEntryRegistry.columnFactory;
        if (world instanceof WorldOrChunk.ChunkDelegator) {
            WorldOrChunk.ChunkDelegator delegator = (WorldOrChunk.ChunkDelegator)world;
            delegator.worldWrapper = this;
        }
        if ((scriptedColumnLookup = ScriptedColumnLookup.GLOBAL.getCurrent()) instanceof WorldWrapper) {
            WorldWrapper parent = (WorldWrapper)scriptedColumnLookup;
            this.columns = parent.columns;
            this.overriders = parent.overriders;
            this.params = parent.params;
        } else {
            this.columns = new Long2ObjectOpenHashMap(64);
            this.params = new ScriptedColumn.Params(chunkGenerator.columnSeed, 0, 0, coordination.mutableArea.method_35416(), coordination.mutableArea.method_35419() + 1, hints, chunkGenerator.compiledWorldTraits);
        }
    }

    @Override
    public ScriptedColumn.Hints getHints() {
        return this.params.hints();
    }

    @Override
    public ScriptedColumn lookupColumn(int x, int z) {
        class_2338.class_2339 pos = this.unboundedPos(x, 0, z);
        x = pos.method_10263();
        z = pos.method_10260();
        return (ScriptedColumn)this.columns.computeIfAbsent(class_2265.method_34874((int)x, (int)z), packedPos -> {
            ScriptedColumn column = this.columnFactory.create(this.params.at(class_2265.method_42106((long)packedPos), class_2265.method_42107((long)packedPos)));
            if (this.overriders != null) {
                this.overriders.override(column);
            }
            return column;
        });
    }

    public class_2338.class_2339 unboundedPos(int x, int y, int z) {
        return this.coordination.modifyPosUnbounded(this.pos.method_10103(x, y, z));
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable class_2338.class_2339 mutablePos(int x, int y, int z) {
        return this.coordination.filterPosMutable(this.unboundedPos(x, y, z));
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable class_2338.class_2339 immutablePos(int x, int y, int z) {
        return this.coordination.filterPosImmutable(this.unboundedPos(x, y, z));
    }

    public int transformX(int x, int y, int z) {
        return this.unboundedPos(x, y, z).method_10263();
    }

    public int transformY(int x, int y, int z) {
        return this.unboundedPos(x, y, z).method_10264();
    }

    public int transformZ(int x, int y, int z) {
        return this.unboundedPos(x, y, z).method_10260();
    }

    public Vector3d transform(double x, double y, double z) {
        return this.coordination.modifyVecUnbounded(this.doublePos(x, y, z));
    }

    public double transformX(double x, double y, double z) {
        return this.transform((double)x, (double)y, (double)z).x;
    }

    public double transformY(double x, double y, double z) {
        return this.transform((double)x, (double)y, (double)z).y;
    }

    public double transformZ(double x, double y, double z) {
        return this.transform((double)x, (double)y, (double)z).z;
    }

    public Vector3d doublePos(double x, double y, double z) {
        Vector3d pos = this.doublePos;
        if (pos == null) {
            pos = this.doublePos = new Vector3d();
        }
        return pos.set(x, y, z);
    }

    public int offsetY() {
        return this.coordination.transformation.offsetY();
    }

    public long seed() {
        return this.world.getSeed();
    }

    public ScriptedColumn.Hints hints() {
        return this.params.hints();
    }

    @Deprecated
    public boolean distantHorizons() {
        return this.params.hints().isLod();
    }

    @Deprecated
    public boolean surfaceOnly() {
        return !this.params.hints().fill();
    }

    public class_2680 getBlockState(int x, int y, int z) {
        class_2338.class_2339 pos = this.immutablePos(x, y, z);
        return pos == null ? BlockStates.AIR : this.coordination.unmodifyState(this.world.method_8320((class_2338)pos));
    }

    public boolean setBlockState(int x, int y, int z, class_2680 state) {
        return this.setBlockStateConditional(x, y, z, state, null);
    }

    public boolean setBlockStateReplaceable(int x, int y, int z, class_2680 state) {
        return this.setBlockStateConditional(x, y, z, state, SingleBlockFeature.IS_REPLACEABLE);
    }

    public boolean setBlockStateNonReplaceable(int x, int y, int z, class_2680 state) {
        return this.setBlockStateConditional(x, y, z, state, SingleBlockFeature.NOT_REPLACEABLE);
    }

    public boolean setBlockStateConditional(int x, int y, int z, class_2680 state, Predicate<class_2680> predicate) {
        class_2338.class_2339 pos;
        if (state != null && (pos = this.mutablePos(x, y, z)) != null && (predicate == null || predicate.test(this.world.method_8320((class_2338)pos)))) {
            state = this.coordination.modifyState(state);
            this.world.setBlockState((class_2338)pos, state);
            if (!state.method_26227().method_15769()) {
                this.world.scheduleFluidTick((class_2338)pos, state.method_26227());
            }
            return true;
        }
        return false;
    }

    public boolean placeBlockState(int x, int y, int z, class_2680 state) {
        class_2338.class_2339 pos = this.mutablePos(x, y, z);
        return pos != null && this.world.placeBlockState((class_2338)pos, this.coordination.modifyState(state));
    }

    public boolean updateBlockState(int x, int y, int z) {
        class_2338.class_2339 pos = this.mutablePos(x, y, z);
        if (pos != null) {
            this.world.updateBlockState((class_2338)pos);
            return true;
        }
        return false;
    }

    public void fillBlockState(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2680 state) {
        this.fillBlockStateConditionally(minX, minY, minZ, maxX, maxY, maxZ, state, null);
    }

    public void fillBlockStateReplaceable(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2680 state) {
        this.fillBlockStateConditionally(minX, minY, minZ, maxX, maxY, maxZ, state, SingleBlockFeature.IS_REPLACEABLE);
    }

    public void fillBlockStateNonReplaceable(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2680 state) {
        this.fillBlockStateConditionally(minX, minY, minZ, maxX, maxY, maxZ, state, SingleBlockFeature.NOT_REPLACEABLE);
    }

    public void fillBlockStateConditionally(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2680 state, Predicate<class_2680> predicate) {
        if (state != null) {
            int tmp;
            class_2338.class_2339 pos = this.unboundedPos(minX, minY, minZ);
            minX = pos.method_10263();
            minY = pos.method_10264();
            minZ = pos.method_10260();
            pos = this.unboundedPos(maxX, maxY, maxZ);
            maxX = pos.method_10263();
            maxY = pos.method_10264();
            maxZ = pos.method_10260();
            if (maxX < minX) {
                tmp = minX;
                minX = maxX;
                maxX = tmp;
            }
            if (maxY < minY) {
                tmp = minY;
                minY = maxY;
                maxY = tmp;
            }
            if (maxZ < minZ) {
                tmp = minZ;
                minZ = maxZ;
                maxZ = tmp;
            }
            minX = Math.max(minX, this.coordination.mutableArea.method_35415());
            minY = Math.max(minY, this.coordination.mutableArea.method_35416());
            minZ = Math.max(minZ, this.coordination.mutableArea.method_35417());
            maxX = Math.min(maxX, this.coordination.mutableArea.method_35418());
            maxY = Math.min(maxY, this.coordination.mutableArea.method_35419());
            maxZ = Math.min(maxZ, this.coordination.mutableArea.method_35420());
            state = this.coordination.modifyState(state);
            for (int z = minZ; z <= maxZ; ++z) {
                pos.method_33099(z);
                for (int x = minX; x <= maxX; ++x) {
                    pos.method_33097(x);
                    for (int y = minY; y <= maxY; ++y) {
                        pos.method_33098(y);
                        if (predicate != null && !predicate.test(this.world.method_8320((class_2338)pos))) continue;
                        this.world.setBlockState((class_2338)pos, state);
                        if (state.method_26227().method_15769()) continue;
                        this.world.scheduleFluidTick((class_2338)pos, state.method_26227());
                    }
                }
            }
        }
    }

    public void updateBlockStates(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        int tmp;
        class_2338.class_2339 pos = this.unboundedPos(minX, minY, minZ);
        minX = pos.method_10263();
        minY = pos.method_10264();
        minZ = pos.method_10260();
        pos = this.unboundedPos(maxX, maxY, maxZ);
        maxX = pos.method_10263();
        maxY = pos.method_10264();
        maxZ = pos.method_10260();
        if (maxX < minX) {
            tmp = minX;
            minX = maxX;
            maxX = tmp;
        }
        if (maxY < minY) {
            tmp = minY;
            minY = maxY;
            maxY = tmp;
        }
        if (maxZ < minZ) {
            tmp = minZ;
            minZ = maxZ;
            maxZ = tmp;
        }
        minX = Math.max(minX, this.coordination.mutableArea.method_35415());
        minY = Math.max(minY, this.coordination.mutableArea.method_35416());
        minZ = Math.max(minZ, this.coordination.mutableArea.method_35417());
        maxX = Math.min(maxX, this.coordination.mutableArea.method_35418());
        maxY = Math.min(maxY, this.coordination.mutableArea.method_35419());
        maxZ = Math.min(maxZ, this.coordination.mutableArea.method_35420());
        for (int z = minZ; z <= maxZ; ++z) {
            pos.method_33099(z);
            for (int x = minX; x <= maxX; ++x) {
                pos.method_33097(x);
                for (int y = minY; y <= maxY; ++y) {
                    this.world.updateBlockState((class_2338)pos.method_33098(y));
                }
            }
        }
    }

    public boolean placeFeature(int x, int y, int z, ConfiguredFeatureEntry feature) {
        class_2338.class_2339 pos = this.mutablePos(x, y, z);
        if (pos != null) {
            Permuter permuter = new Permuter(Permuter.permute(this.seed() ^ this.featureSalt, feature.identifier().hashCode(), pos.method_10263(), pos.method_10264(), pos.method_10260()));
            return this.world.placeFeature((class_2338)pos, (class_2975)feature.object(), permuter.mojang());
        }
        return false;
    }

    public class_3492 newStructurePlacementData() {
        return new class_3492().method_15126(this.coordination.mutableArea);
    }

    public void placeStructureTemplate(int x, int y, int z, class_3499 template) {
        this.placeStructureTemplate(x, y, z, template, this.newStructurePlacementData());
    }

    public void placeStructureTemplate(int x, int y, int z, class_3499 template, class_3492 data) {
        data = data.method_15128();
        class_2338.class_2339 pos = this.unboundedPos(x, y, z);
        x = pos.method_10263();
        y = pos.method_10264();
        z = pos.method_10260();
        Symmetry oldSymmetry = Symmetry.of(data.method_15114()).andThen(Symmetry.of(data.method_15113()));
        Symmetry newSymmetry = this.coordination.transformation().symmetry().andThen(oldSymmetry);
        data.method_15125(newSymmetry.isFlipped() ? class_2415.field_11301 : class_2415.field_11302);
        data.method_15123(switch (newSymmetry) {
            default -> throw new IncompatibleClassChangeError();
            case Symmetry.IDENTITY, Symmetry.FLIP_0 -> class_2470.field_11467;
            case Symmetry.ROTATE_90, Symmetry.FLIP_135 -> class_2470.field_11463;
            case Symmetry.ROTATE_180, Symmetry.FLIP_90 -> class_2470.field_11464;
            case Symmetry.ROTATE_270, Symmetry.FLIP_45 -> class_2470.field_11465;
        });
        Permuter permuter = new Permuter(Permuter.permute(this.seed() ^ 0xD6ABF6E7480FDDE0L, x, y, z));
        this.world.placeStructureTemplate(x, y, z, template, data, permuter);
    }

    public boolean isYLevelValid(int y) {
        return !this.world.method_31601(y);
    }

    public boolean isPositionValid(int x, int y, int z) {
        return this.isYLevelValid(y) && this.mutablePos(x, y, z) != null;
    }

    public int minValidYLevel() {
        return this.world.method_31607();
    }

    public int maxValidYLevel() {
        return HeightLimitViewVersions.getMaxY((class_5539)this.world);
    }

    @Nullable
    public class_2487 getBlockData(int x, int y, int z) {
        class_2586 blockEntity;
        class_2338.class_2339 pos = this.immutablePos(x, y, z);
        if (pos != null && (blockEntity = this.world.method_8321((class_2338)pos)) != null) {
            return BlockEntityVersions.writeToNbt(blockEntity);
        }
        return null;
    }

    public void setBlockData(int x, int y, int z, class_2487 nbt) {
        class_2586 blockEntity;
        class_2338.class_2339 pos = this.mutablePos(x, y, z);
        if (pos != null && (blockEntity = this.world.method_8321((class_2338)pos)) != null) {
            BlockEntityVersions.readFromNbt(blockEntity, nbt);
            blockEntity.method_5431();
        }
    }

    public void mergeBlockData(int x, int y, int z, class_2487 nbt) {
        class_2487 newData;
        class_2487 oldData;
        class_2586 blockEntity;
        class_2338.class_2339 pos = this.mutablePos(x, y, z);
        if (pos != null && (blockEntity = this.world.method_8321((class_2338)pos)) != null && !(oldData = BlockEntityVersions.writeToNbt(blockEntity)).equals((Object)(newData = oldData.method_10553().method_10543(nbt)))) {
            BlockEntityVersions.readFromNbt(blockEntity, newData);
            blockEntity.method_5431();
        }
    }

    public void summon(double x, double y, double z, String entityType) {
        Vector3d newPos = this.coordination.filterVecMutable(this.transform(x, y, z));
        if (newPos == null) {
            return;
        }
        double newX = newPos.x;
        double newY = newPos.y;
        double newZ = newPos.z;
        class_2960 identifier = IdentifierVersions.create(entityType);
        if (!class_7923.field_41177.method_10250(identifier)) {
            throw new IllegalArgumentException("Unknown entity type: " + entityType);
        }
        this.world.spawnEntity(serverWorld -> {
            class_1297 entity = ((class_1299)class_7923.field_41177.method_10223(identifier)).method_5883((class_1937)serverWorld);
            if (entity != null) {
                entity.method_5808(newX, newY, newZ, entity.method_36454(), entity.method_36455());
                return entity;
            }
            throw new IllegalArgumentException("Entity type " + entityType + " is not enabled in this world's feature flags.");
        });
    }

    public void summon(double x, double y, double z, String entityType, class_2487 nbt) {
        Vector3d newPos = this.coordination.filterVecMutable(this.transform(x, y, z));
        if (newPos == null) {
            return;
        }
        double newX = newPos.x;
        double newY = newPos.y;
        double newZ = newPos.z;
        class_2487 copy = nbt.method_10553();
        copy.method_10582("id", entityType);
        this.world.spawnEntity(serverWorld -> class_1299.method_17842((class_2487)copy, (class_1937)serverWorld, entity -> {
            entity.method_5808(newX, newY, newZ, entity.method_36454(), entity.method_36455());
            return entity;
        }));
    }

    public Coordinator coordinator() {
        return this.world.coordinator().inBox(this.coordination.mutableArea, false).translate(this.coordination.transformation.offsetX(), this.coordination.transformation.offsetY(), this.coordination.transformation.offsetZ()).symmetric(this.coordination.transformation.symmetry());
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": { " + String.valueOf(this.world) + " }";
    }

    public record Coordination(SymmetricOffset transformation, class_3341 mutableArea, class_3341 immutableArea) {
        public static class_2338.class_2339 rotate(class_2338.class_2339 pos, SymmetricOffset rotation) {
            int x = rotation.getX(pos.method_10263(), pos.method_10264(), pos.method_10260());
            int y = rotation.getY(pos.method_10263(), pos.method_10264(), pos.method_10260());
            int z = rotation.getZ(pos.method_10263(), pos.method_10264(), pos.method_10260());
            return pos.method_10103(x, y, z);
        }

        public class_2338.class_2339 modifyPosUnbounded(class_2338.class_2339 pos) {
            return Coordination.rotate(pos, this.transformation);
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable class_2338.class_2339 filterPosMutable(class_2338.class_2339 pos) {
            return this.mutableArea.method_14662((class_2382)pos) ? pos : null;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable class_2338.class_2339 filterPosImmutable(class_2338.class_2339 pos) {
            return this.immutableArea.method_14662((class_2382)pos) ? pos : null;
        }

        public static Vector3d rotate(Vector3d vector, SymmetricOffset rotation) {
            double x = vector.x - 0.5;
            double y = vector.y;
            double z = vector.z - 0.5;
            vector.x = rotation.getX(x, y, z) + 0.5;
            vector.y = rotation.getY(x, y, z);
            vector.z = rotation.getZ(x, y, z) + 0.5;
            return vector;
        }

        public Vector3d modifyVecUnbounded(Vector3d vector) {
            return Coordination.rotate(vector, this.transformation);
        }

        public static boolean contains(class_3341 area, double x, double y, double z) {
            return x >= (double)area.method_35415() && x <= (double)(area.method_35418() + 1) && y >= (double)area.method_35416() && y <= (double)(area.method_35419() + 1) && z >= (double)area.method_35417() && z <= (double)(area.method_35420() + 1);
        }

        @Nullable
        public Vector3d filterVecMutable(Vector3d vector) {
            return Coordination.contains(this.mutableArea, vector.x, vector.y, vector.z) ? vector : null;
        }

        @Nullable
        public Vector3d filterVecImmutable(Vector3d vector) {
            return Coordination.contains(this.immutableArea, vector.x, vector.y, vector.z) ? vector : null;
        }

        public class_2680 modifyState(class_2680 state) {
            return this.transformation.symmetry().apply(state);
        }

        public class_2680 unmodifyState(class_2680 state) {
            return this.transformation.symmetry().inverse().apply(state);
        }
    }

    public record AutoOverride(ScriptStructures structures, class_6880<ColumnValueOverrider.Entry>[] overriders, String[] preFetch) {
        public void override(ScriptedColumn column) {
            for (String string : this.preFetch) {
                try {
                    column.preComputeColumnValue(string);
                }
                catch (Throwable throwable) {
                    BigGlobeMod.LOGGER.error("Exception pre-computing column value for overrider: ", throwable);
                }
            }
            for (String string : this.overriders) {
                ((ColumnValueOverrider.Entry)string.comp_349()).script().override(column, this.structures);
            }
        }
    }

    public static class Info
    extends InfoHolder {
        public FieldInfo random;
        public MethodInfo seed;
        public MethodInfo minValidYLevel;
        public MethodInfo maxValidYLevel;
        public MethodInfo hints;
        public MethodInfo distantHorizons;
        public MethodInfo surfaceOnly;
        public MethodInfo offsetY;

        public InsnTree seed(InsnTree loadWorld) {
            return InsnTrees.invokeInstance(loadWorld, this.seed, new InsnTree[0]);
        }

        public InsnTree minValidYLevel(InsnTree loadWorld) {
            return InsnTrees.invokeInstance(loadWorld, this.minValidYLevel, new InsnTree[0]);
        }

        public InsnTree maxValidYLevel(InsnTree loadWorld) {
            return InsnTrees.invokeInstance(loadWorld, this.maxValidYLevel, new InsnTree[0]);
        }

        public InsnTree random(InsnTree loadWorld) {
            return InsnTrees.getField(loadWorld, this.random);
        }

        public InsnTree hints(InsnTree loadWorld) {
            return InsnTrees.invokeInstance(loadWorld, this.hints, new InsnTree[0]);
        }

        public InsnTree distantHorizons(InsnTree loadWorld) {
            return InsnTrees.invokeInstance(loadWorld, this.distantHorizons, new InsnTree[0]);
        }

        public InsnTree surfaceOnly(InsnTree loadWorld) {
            return InsnTrees.invokeInstance(loadWorld, this.surfaceOnly, new InsnTree[0]);
        }

        public InsnTree offsetY(InsnTree loadWorld) {
            return InsnTrees.invokeInstance(loadWorld, this.offsetY, new InsnTree[0]);
        }
    }

    public static class BoundInfo
    extends BoundInfoHolder {
        public InsnTree random;
        public InsnTree seed;
        public InsnTree hints;
        public InsnTree distantHorizons;
        public InsnTree offsetY;

        public BoundInfo(InsnTree loadWorld) {
            super(INFO, loadWorld);
        }
    }
}

