/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.structures.megaTree;

import builderb0y.bigglobe.math.BigGlobeMath;
import builderb0y.bigglobe.structures.megaTree.Ball;
import net.minecraft.class_238;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class MegaTreeOctree {
    public Node root;
    public Query query;

    public MegaTreeOctree(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.root = new EmptyNode(minX, minY, minZ, maxX, maxY, maxZ);
        this.query = new Query(null);
    }

    public MegaTreeOctree(class_238 box) {
        this(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324);
    }

    public void addBall(Ball ball) {
        this.root = this.root.addBall(ball);
    }

    @Nullable
    public Ball findClosestBall(Ball target) {
        Query query = this.query;
        query.target = target;
        query.found = null;
        query.distanceSquared = Double.POSITIVE_INFINITY;
        this.root.findClosest(query);
        return query.found;
    }

    public static class EmptyNode
    extends Node {
        public EmptyNode(double x1, double y1, double z1, double x2, double y2, double z2) {
            super(x1, y1, z1, x2, y2, z2);
        }

        public EmptyNode(class_238 box) {
            super(box);
        }

        @Override
        public Node addBall(Ball ball) {
            return new SingleNode(this, ball);
        }

        @Override
        public void findClosest(Query query) {
        }
    }

    public static abstract class Node
    extends class_238 {
        public final double midX;
        public final double midY;
        public final double midZ;

        public Node(double x1, double y1, double z1, double x2, double y2, double z2) {
            super(x1, y1, z1, x2, y2, z2);
            this.midX = (x1 + x2) * 0.5;
            this.midY = (y1 + y2) * 0.5;
            this.midZ = (z1 + z2) * 0.5;
        }

        public Node(class_238 box) {
            this(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324);
        }

        public abstract Node addBall(Ball var1);

        public abstract void findClosest(Query var1);
    }

    public static class Query {
        public Ball target;
        public Ball found;
        public double distanceSquared;

        public Query(Ball target) {
            this.target = target;
            this.distanceSquared = Double.POSITIVE_INFINITY;
        }

        public void accept(Ball ball) {
            double newDistanceSquared = BigGlobeMath.squareD(ball.x() - this.target.x(), ball.y() - this.target.y(), ball.z() - this.target.z());
            if (newDistanceSquared < this.distanceSquared) {
                this.found = ball;
                this.distanceSquared = newDistanceSquared;
            }
        }
    }

    public static class OctNode
    extends Node {
        public double effectiveMinX = Double.POSITIVE_INFINITY;
        public double effectiveMinY = Double.POSITIVE_INFINITY;
        public double effectiveMinZ = Double.POSITIVE_INFINITY;
        public double effectiveMaxX = Double.NEGATIVE_INFINITY;
        public double effectiveMaxY = Double.NEGATIVE_INFINITY;
        public double effectiveMaxZ = Double.NEGATIVE_INFINITY;
        public Node n000 = new EmptyNode(this.field_1323, this.field_1322, this.field_1321, this.midX, this.midY, this.midZ);
        public Node n001 = new EmptyNode(this.field_1323, this.field_1322, this.midZ, this.midX, this.midY, this.field_1324);
        public Node n010 = new EmptyNode(this.field_1323, this.midY, this.field_1321, this.midX, this.field_1325, this.midZ);
        public Node n011 = new EmptyNode(this.field_1323, this.midY, this.midZ, this.midX, this.field_1325, this.field_1324);
        public Node n100 = new EmptyNode(this.midX, this.field_1322, this.field_1321, this.field_1320, this.midY, this.midZ);
        public Node n101 = new EmptyNode(this.midX, this.field_1322, this.midZ, this.field_1320, this.midY, this.field_1324);
        public Node n110 = new EmptyNode(this.midX, this.midY, this.field_1321, this.field_1320, this.field_1325, this.midZ);
        public Node n111 = new EmptyNode(this.midX, this.midY, this.midZ, this.field_1320, this.field_1325, this.field_1324);

        public OctNode(double x1, double y1, double z1, double x2, double y2, double z2) {
            super(x1, y1, z1, x2, y2, z2);
        }

        public OctNode(class_238 box) {
            super(box);
        }

        public Node getNode(int corner) {
            return switch (corner) {
                case 0 -> this.n000;
                case 1 -> this.n001;
                case 2 -> this.n010;
                case 3 -> this.n011;
                case 4 -> this.n100;
                case 5 -> this.n101;
                case 6 -> this.n110;
                case 7 -> this.n111;
                default -> throw new IllegalArgumentException(Integer.toString(corner));
            };
        }

        public void setNode(int corner, Node node) {
            switch (corner) {
                case 0: {
                    this.n000 = node;
                    break;
                }
                case 1: {
                    this.n001 = node;
                    break;
                }
                case 2: {
                    this.n010 = node;
                    break;
                }
                case 3: {
                    this.n011 = node;
                    break;
                }
                case 4: {
                    this.n100 = node;
                    break;
                }
                case 5: {
                    this.n101 = node;
                    break;
                }
                case 6: {
                    this.n110 = node;
                    break;
                }
                case 7: {
                    this.n111 = node;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Integer.toString(corner));
                }
            }
        }

        public int getClosestCorner(Ball ball) {
            int x = (int)(Double.doubleToRawLongBits(this.midX - ball.x()) >>> 63);
            int y = (int)(Double.doubleToRawLongBits(this.midY - ball.y()) >>> 63);
            int z = (int)(Double.doubleToRawLongBits(this.midZ - ball.z()) >>> 63);
            return x << 2 | y << 1 | z;
        }

        @Override
        public Node addBall(Ball ball) {
            int corner = this.getClosestCorner(ball);
            this.setNode(corner, this.getNode(corner).addBall(ball));
            double x = ball.x();
            double y = ball.y();
            double z = ball.z();
            if (x > this.effectiveMaxX) {
                this.effectiveMaxX = x;
            }
            if (y > this.effectiveMaxY) {
                this.effectiveMaxY = y;
            }
            if (z > this.effectiveMaxZ) {
                this.effectiveMaxZ = z;
            }
            if (x < this.effectiveMinX) {
                this.effectiveMinX = x;
            }
            if (y < this.effectiveMinY) {
                this.effectiveMinY = y;
            }
            if (z < this.effectiveMinZ) {
                this.effectiveMinZ = z;
            }
            return this;
        }

        @Override
        public void findClosest(Query query) {
            Ball ballData = query.target;
            double clampX = class_3532.method_15350((double)ballData.x(), (double)this.effectiveMinX, (double)this.effectiveMaxX);
            double clampY = class_3532.method_15350((double)ballData.y(), (double)this.effectiveMinY, (double)this.effectiveMaxY);
            double clampZ = class_3532.method_15350((double)ballData.z(), (double)this.effectiveMinY, (double)this.effectiveMaxZ);
            if (BigGlobeMath.squareD(ballData.x() - clampX, ballData.y() - clampY, ballData.z() - clampZ) < query.distanceSquared) {
                int containingCorner = this.getClosestCorner(query.target);
                this.getNode(containingCorner).findClosest(query);
                this.getNode(containingCorner ^ 4).findClosest(query);
                this.getNode(containingCorner ^ 2).findClosest(query);
                this.getNode(containingCorner ^ 1).findClosest(query);
                this.getNode(containingCorner ^ 6).findClosest(query);
                this.getNode(containingCorner ^ 5).findClosest(query);
                this.getNode(containingCorner ^ 3).findClosest(query);
                this.getNode(containingCorner ^ 7).findClosest(query);
            }
        }
    }

    public static class SingleNode
    extends Node {
        public final Ball ball;

        public SingleNode(double x1, double y1, double z1, double x2, double y2, double z2, Ball ball) {
            super(x1, y1, z1, x2, y2, z2);
            this.ball = ball;
        }

        public SingleNode(class_238 box, Ball ball) {
            super(box);
            this.ball = ball;
        }

        @Override
        public Node addBall(Ball ball) {
            return new OctNode(this).addBall(this.ball).addBall(ball);
        }

        @Override
        public void findClosest(Query query) {
            query.accept(this.ball);
        }
    }
}

