/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.trees.trunks;

import builderb0y.autocodec.annotations.MemberUsage;
import builderb0y.autocodec.annotations.UseCoder;
import builderb0y.bigglobe.BigGlobeMod;
import builderb0y.bigglobe.codecs.CoderRegistry;
import builderb0y.bigglobe.codecs.CoderRegistryTyped;
import builderb0y.bigglobe.columns.scripted.ScriptedColumn;
import builderb0y.bigglobe.noise.Permuter;
import builderb0y.bigglobe.randomSources.RandomSource;
import builderb0y.bigglobe.trees.trunks.SlantedTrunkConfig;
import builderb0y.bigglobe.trees.trunks.StraightTrunkConfig;
import builderb0y.bigglobe.trees.trunks.TrunkConfig;
import builderb0y.bigglobe.trees.trunks.TrunkThicknessScript;
import builderb0y.bigglobe.trees.trunks.TwistedTrunkConfig;
import java.util.random.RandomGenerator;

@UseCoder(name="REGISTRY", usage=MemberUsage.FIELD_CONTAINS_HANDLER)
public interface TrunkFactory
extends CoderRegistryTyped<TrunkFactory> {
    public static final CoderRegistry<TrunkFactory> REGISTRY = new CoderRegistry(BigGlobeMod.modID("tree_trunk_type"));
    public static final Object INITIALIZER = new Object(){
        {
            REGISTRY.registerAuto(BigGlobeMod.modID("straight"), StraightTrunkFactory.class);
            REGISTRY.registerAuto(BigGlobeMod.modID("slanted"), SlantedTrunkFactory.class);
            REGISTRY.registerAuto(BigGlobeMod.modID("twisted"), TwistedTrunkFactory.class);
        }
    };

    public TrunkConfig create(ScriptedColumn var1, double var2, int var4, double var5, int var7, RandomGenerator var8);

    public static class TwistedTrunkFactory
    extends AbstractTrunkFactory {
        public TwistedTrunkFactory(TrunkThicknessScript.Holder thickness, boolean require_natural_ground, boolean can_generate_in_liquid) {
            super(thickness, require_natural_ground, can_generate_in_liquid);
        }

        @Override
        public TrunkConfig create(ScriptedColumn column, double startX, int startY, double startZ, int height, RandomGenerator random) {
            double speed = Permuter.nextUniformDouble(random);
            speed *= 12.0 - 4.0 * speed * speed;
            return new TwistedTrunkConfig(startX, startY, startZ, height, random.nextDouble(Math.PI * 2), speed, this.thickness, this.require_natural_ground, this.can_generate_in_liquid);
        }
    }

    public static class SlantedTrunkFactory
    extends AbstractTrunkFactory {
        public final RandomSource slant;

        public SlantedTrunkFactory(TrunkThicknessScript.Holder thickness, boolean require_natural_ground, boolean can_generate_in_liquid, RandomSource slant) {
            super(thickness, require_natural_ground, can_generate_in_liquid);
            this.slant = slant;
        }

        @Override
        public TrunkConfig create(ScriptedColumn column, double startX, int startY, double startZ, int height, RandomGenerator random) {
            double slant = this.slant.get(column, startY, random);
            double angle = random.nextDouble(Math.PI * 2);
            return new SlantedTrunkConfig(startX, startY, startZ, height, Math.cos(angle) * slant, Math.sin(angle) * slant, this.thickness, this.require_natural_ground, this.can_generate_in_liquid);
        }
    }

    public static class StraightTrunkFactory
    extends AbstractTrunkFactory {
        public StraightTrunkFactory(TrunkThicknessScript.Holder thickness, boolean require_natural_ground, boolean can_generate_in_liquid) {
            super(thickness, require_natural_ground, can_generate_in_liquid);
        }

        @Override
        public TrunkConfig create(ScriptedColumn column, double startX, int startY, double startZ, int height, RandomGenerator random) {
            return new StraightTrunkConfig(startX, startY, startZ, height, this.thickness, this.require_natural_ground, this.can_generate_in_liquid);
        }
    }

    public static abstract class AbstractTrunkFactory
    implements TrunkFactory {
        public final TrunkThicknessScript.Holder thickness;
        public final boolean require_natural_ground;
        public final boolean can_generate_in_liquid;

        public AbstractTrunkFactory(TrunkThicknessScript.Holder thickness, boolean require_natural_ground, boolean can_generate_in_liquid) {
            this.thickness = thickness;
            this.require_natural_ground = require_natural_ground;
            this.can_generate_in_liquid = can_generate_in_liquid;
        }
    }
}

