/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.util;

import builderb0y.bigglobe.util.AsyncRunner;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;

public abstract class Async<T_Result>
implements AutoCloseable {
    public static final boolean DEBUG_SYNC = false;
    public final Executor executor;
    public final LinkedList<CompletableFuture<T_Result>> waitingOn = new LinkedList();

    public Async(Executor executor) {
        this.executor = executor != null ? executor : ForkJoinPool.commonPool();
    }

    public static <T> void forEach(Executor executor, T[] array, Consumer<T> action) {
        if (array.length == 0) {
            return;
        }
        try (AsyncRunner async = new AsyncRunner(executor);){
            for (Object element : array) {
                async.submit(() -> action.accept(element));
            }
        }
    }

    public static <T> void forEach(Executor executor, List<T> list, Consumer<T> action) {
        if (list.isEmpty()) {
            return;
        }
        try (AsyncRunner async = new AsyncRunner(executor);){
            for (Object element : list) {
                async.submit(() -> action.accept(element));
            }
        }
    }

    public static void loop(Executor executor, int times, IntConsumer action) {
        Async.loop(executor, 0, times, 1, action);
    }

    public static void loop(Executor executor, int startInclusive, int endExclusive, int step, IntConsumer action) {
        if (startInclusive >= endExclusive) {
            return;
        }
        try (AsyncRunner async = new AsyncRunner(executor);){
            for (int number = startInclusive; number < endExclusive; number += step) {
                int number_ = number;
                async.submit(() -> action.accept(number_));
            }
        }
    }

    public static void repeat(Executor executor, int times, Runnable action) {
        if (times <= 0) {
            return;
        }
        try (AsyncRunner async = new AsyncRunner(executor);){
            for (int time = 0; time < times; ++time) {
                async.submit(action);
            }
        }
    }

    public static <T> void setEach(Executor executor, T[] array, IntFunction<T> supplier) {
        if (array.length == 0) {
            return;
        }
        try (AsyncRunner async = new AsyncRunner(executor);){
            int index = 0;
            int length = array.length;
            while (index < length) {
                int index_ = index++;
                async.submit(() -> {
                    array[index_] = supplier.apply(index_);
                });
            }
        }
    }

    public static <T> void setEach(Executor executor, List<T> list, IntFunction<T> supplier) {
        if (list.isEmpty()) {
            return;
        }
        try (AsyncRunner async = new AsyncRunner(executor);){
            int index = 0;
            int size = list.size();
            while (index < size) {
                int index_ = index++;
                async.submit(() -> list.set(index_, supplier.apply(index_)));
            }
        }
    }

    public void begin(CompletableFuture<T_Result> future) {
        this.waitingOn.add(future);
    }

    @Override
    public void close() {
        CompletableFuture<T_Result> future;
        Throwable exception = null;
        while ((future = this.waitingOn.pollFirst()) != null) {
            try {
                this.finish(future);
            }
            catch (Throwable throwable) {
                try {
                    if (exception == null) {
                        exception = new CompletionException("Some tasks failed to complete, see below.", null);
                    }
                    exception.addSuppressed(throwable);
                }
                catch (Throwable throwable2) {}
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public abstract void finish(CompletableFuture<T_Result> var1);
}

