/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.bigglobe.util.coordinators;

import builderb0y.bigglobe.util.coordinators.CoordinateFunctions;
import builderb0y.bigglobe.util.coordinators.Coordinator;
import builderb0y.bigglobe.util.coordinators.ScratchPosCoordinator;

public class StackCoordinator
extends ScratchPosCoordinator {
    public final Coordinator delegate;
    public final int dx;
    public final int dy;
    public final int dz;
    public final int count;

    public StackCoordinator(Coordinator delegate, int dx, int dy, int dz, int count) {
        assert (count > 1);
        assert (dx != 0 || dy != 0 || dz != 0);
        this.delegate = delegate;
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.count = count;
    }

    @Override
    public void genericPos(int x, int y, int z, CoordinateFunctions.CoordinatorRunnable callback) {
        callback.run(this.delegate, x, y, z);
        callback.run(this.delegate, x + this.dx, y + this.dy, z + this.dz);
        for (int i = 2; i < this.count; ++i) {
            callback.run(this.delegate, x + this.dx * i, y + this.dy * i, z + this.dz * i);
        }
    }

    @Override
    public <A> void genericPos(int x, int y, int z, A arg, CoordinateFunctions.CoordinatorConsumer<A> callback) {
        callback.run(this.delegate, x, y, z, arg);
        callback.run(this.delegate, x + this.dx, y + this.dy, z + this.dz, arg);
        for (int i = 2; i < this.count; ++i) {
            callback.run(this.delegate, x + this.dx * i, y + this.dy * i, z + this.dz * i, arg);
        }
    }

    @Override
    public <A, B> void genericPos(int x, int y, int z, A arg1, B arg2, CoordinateFunctions.CoordinatorBiConsumer<A, B> callback) {
        callback.run(this.delegate, x, y, z, arg1, arg2);
        callback.run(this.delegate, x + this.dx, y + this.dy, z + this.dz, arg1, arg2);
        for (int i = 2; i < this.count; ++i) {
            callback.run(this.delegate, x + this.dx * i, y + this.dy * i, z + this.dz * i, arg1, arg2);
        }
    }

    @Override
    public <A, B, C> void genericPos(int x, int y, int z, A arg1, B arg2, C arg3, CoordinateFunctions.CoordinatorTriConsumer<A, B, C> callback) {
        callback.run(this.delegate, x, y, z, arg1, arg2, arg3);
        callback.run(this.delegate, x + this.dx, y + this.dy, z + this.dz, arg1, arg2, arg3);
        for (int i = 2; i < this.count; ++i) {
            callback.run(this.delegate, x + this.dx * i, y + this.dy * i, z + this.dz * i, arg1, arg2, arg3);
        }
    }

    public int hashCode() {
        int hash = this.delegate.hashCode();
        hash = hash * 31 + this.dx;
        hash = hash * 31 + this.dy;
        hash = hash * 31 + this.dz;
        hash = hash * 31 + this.count;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StackCoordinator)) {
            return false;
        }
        StackCoordinator that = (StackCoordinator)obj;
        return this.delegate.equals(that.delegate) && this.dx == that.dx && this.dy == that.dy && this.dz == that.dz && this.count == that.count;
    }

    public String toString() {
        return this.delegate.toString() + " stacked " + this.count + "x (" + this.dx + ", " + this.dy + ", " + this.dz + ")";
    }
}

