/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode;

import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.Typeable;
import builderb0y.scripting.util.ReflectionData;
import java.lang.reflect.Field;

public class FieldInfo
implements Typeable {
    public static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    public final int access;
    public final TypeInfo owner;
    public final String name;
    public final TypeInfo type;

    public FieldInfo(int access, TypeInfo owner, String name, TypeInfo type) {
        this.access = access;
        this.owner = owner;
        this.name = name;
        this.type = type;
        if (owner.isPrimitive()) {
            throw new IllegalArgumentException("Primitive class cannot have fields: " + String.valueOf(this));
        }
        if (owner.isArray()) {
            throw new IllegalArgumentException("Array class cannot have fields: " + String.valueOf(this));
        }
        if (type.isVoid()) {
            throw new IllegalArgumentException("Cannot have a field of type void: " + String.valueOf(this));
        }
    }

    public static FieldInfo inCaller(String name) {
        return FieldInfo.getField(STACK_WALKER.getCallerClass(), name);
    }

    public static FieldInfo getField(Class<?> in, String name) {
        return FieldInfo.forField(ReflectionData.forClass(in).getDeclaredField(name));
    }

    public static FieldInfo findField(Class<?> in, String name, Class<?> type) {
        return FieldInfo.forField(ReflectionData.forClass(in).findDeclaredField(name, type));
    }

    public static FieldInfo forField(Field field) {
        return new FieldInfo(field.getModifiers(), TypeInfo.of(field.getDeclaringClass()), field.getName(), TypeInfo.of(field.getGenericType()));
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this.type;
    }

    public boolean isStatic() {
        return (this.access & 8) != 0;
    }

    public boolean isFinal() {
        return (this.access & 0x10) != 0;
    }

    public FieldInfo makeFinal() {
        return this.isFinal() ? this : new FieldInfo(this.access | 0x10, this.owner, this.name, this.type);
    }

    public void emitGet(MethodCompileContext method) {
        method.node.visitFieldInsn(this.isStatic() ? 178 : 180, this.owner.getInternalName(), this.name, this.type.getDescriptor());
    }

    public void emitPut(MethodCompileContext method) {
        method.node.visitFieldInsn(this.isStatic() ? 179 : 181, this.owner.getInternalName(), this.name, this.type.getDescriptor());
    }

    public String toString() {
        return this.owner.getInternalName() + "." + this.name + " : " + this.type.getDescriptor();
    }

    public int hashCode() {
        int hash = this.owner.hashCode();
        hash = hash * 31 + this.name.hashCode();
        hash = hash * 31 + this.type.hashCode();
        return hash;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) return true;
        if (!(object instanceof FieldInfo)) return false;
        FieldInfo that = (FieldInfo)object;
        if (this.access != that.access) return false;
        if (!this.owner.equals(that.owner)) return false;
        if (!this.name.equals(that.name)) return false;
        if (!this.type.equals(that.type)) return false;
        return true;
    }
}

