/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.conditions;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.tree.conditions.ConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.ConstantConditionTree;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Label;

public class AndConditionTree
implements ConditionTree {
    public final ConditionTree left;
    public final ConditionTree right;

    public AndConditionTree(ConditionTree left, ConditionTree right) {
        this.left = left;
        this.right = right;
    }

    public static ConditionTree create(ConditionTree left, ConditionTree right) {
        if (left instanceof ConstantConditionTree) {
            ConstantConditionTree leftConstant = (ConstantConditionTree)left;
            if (right instanceof ConstantConditionTree) {
                ConstantConditionTree rightConstant = (ConstantConditionTree)right;
                return ConstantConditionTree.of(leftConstant.value & rightConstant.value);
            }
            return leftConstant.value ? right : leftConstant;
        }
        if (right instanceof ConstantConditionTree) {
            ConstantConditionTree rightConstant = (ConstantConditionTree)right;
            if (rightConstant.value) {
                return left;
            }
        }
        return new AndConditionTree(left, right);
    }

    @Override
    public void emitBytecode(MethodCompileContext method, @Nullable Label ifTrue, @Nullable Label ifFalse) {
        boolean madeFalse;
        ConditionTree.checkLabels(ifTrue, ifFalse);
        boolean bl = madeFalse = ifFalse == null;
        if (madeFalse) {
            ifFalse = InsnTrees.label();
        }
        this.left.emitBytecode(method, null, ifFalse);
        this.right.emitBytecode(method, null, ifFalse);
        if (ifTrue != null) {
            method.node.visitJumpInsn(167, ifTrue);
        }
        if (madeFalse) {
            method.node.visitLabel(ifFalse);
        }
    }
}

