/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.flow;

import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.ScopeContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.conditions.ConditionTree;
import builderb0y.scripting.bytecode.tree.conditions.ConstantConditionTree;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.util.TypeInfos;
import builderb0y.scripting.util.TypeMerger;
import org.objectweb.asm.tree.AbstractInsnNode;

public class IfElseInsnTree
implements InsnTree {
    public final ConditionTree condition;
    public final InsnTree trueBody;
    public final InsnTree falseBody;
    public final TypeInfo type;

    public IfElseInsnTree(ConditionTree condition, InsnTree trueBody, InsnTree falseBody, TypeInfo type) {
        this.condition = condition;
        this.trueBody = trueBody;
        this.falseBody = falseBody;
        this.type = type;
    }

    public static InsnTree create(ExpressionParser parser, ConditionTree condition, InsnTree trueBody, InsnTree falseBody) throws ScriptParsingException {
        Operands operands = Operands.of(parser, trueBody, falseBody);
        return new IfElseInsnTree(condition, operands.trueBody, operands.falseBody, operands.type);
    }

    @Override
    public void emitBytecode(MethodCompileContext method) {
        ScopeContext.Scope scope = method.scopes.pushScope();
        this.condition.emitBytecode(method, null, scope.end.getLabel());
        this.trueBody.emitBytecode(method);
        scope.cycle();
        method.scopes.cycleScope();
        method.node.visitJumpInsn(167, scope.end.getLabel());
        method.node.instructions.add((AbstractInsnNode)scope.start);
        this.falseBody.emitBytecode(method);
        method.scopes.popLoop();
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this.type;
    }

    @Override
    public boolean jumpsUnconditionally() {
        ConditionTree conditionTree = this.condition;
        if (conditionTree instanceof ConstantConditionTree) {
            ConstantConditionTree constant = (ConstantConditionTree)conditionTree;
            return (constant.value ? this.trueBody : this.falseBody).jumpsUnconditionally();
        }
        return this.trueBody.jumpsUnconditionally() && this.falseBody.jumpsUnconditionally();
    }

    @Override
    public boolean canBeStatement() {
        return this.trueBody.canBeStatement() && this.falseBody.canBeStatement();
    }

    @Override
    public InsnTree asStatement() {
        return new IfElseInsnTree(this.condition, this.trueBody.asStatement(), this.falseBody.asStatement(), TypeInfos.VOID);
    }

    @Override
    public InsnTree doCast(ExpressionParser parser, TypeInfo type, InsnTree.CastMode mode, boolean nullable) {
        InsnTree trueBody = this.trueBody.cast(parser, type, mode, nullable);
        if (trueBody == null) {
            return null;
        }
        InsnTree falseBody = this.falseBody.cast(parser, type, mode, nullable);
        if (falseBody == null) {
            return null;
        }
        return new IfElseInsnTree(this.condition, trueBody, falseBody, type);
    }

    public record Operands(InsnTree trueBody, InsnTree falseBody, TypeInfo type) {
        public static Operands of(ExpressionParser parser, InsnTree trueBody, InsnTree falseBody) {
            TypeInfo type;
            if (trueBody.jumpsUnconditionally()) {
                type = falseBody.jumpsUnconditionally() ? TypeInfos.VOID : falseBody.getTypeInfo();
            } else if (falseBody.jumpsUnconditionally()) {
                type = trueBody.getTypeInfo();
            } else {
                type = TypeMerger.computeMostSpecificType(trueBody.getTypeInfo(), falseBody.getTypeInfo());
                trueBody = trueBody.cast(parser, type, InsnTree.CastMode.IMPLICIT_THROW, false);
                falseBody = falseBody.cast(parser, type, InsnTree.CastMode.IMPLICIT_THROW, false);
            }
            return new Operands(trueBody, falseBody, type);
        }
    }
}

