/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.bytecode.tree.instructions.update;

import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.InvalidOperandException;
import builderb0y.scripting.bytecode.tree.instructions.update.AbstractUpdaterInsnTree;

public class ArrayUpdaterInsnTree
extends AbstractUpdaterInsnTree {
    public InsnTree array;
    public InsnTree index;
    public InsnTree updater;
    public TypeInfo componentType;

    public ArrayUpdaterInsnTree(AbstractUpdaterInsnTree.CombinedMode mode, InsnTree array, InsnTree index, InsnTree updater) {
        super(mode);
        this.array = array;
        this.index = index;
        this.updater = updater;
        this.componentType = array.getTypeInfo().componentType;
        if (this.componentType == null) {
            throw new InvalidOperandException("Not an array: " + String.valueOf(array));
        }
    }

    public ArrayUpdaterInsnTree(InsnTree.UpdateOrder order, boolean isAssignment, InsnTree array, InsnTree index, InsnTree updater) {
        super(order, isAssignment);
        this.array = array;
        this.index = index;
        this.updater = updater;
        this.componentType = array.getTypeInfo().componentType;
        if (this.componentType == null) {
            throw new InvalidOperandException("Not an array: " + String.valueOf(array));
        }
    }

    @Override
    public void emitBytecode(MethodCompileContext method) {
        this.array.emitBytecode(method);
        this.index.emitBytecode(method);
        switch (this.mode) {
            case VOID: {
                method.node.visitInsn(92);
                method.node.visitInsn(this.componentType.getOpcode(46));
                this.updater.emitBytecode(method);
                method.node.visitInsn(this.componentType.getOpcode(79));
                break;
            }
            case PRE: {
                method.node.visitInsn(92);
                method.node.visitInsn(this.componentType.getOpcode(46));
                method.node.visitInsn(this.componentType.isDoubleWidth() ? 94 : 91);
                this.updater.emitBytecode(method);
                method.node.visitInsn(this.componentType.getOpcode(79));
                break;
            }
            case POST: {
                method.node.visitInsn(92);
                method.node.visitInsn(this.componentType.getOpcode(46));
                this.updater.emitBytecode(method);
                method.node.visitInsn(this.componentType.isDoubleWidth() ? 94 : 91);
                method.node.visitInsn(this.componentType.getOpcode(79));
                break;
            }
            case VOID_ASSIGN: {
                this.updater.emitBytecode(method);
                method.node.visitInsn(this.componentType.getOpcode(79));
                break;
            }
            case PRE_ASSIGN: {
                method.node.visitInsn(92);
                method.node.visitInsn(this.componentType.getOpcode(46));
                method.node.visitInsn(this.componentType.isDoubleWidth() ? 94 : 91);
                method.node.visitInsn(this.componentType.isDoubleWidth() ? 88 : 87);
                this.updater.emitBytecode(method);
                method.node.visitInsn(this.componentType.getOpcode(79));
                break;
            }
            case POST_ASSIGN: {
                this.updater.emitBytecode(method);
                method.node.visitInsn(this.componentType.isDoubleWidth() ? 94 : 91);
                method.node.visitInsn(this.componentType.getOpcode(79));
            }
        }
    }

    @Override
    public TypeInfo getPreType() {
        return this.componentType;
    }

    @Override
    public TypeInfo getPostType() {
        return this.updater.getTypeInfo();
    }

    @Override
    public InsnTree asStatement() {
        return this.mode.isVoid() ? this : new ArrayUpdaterInsnTree(this.mode.asVoid(), this.array, this.index, this.updater);
    }
}

