/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.environments;

import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.bytecode.tree.InsnTree;
import builderb0y.scripting.bytecode.tree.instructions.casting.DirectCastInsnTree;
import builderb0y.scripting.environments.BuiltinScriptEnvironment;
import builderb0y.scripting.environments.MultiScriptEnvironment;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.environments.UserScriptEnvironment;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.util.TypeInfos;
import org.jetbrains.annotations.Nullable;

public class RootScriptEnvironment
extends MultiScriptEnvironment {
    public static final int USER_INDEX = 0;
    public static final int MUTABLE_INDEX = 1;

    public RootScriptEnvironment() {
        this.environments.add(new UserScriptEnvironment());
        this.environments.add(new MutableScriptEnvironment().addAll(BuiltinScriptEnvironment.INSTANCE));
    }

    public RootScriptEnvironment(RootScriptEnvironment from) {
        super(from);
        this.environments.set(0, new UserScriptEnvironment(from.user()));
        this.environments.set(1, new MutableScriptEnvironment().addAll(from.mutable()));
    }

    @Override
    @Nullable
    public InsnTree cast(ExpressionParser parser, InsnTree value, TypeInfo to, boolean implicit, boolean nullable) {
        TypeInfo from = value.getTypeInfo();
        if (to.isObject()) {
            if (from.isObject()) {
                if (from.extendsOrImplements(to)) {
                    return InsnTrees.wrapIdentityCast(value, to);
                }
                if (!implicit && (to.extendsOrImplements(from) || to.type.isInterface && !from.isFinal)) {
                    return new DirectCastInsnTree(value, to, nullable);
                }
            } else {
                TypeInfo boxed = from.box();
                if (boxed.extendsOrImplements(to)) {
                    InsnTree casted = BuiltinScriptEnvironment.INSTANCE.cast(parser, value, boxed, false, nullable);
                    if (casted != null) {
                        return casted;
                    }
                    throw new ClassCastException("Can't primitively cast " + value.describe() + " to " + String.valueOf(boxed));
                }
            }
        } else if (from.isObject() && !implicit) {
            TypeInfo castTo;
            switch (to.getSort()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case BYTE: {
                    TypeInfo typeInfo = TypeInfos.BYTE_WRAPPER;
                    break;
                }
                case SHORT: {
                    TypeInfo typeInfo = TypeInfos.SHORT_WRAPPER;
                    break;
                }
                case INT: {
                    TypeInfo typeInfo = TypeInfos.INT_WRAPPER;
                    break;
                }
                case LONG: {
                    TypeInfo typeInfo = TypeInfos.LONG_WRAPPER;
                    break;
                }
                case FLOAT: {
                    TypeInfo typeInfo = TypeInfos.FLOAT_WRAPPER;
                    break;
                }
                case DOUBLE: {
                    TypeInfo typeInfo = TypeInfos.DOUBLE_WRAPPER;
                    break;
                }
                case CHAR: {
                    TypeInfo typeInfo = TypeInfos.CHAR_WRAPPER;
                    break;
                }
                case BOOLEAN: {
                    TypeInfo typeInfo = TypeInfos.BOOLEAN_WRAPPER;
                    break;
                }
                case VOID: 
                case OBJECT: 
                case ARRAY: {
                    TypeInfo typeInfo = castTo = null;
                }
            }
            if (castTo != null && castTo.extendsOrImplements(from)) {
                value = new DirectCastInsnTree(value, castTo, nullable);
            }
        }
        return super.cast(parser, value, to, implicit, nullable);
    }

    public UserScriptEnvironment user() {
        return (UserScriptEnvironment)this.environments.get(0);
    }

    public MutableScriptEnvironment mutable() {
        return (MutableScriptEnvironment)this.environments.get(1);
    }

    public RootScriptEnvironment user(UserScriptEnvironment user) {
        this.environments.set(0, user);
        return this;
    }

    public RootScriptEnvironment mutable(MutableScriptEnvironment mutable) {
        this.environments.set(1, mutable);
        return this;
    }
}

