/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.optimization;

import builderb0y.scripting.optimization.ClassOptimizer;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class UnusedLocalVariableRemover
implements ClassOptimizer.MethodOptimizer {
    public static final UnusedLocalVariableRemover INSTANCE = new UnusedLocalVariableRemover();

    @Override
    public boolean optimize(MethodNode method) {
        return method.localVariables != null && method.localVariables.removeIf(variable -> {
            for (LabelNode node = variable.start; node != variable.end; node = node.getNext()) {
                if (node instanceof VarInsnNode) {
                    VarInsnNode var = (VarInsnNode)node;
                    if (var.var == variable.index) {
                        return false;
                    }
                }
                if (!(node instanceof IincInsnNode)) continue;
                IincInsnNode inc = (IincInsnNode)node;
                if (inc.var != variable.index) continue;
                return false;
            }
            return true;
        });
    }
}

