/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.parsing;

import builderb0y.autocodec.util.TypeFormatter;
import builderb0y.scripting.bytecode.ClassCompileContext;
import builderb0y.scripting.bytecode.ClassType;
import builderb0y.scripting.bytecode.InsnTrees;
import builderb0y.scripting.bytecode.LazyVarInfo;
import builderb0y.scripting.bytecode.MethodCompileContext;
import builderb0y.scripting.bytecode.TypeInfo;
import builderb0y.scripting.environments.MutableScriptEnvironment;
import builderb0y.scripting.environments.ScriptEnvironment;
import builderb0y.scripting.parsing.ExpressionParser;
import builderb0y.scripting.parsing.Script;
import builderb0y.scripting.parsing.ScriptClassLoader;
import builderb0y.scripting.parsing.ScriptParsingException;
import builderb0y.scripting.util.TypeInfos;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.objectweb.asm.Type;

public class ScriptParser<I>
extends ExpressionParser {
    public Class<I> implementingClass;
    public Method implementingMethod;
    @Nullable
    public String debugName;

    public ScriptParser(Class<I> implementingClass, Method implementingMethod, String input, @Nullable String debugName, ClassCompileContext clazz, MethodCompileContext method, int flags) {
        super(input, clazz, method, flags);
        this.implementingClass = implementingClass;
        this.implementingMethod = implementingMethod;
        this.debugName = debugName;
        clazz.addNoArgConstructor(1);
        MethodCompileContext getSource = clazz.newMethod(1, "getSource", TypeInfos.STRING, new LazyVarInfo[0]);
        InsnTrees.return_(InsnTrees.ldc(clazz.newConstant(input, TypeInfos.STRING))).emitBytecode(getSource);
        getSource.endCode();
        MethodCompileContext getDebugName = clazz.newMethod(1, "getDebugName", TypeInfos.STRING, new LazyVarInfo[0]);
        InsnTrees.return_(InsnTrees.ldc(debugName)).emitBytecode(getDebugName);
        getDebugName.endCode();
        StringBuilder toString = new StringBuilder(input.length() + 128).append(TypeFormatter.getSimpleClassName(implementingClass)).append("::").append(implementingMethod.getName());
        if (debugName != null) {
            toString.append(" (").append(debugName).append(')');
        }
        clazz.addToString(toString.toString());
    }

    public ScriptParser(Class<I> implementingClass, Method implementingMethod, String input, @Nullable String debugName, ClassCompileContext clazz, int flags) {
        this(implementingClass, implementingMethod, input, debugName, clazz, clazz.newMethod(1, implementingMethod.getName(), InsnTrees.type(implementingMethod.getReturnType()), (LazyVarInfo[])Arrays.stream(implementingMethod.getParameters()).peek(parameter -> {
            if (!parameter.isNamePresent()) {
                throw new IllegalArgumentException("Attempt to create script from interface with unnamed parameters: " + String.valueOf(implementingClass));
            }
        }).map(parameter -> new LazyVarInfo(parameter.getName(), InsnTrees.type(parameter.getType()))).toArray((IntFunction<A[]>)LazyVarInfo.ARRAY_FACTORY)), flags);
    }

    public ScriptParser(Class<I> implementingClass, Method implementingMethod, String input, @Nullable String debugName, int flags) {
        TypeInfo[] typeInfoArray;
        String string = Type.getInternalName(ScriptParser.class) + "$" + (debugName != null ? debugName : "Generated") + "_" + ScriptClassLoader.CLASS_UNIQUIFIER.getAndIncrement();
        if (Script.class.isAssignableFrom(implementingClass)) {
            TypeInfo[] typeInfoArray2 = new TypeInfo[1];
            typeInfoArray = typeInfoArray2;
            typeInfoArray2[0] = InsnTrees.type(implementingClass);
        } else {
            TypeInfo[] typeInfoArray3 = new TypeInfo[2];
            typeInfoArray3[0] = InsnTrees.type(implementingClass);
            typeInfoArray = typeInfoArray3;
            typeInfoArray3[1] = InsnTrees.type(Script.class);
        }
        this(implementingClass, implementingMethod, input, debugName, new ClassCompileContext(4113, ClassType.CLASS, string, TypeInfos.OBJECT, typeInfoArray), flags);
    }

    public ScriptParser(Class<I> implementingClass, String input, String debugName, int flags) {
        this(implementingClass, ScriptParser.findImplementingMethod(implementingClass), input, debugName, flags);
    }

    @TestOnly
    public ScriptParser(Class<I> implementingClass, String input) {
        this(implementingClass, input, null, 0);
    }

    @Override
    public ScriptParser<I> addEnvironment(ScriptEnvironment environment) {
        return (ScriptParser)super.addEnvironment(environment);
    }

    @Override
    public ScriptParser<I> configureEnvironment(Consumer<MutableScriptEnvironment> configurator) {
        return (ScriptParser)super.configureEnvironment(configurator);
    }

    public static Method findImplementingMethod(Class<?> implementingClass) {
        Method implementingMethod = null;
        for (Method method : implementingClass.getMethods()) {
            if (!Modifier.isAbstract(method.getModifiers()) || method.getDeclaringClass() == Script.class) continue;
            if (implementingMethod == null) {
                implementingMethod = method;
                continue;
            }
            throw new IllegalArgumentException("implementingClass must have exactly 1 abstract method.");
        }
        if (implementingMethod == null) {
            throw new IllegalArgumentException("implementingClass must have exactly 1 abstract method.");
        }
        return implementingMethod;
    }

    public I parse(ScriptClassLoader loader) throws ScriptParsingException {
        this.toBytecode();
        return this.toScript(loader);
    }

    public void toBytecode() throws ScriptParsingException {
        this.parseEntireInput().emitBytecode(this.method);
        this.method.endCode();
    }

    public I toScript(ScriptClassLoader loader) throws ScriptParsingException {
        try {
            return this.compile(loader).asSubclass(this.implementingClass).getDeclaredConstructor(null).newInstance(null);
        }
        catch (Throwable throwable) {
            throw new ScriptParsingException(this.fatalError().toString(), throwable, null);
        }
    }

    @Override
    public StringBuilder fatalError() {
        return super.fatalError().append("Implementation interface: ").append(this.implementingClass.getName()).append('\n').append("Implementation method: ").append(this.implementingMethod).append('\n');
    }
}

