/*
 * Decompiled with CFR 0.152.
 */
package builderb0y.scripting.parsing;

import builderb0y.scripting.parsing.ExpressionReader;
import org.jetbrains.annotations.Nullable;

public class ScriptParsingException
extends Exception {
    public ScriptParsingException(String message, ExpressionReader input) {
        super(ScriptParsingException.appendContext(message, input));
    }

    public ScriptParsingException(String message, Throwable cause, ExpressionReader input) {
        super(ScriptParsingException.appendContext(message, input), cause);
    }

    public ScriptParsingException(Throwable cause, ExpressionReader input) {
        super(ScriptParsingException.appendContext(cause.getMessage(), input), cause);
    }

    public ScriptParsingException(ScriptParsingException cause) {
        super(cause.getMessage(), cause);
    }

    @Nullable
    public static String appendContext(@Nullable String message, @Nullable ExpressionReader input) {
        if (message != null) {
            if (input != null) {
                return message + " at line " + input.line + ", column " + input.column + ":\n" + input.getSourceForError() + " <--- HERE";
            }
            return message;
        }
        if (input != null) {
            return "Unknown error at line " + input.line + ", column " + input.column + ":\n" + input.getSourceForError() + " <--- HERE";
        }
        return null;
    }
}

