package de.silencio.better_beacon_range.mixin;

import de.silencio.better_beacon_range.BeaconConfig;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2580;
import net.minecraft.class_6880;

@Mixin(class_2580.class)
public class BeaconRangeMixin {

    @Unique
    private static BeaconConfig config;

    @Inject(method = "applyPlayerEffects", at = @At("HEAD"), cancellable = true)
    private static void modifyBeaconRange(class_1937 world, class_2338 pos, int beaconLevel, @Nullable class_6880<class_1291> primaryEffect, @Nullable class_6880<class_1291> secondaryEffect, CallbackInfo ci) {
        // Prevent client-side execution, just in case
        if (world.field_9236) return;

        // only load config when the method is called
        // makes sure the config is only loaded on a dedicated or integrated server
        if (config == null) {
            config = new BeaconConfig();
            config.loadConfig();
        }

        double base = config.getBase();
        double perLevel = config.getPerLevel();
        boolean belowInfinite = config.isBelowInfinite();
        double customRange = beaconLevel * perLevel + base;

        ci.cancel();

        applyPlayerEffects(world, pos, beaconLevel, primaryEffect, secondaryEffect, customRange, belowInfinite);
    }

    @Unique
    private static void applyPlayerEffects(class_1937 world, class_2338 pos, int beaconLevel,
                                           @Nullable class_6880<class_1291> primaryEffect,
                                           @Nullable class_6880<class_1291> secondaryEffect,
                                           double customRange, boolean belowInfinite) {

        if (!world.field_9236 && primaryEffect != null) {
            int i = 0;
            if (beaconLevel >= 4 && Objects.equals(primaryEffect, secondaryEffect)) {
                i = 1;
            }

            int j = (9 + beaconLevel * 2) * 20;
            class_238 box;
            if (belowInfinite) {
                box = new class_238(pos).method_1009(customRange, world.method_31605(), customRange);
            } else {
                box = new class_238(pos).method_1014(customRange).method_1012(0.0, world.method_31605(), 0.0);
            }
            List<class_1657> list = world.method_18467(class_1657.class, box);

            for (class_1657 playerEntity : list) {
                playerEntity.method_6092(new class_1293(primaryEffect, j, i, true, true));
            }

            if (beaconLevel >= 4 && !Objects.equals(primaryEffect, secondaryEffect) && secondaryEffect != null) {
                for (class_1657 playerEntity : list) {
                    playerEntity.method_6092(new class_1293(secondaryEffect, j, 0, true, true));
                }
            }
        }
    }
}
