/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.advancedserverlist.banplugins.bungeecord;

import ch.andre601.advancedserverlist.api.AdvancedServerListAPI;
import ch.andre601.advancedserverlist.banplugins.BanPluginsList;
import net.md_5.bungee.api.plugin.Plugin;

public class BungeeCordBanPluginsAddon
extends Plugin {
    public void onEnable() {
        if (this.getProxy().getPluginManager().getPlugin("AdvancedServerList") == null) {
            this.getLogger().warning("AdvancedServerList is not enabled. This plugin requires it to function!");
            return;
        }
        int loadedPlaceholders = this.loadPlaceholderProviders();
        if (loadedPlaceholders == 0) {
            this.getLogger().warning("No compatible Ban plugin was found to register placeholders for.");
        } else {
            this.getLogger().info("Loaded " + loadedPlaceholders + " Placeholder Set(s) for AdvancedServerList!");
        }
    }

    private int loadPlaceholderProviders() {
        int loaded = 0;
        AdvancedServerListAPI api = AdvancedServerListAPI.get();
        for (BanPluginsList entry : BanPluginsList.values()) {
            if (!entry.supportsBungeeCord() || this.getProxy().getPluginManager().getPlugin(entry.getName()) == null) continue;
            this.getLogger().info("Registering Placeholders for " + entry.getName() + "...");
            api.addPlaceholderProvider(entry.getPlaceholderProvider());
            this.getLogger().info("Placeholders successfully registered!");
            ++loaded;
        }
        return loaded;
    }
}

