/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.advancedserverlist.banplugins.paper;

import ch.andre601.advancedserverlist.api.AdvancedServerListAPI;
import ch.andre601.advancedserverlist.banplugins.BanPluginsList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PaperBanPluginsAddon
extends JavaPlugin {
    public void onEnable() {
        if (!this.getServer().getPluginManager().isPluginEnabled("AdvancedServerList")) {
            this.getLogger().warning("AdvancedServerList is not enabled. This plugin requires it to function!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        int loadedPlaceholders = this.loadPlaceholderProviders();
        if (loadedPlaceholders == 0) {
            this.getLogger().warning("No compatible Ban plugin was found to register placeholders for. Disabling plugin...");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        } else {
            this.getLogger().info("Loaded " + loadedPlaceholders + " Placeholder Set(s) for AdvancedServerList!");
        }
    }

    private int loadPlaceholderProviders() {
        int loaded = 0;
        AdvancedServerListAPI api = AdvancedServerListAPI.get();
        for (BanPluginsList entry : BanPluginsList.values()) {
            if (!entry.supportsPaper() || !this.getServer().getPluginManager().isPluginEnabled(entry.getName())) continue;
            this.getLogger().info("Registering Placeholders for " + entry.getName() + "...");
            api.addPlaceholderProvider(entry.getPlaceholderProvider());
            this.getLogger().info("Placeholders successfully registered!");
            ++loaded;
        }
        return loaded;
    }
}

