/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.advancedserverlist.banplugins.placeholders;

import ch.andre601.advancedserverlist.api.PlaceholderProvider;
import ch.andre601.advancedserverlist.api.objects.GenericPlayer;
import ch.andre601.advancedserverlist.api.objects.GenericServer;
import ch.andre601.advancedserverlist.banplugins.providers.AdvancedBanProvider;

public class AdvancedBanPlaceholders
extends PlaceholderProvider {
    private AdvancedBanProvider provider = null;

    public AdvancedBanPlaceholders() {
        super("advancedban");
    }

    public String parsePlaceholder(String placeholder, GenericPlayer player, GenericServer server) {
        if (this.provider == null) {
            this.provider = new AdvancedBanProvider();
        }
        String[] args = placeholder.split("\\s", 2);
        return switch (args[0]) {
            case "isMuted" -> this.provider.muted(player);
            case "muteReason" -> this.provider.muteReason(player);
            case "muteDuration" -> {
                if (args.length == 1) {
                    yield this.provider.muteDuration(player);
                }
                boolean fromStart = Boolean.getBoolean(args[1]);
                yield this.provider.muteDuration(player, fromStart);
            }
            case "muteExpiration" -> {
                if (args.length == 1) {
                    yield this.provider.muteExpirationDate(player);
                }
                yield this.provider.banExpirationDate(player, args[1]);
            }
            case "isBanned" -> this.provider.banned(player);
            case "banReason" -> this.provider.banReason(player);
            case "banDuration" -> {
                if (args.length == 1) {
                    yield this.provider.banDuration(player);
                }
                boolean fromStart = Boolean.getBoolean(args[1]);
                yield this.provider.banDuration(player, fromStart);
            }
            case "banExpiration" -> {
                if (args.length == 1) {
                    yield this.provider.banExpirationDate(player);
                }
                yield this.provider.banExpirationDate(player, args[1]);
            }
            default -> null;
        };
    }
}

