/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.advancedserverlist.banplugins.placeholders;

import ch.andre601.advancedserverlist.api.PlaceholderProvider;
import ch.andre601.advancedserverlist.api.objects.GenericPlayer;
import ch.andre601.advancedserverlist.api.objects.GenericServer;
import ch.andre601.advancedserverlist.banplugins.providers.LiteBansProvider;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class LiteBansPlaceholders
extends PlaceholderProvider {
    private LiteBansProvider provider = null;

    public LiteBansPlaceholders() {
        super("litebans");
    }

    public String parsePlaceholder(String placeholder, GenericPlayer player, GenericServer server) {
        if (this.provider == null) {
            this.provider = new LiteBansProvider();
        }
        String[] args = placeholder.split("\\s", 2);
        CompletableFuture<String> future = CompletableFuture.supplyAsync(() -> switch (args[0]) {
            case "isMuted" -> this.provider.muted(player);
            case "muteReason" -> this.provider.muteReason(player);
            case "muteDuration" -> this.provider.muteDuration(player);
            case "muteExpiration" -> {
                if (args.length == 1) {
                    yield this.provider.muteExpirationDate(player);
                }
                yield this.provider.muteExpirationDate(player, args[1]);
            }
            case "isBanned" -> this.provider.banned(player);
            case "banReason" -> this.provider.banReason(player);
            case "banDuration" -> this.provider.banDuration(player);
            case "banExpiration" -> {
                if (args.length == 1) {
                    yield this.provider.banExpirationDate(player);
                }
                yield this.provider.banExpirationDate(player, args[1]);
            }
            default -> null;
        });
        try {
            return future.join();
        }
        catch (CancellationException | CompletionException ex) {
            return null;
        }
    }
}

