/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.advancedserverlist.banplugins.providers;

import ch.andre601.advancedserverlist.api.objects.GenericPlayer;
import ch.andre601.advancedserverlist.banplugins.providers.PunishmentProvider;
import com.google.common.base.Strings;
import com.google.common.primitives.UnsignedLongs;
import java.util.UUID;
import me.leoko.advancedban.manager.PunishmentManager;
import me.leoko.advancedban.utils.Punishment;

public class AdvancedBanProvider
implements PunishmentProvider {
    @Override
    public String muted(GenericPlayer player) {
        return String.valueOf(this.getAPI().isMuted(this.noDashesUUID(player.getUUID())));
    }

    @Override
    public String banned(GenericPlayer player) {
        return String.valueOf(this.getAPI().isBanned(this.noDashesUUID(player.getUUID())));
    }

    @Override
    public String muteReason(GenericPlayer player) {
        Punishment mute = this.mute(player);
        if (mute == null) {
            return null;
        }
        return mute.getReason();
    }

    @Override
    public String banReason(GenericPlayer player) {
        Punishment ban = this.ban(player);
        if (ban == null) {
            return null;
        }
        return ban.getReason();
    }

    @Override
    public String muteDuration(GenericPlayer player) {
        return this.muteDuration(player, false);
    }

    @Override
    public String banDuration(GenericPlayer player) {
        return this.banDuration(player, false);
    }

    @Override
    public String muteExpirationDate(GenericPlayer player, String pattern) {
        Punishment mute = this.mute(player);
        if (mute == null) {
            return null;
        }
        long end = mute.getEnd();
        if (end < 0L) {
            return "never";
        }
        return this.returnDate(pattern, end);
    }

    @Override
    public String banExpirationDate(GenericPlayer player, String pattern) {
        Punishment ban = this.ban(player);
        if (ban == null) {
            return null;
        }
        long end = ban.getEnd();
        if (end < 0L) {
            return "never";
        }
        return this.returnDate(pattern, end);
    }

    public String muteDuration(GenericPlayer player, boolean fromStart) {
        Punishment mute = this.mute(player);
        if (mute == null) {
            return null;
        }
        return mute.getDuration(fromStart);
    }

    public String banDuration(GenericPlayer player, boolean fromStart) {
        Punishment ban = this.ban(player);
        if (ban == null) {
            return null;
        }
        return ban.getDuration(fromStart);
    }

    private PunishmentManager getAPI() {
        return PunishmentManager.get();
    }

    private String noDashesUUID(UUID uuid) {
        return this.hexString(uuid.getMostSignificantBits()) + this.hexString(uuid.getLeastSignificantBits());
    }

    private Punishment mute(GenericPlayer player) {
        return this.getAPI().getMute(this.noDashesUUID(player.getUUID()));
    }

    private Punishment ban(GenericPlayer player) {
        return this.getAPI().getBan(this.noDashesUUID(player.getUUID()));
    }

    private String hexString(long unsigned) {
        return Strings.padStart((String)UnsignedLongs.toString((long)unsigned, (int)16), (int)16, (char)'0');
    }
}

