/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.advancedserverlist.banplugins.providers;

import ch.andre601.advancedserverlist.api.objects.GenericPlayer;
import ch.andre601.advancedserverlist.banplugins.providers.PunishmentProvider;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import space.arim.libertybans.api.LibertyBans;
import space.arim.libertybans.api.PunishmentType;
import space.arim.libertybans.api.punish.Punishment;
import space.arim.libertybans.api.select.SelectionByApplicability;
import space.arim.libertybans.api.select.SelectionByApplicabilityBuilder;
import space.arim.libertybans.api.user.KnownAccount;
import space.arim.omnibus.Omnibus;
import space.arim.omnibus.OmnibusProvider;

public class LibertyBansProvider
implements PunishmentProvider {
    private final LibertyBans libertyBans;

    private LibertyBansProvider(LibertyBans libertyBans) {
        this.libertyBans = libertyBans;
    }

    public static LibertyBansProvider create() {
        Omnibus omnibus = OmnibusProvider.getOmnibus();
        LibertyBans libertyBans = (LibertyBans)omnibus.getRegistry().getProvider(LibertyBans.class).orElseThrow();
        return new LibertyBansProvider(libertyBans);
    }

    @Override
    public String muted(GenericPlayer player) {
        return String.valueOf(this.punishment(player.getUUID(), PunishmentType.MUTE) != null);
    }

    @Override
    public String banned(GenericPlayer player) {
        return String.valueOf(this.punishment(player.getUUID(), PunishmentType.BAN) != null);
    }

    @Override
    public String muteReason(GenericPlayer player) {
        Punishment mute = this.punishment(player.getUUID(), PunishmentType.MUTE);
        if (mute == null) {
            return null;
        }
        return mute.getReason();
    }

    @Override
    public String banReason(GenericPlayer player) {
        Punishment ban = this.punishment(player.getUUID(), PunishmentType.BAN);
        if (ban == null) {
            return null;
        }
        return ban.getReason();
    }

    @Override
    public String muteDuration(GenericPlayer player) {
        return null;
    }

    @Override
    public String banDuration(GenericPlayer player) {
        return null;
    }

    @Override
    public String muteExpirationDate(GenericPlayer player, String pattern) {
        Punishment mute = this.punishment(player.getUUID(), PunishmentType.MUTE);
        if (mute == null) {
            return null;
        }
        if (mute.isPermanent()) {
            return "never";
        }
        return this.returnDate(pattern, mute.getEndDate().toEpochMilli());
    }

    @Override
    public String banExpirationDate(GenericPlayer player, String pattern) {
        Punishment ban = this.punishment(player.getUUID(), PunishmentType.BAN);
        if (ban == null) {
            return null;
        }
        if (ban.isPermanent()) {
            return "never";
        }
        return this.returnDate(pattern, ban.getEndDate().toEpochMilli());
    }

    private Punishment punishment(UUID uuid, PunishmentType type) {
        List accounts = (List)this.libertyBans.getAccountSupervisor().findAccountsMatching(uuid).join();
        if (accounts.isEmpty()) {
            return null;
        }
        KnownAccount sorted = Collections.max(accounts, Comparator.comparing(KnownAccount::recorded));
        return ((Optional)((SelectionByApplicability)((SelectionByApplicabilityBuilder)this.libertyBans.getSelector().selectionByApplicabilityBuilder(sorted.uuid(), sorted.address()).type(type)).build()).getFirstSpecificPunishment().toCompletableFuture().join()).orElse(null);
    }
}

