/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.advancedserverlist.banplugins.velocity;

import ch.andre601.advancedserverlist.api.AdvancedServerListAPI;
import ch.andre601.advancedserverlist.banplugins.BanPluginsList;
import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.proxy.ProxyServer;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelocityBanPluginsAddon {
    private final Logger logger = LoggerFactory.getLogger((String)"ASLBanPluginsAddon");
    private final ProxyServer proxy;

    @Inject
    public VelocityBanPluginsAddon(ProxyServer proxy) {
        this.proxy = proxy;
    }

    @Subscribe
    public void init(ProxyInitializeEvent event) {
        if (!this.proxy.getPluginManager().isLoaded("advancedserverlist")) {
            this.logger.warn("AdvancedServerList is not enabled. This plugin requires it to function!");
            return;
        }
        int loadedPlaceholders = this.loadPlaceholderProviders();
        if (loadedPlaceholders == 0) {
            this.logger.warn("No compatible Ban plugin was found to register placeholders for.");
        } else {
            this.logger.info("Loaded {} Placeholder Set(s) for AdvancedServerList!", (Object)loadedPlaceholders);
        }
    }

    private int loadPlaceholderProviders() {
        int loaded = 0;
        AdvancedServerListAPI api = AdvancedServerListAPI.get();
        for (BanPluginsList entry : BanPluginsList.values()) {
            if (!entry.supportsVelocity() || !this.proxy.getPluginManager().isLoaded(entry.getName().toLowerCase(Locale.ROOT))) continue;
            this.logger.info("Registering Placeholders for " + entry.getName() + "...");
            api.addPlaceholderProvider(entry.getPlaceholderProvider());
            this.logger.info("Placeholders successfully registered!");
            ++loaded;
        }
        return loaded;
    }
}

