/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medieval.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.muon.medieval.Medieval;
import dev.muon.medieval.world.structure.StructureRegenerator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.jetbrains.annotations.NotNull;

public abstract class ChallengeOrbItem
extends Item {
    private static final int SEARCH_COOLDOWN = 25;
    private static final int COOLDOWN_TICKS = 600;
    private static final int SEARCH_TIMEOUT_TICKS = 100;

    public ChallengeOrbItem(Item.Properties properties) {
        super(properties);
    }

    protected abstract ChallengeOrbData getData(ItemStack var1);

    protected abstract void setData(ItemStack var1, ChallengeOrbData var2);

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.add((Component)Component.translatable((String)"item.medieval.challenge_orb.tooltip").withStyle(ChatFormatting.GRAY));
    }

    public InteractionResultHolder<ItemStack> use(Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        Medieval.LOG.info("ChallengeOrbItem used by player: {}", (Object)player.getName().getString());
        if (level.isClientSide) {
            return InteractionResultHolder.success((Object)player.getItemInHand(hand));
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack itemStack = player.getItemInHand(hand);
        ChallengeOrbData data = this.getData(itemStack);
        if (data == null || data.foundStructure().isEmpty()) {
            this.findStructure(serverLevel, player, itemStack);
            player.getCooldowns().addCooldown((Item)this, 25);
            return InteractionResultHolder.success((Object)itemStack);
        }
        long currentTime = serverLevel.getGameTime();
        if (currentTime - data.searchTime() > 100L) {
            this.setData(itemStack, new ChallengeOrbData("", 0L));
            this.findStructure(serverLevel, player, itemStack);
            return InteractionResultHolder.success((Object)itemStack);
        }
        this.confirmAndRegenerate(serverLevel, player, itemStack);
        return InteractionResultHolder.success((Object)itemStack);
    }

    private void findStructure(ServerLevel level, Player player, ItemStack itemStack) {
        Registry structureRegistry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
        player.displayClientMessage((Component)Component.literal((String)"Searching for nearby structure...").withStyle(ChatFormatting.YELLOW), true);
        for (Structure structure : structureRegistry) {
            ResourceLocation structureId = structureRegistry.getKey((Object)structure);
            if (structureId != null && StructureRegenerator.isValidStructure(structureId)) {
                StructureStart nearestStructure = StructureRegenerator.findNearestStructure(level, player.blockPosition(), structureId);
                if (nearestStructure != null) {
                    this.setData(itemStack, new ChallengeOrbData(structureId.toString(), level.getGameTime()));
                    player.displayClientMessage((Component)Component.literal((String)("Found structure: " + String.valueOf(structureId) + ". Click again to regenerate.")).withStyle(ChatFormatting.GREEN), true);
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.RESPAWN_ANCHOR_CHARGE, SoundSource.PLAYERS, 1.0f, 2.0f);
                    return;
                }
                Medieval.LOG.debug("No instance of structure {} found nearby", (Object)structureId);
                continue;
            }
            Medieval.LOG.debug("Structure type {} is not valid for regeneration", (Object)structureId);
        }
        player.displayClientMessage((Component)Component.literal((String)"No regeneratable structure found nearby.").withStyle(ChatFormatting.RED), true);
    }

    private void confirmAndRegenerate(ServerLevel level, Player player, ItemStack itemStack) {
        ChallengeOrbData data = this.getData(itemStack);
        if (data != null && data.foundStructure() != null) {
            try {
                ResourceLocation structureId = ResourceLocation.parse((String)data.foundStructure());
                player.displayClientMessage((Component)Component.literal((String)("Regenerating structure: " + String.valueOf(structureId))).withStyle(ChatFormatting.YELLOW), true);
                StructureRegenerator.RegenerationResult result = StructureRegenerator.regenerateStructure(level, player.blockPosition(), structureId);
                if (result.success) {
                    player.displayClientMessage((Component)Component.literal((String)("Success! " + result.message)).withStyle(ChatFormatting.GREEN), true);
                    player.getCooldowns().addCooldown((Item)this, 600);
                    this.setData(itemStack, new ChallengeOrbData("", 0L));
                    if (!player.getAbilities().instabuild) {
                        itemStack.shrink(1);
                    }
                } else {
                    player.displayClientMessage((Component)Component.literal((String)("Failed: " + result.message)).withStyle(ChatFormatting.RED), true);
                }
            }
            catch (ResourceLocationException e) {
                Medieval.LOG.error("Invalid structure ID: {}", (Object)data.foundStructure(), (Object)e);
                player.displayClientMessage((Component)Component.literal((String)"Error: Invalid structure ID").withStyle(ChatFormatting.RED), true);
            }
        }
    }

    public record ChallengeOrbData(String foundStructure, long searchTime) {
        public static final Codec<ChallengeOrbData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("foundStructure", (Object)"").forGetter(ChallengeOrbData::foundStructure), (App)Codec.LONG.fieldOf("searchTime").forGetter(ChallengeOrbData::searchTime)).apply((Applicative)instance, ChallengeOrbData::new));
    }
}

